/*
 * Decompiled with CFR 0.152.
 */
package main.com.mingtech.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    static final String split_str = "#__#";

    public String httpGet(String url) {
        return this.httpGet(url, null);
    }

    public String httpGet(String url, Map<String, String> headMap) {
        String responseContent = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            try {
                HttpGet httpGet = new HttpGet(url);
                this.setGetHead(httpGet, headMap);
                CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    HttpEntity entity = response1.getEntity();
                    responseContent = this.getRespString(entity);
                    EntityUtils.consume((HttpEntity)entity);
                }
                finally {
                    response1.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    httpclient.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    public String httpPost(String url) {
        return this.httpPost(url, null);
    }

    public String httpPost(String url, Map<String, String> paramsMap) {
        return this.httpPost(url, paramsMap, null);
    }

    public String httpPost(String url, Map<String, String> paramsMap, Map<String, String> headMap) {
        String responseContent = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            try {
                HttpPost httpPost = new HttpPost(url);
                this.setPostHead(httpPost, headMap);
                this.setPostParams(httpPost, paramsMap);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                try {
                    HttpEntity entity = response.getEntity();
                    responseContent = this.getRespString(entity);
                    EntityUtils.consume((HttpEntity)entity);
                }
                finally {
                    response.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    httpclient.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    public String httpPostFile(String url, Map<String, String> paramsMap, Map<String, String> headMap, File file, byte[] small) {
        String responseContent = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            try {
                HttpPost httpPost = new HttpPost(url);
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
                multipartEntityBuilder.addBinaryBody("file", file, ContentType.MULTIPART_FORM_DATA, "1#__#" + file.getName());
                if (small != null) {
                    multipartEntityBuilder.addBinaryBody("small", small, ContentType.MULTIPART_FORM_DATA, "1#__#small" + file.getName());
                }
                this.setUploadParams(multipartEntityBuilder, paramsMap);
                this.setPostHead(httpPost, headMap);
                HttpEntity reqEntity = multipartEntityBuilder.build();
                httpPost.setEntity(reqEntity);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                try {
                    HttpEntity entity = response.getEntity();
                    responseContent = this.getRespString(entity);
                    EntityUtils.consume((HttpEntity)entity);
                }
                finally {
                    response.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    httpclient.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    public String httpPostFile(String url, Map<String, String> paramsMap, Map<String, String> headMap, byte[] fileByte, byte[] small, String fileName) {
        String responseContent = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            try {
                HttpPost httpPost = new HttpPost(url);
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
                multipartEntityBuilder.addBinaryBody("file", fileByte, ContentType.MULTIPART_FORM_DATA, "1#__#" + fileName);
                if (small != null) {
                    multipartEntityBuilder.addBinaryBody("small", small, ContentType.MULTIPART_FORM_DATA, "1#__#small" + fileName);
                }
                this.setUploadParams(multipartEntityBuilder, paramsMap);
                this.setPostHead(httpPost, headMap);
                HttpEntity reqEntity = multipartEntityBuilder.build();
                httpPost.setEntity(reqEntity);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                try {
                    HttpEntity entity = response.getEntity();
                    responseContent = this.getRespString(entity);
                    EntityUtils.consume((HttpEntity)entity);
                }
                finally {
                    response.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    httpclient.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    private void setUploadParams(MultipartEntityBuilder multipartEntityBuilder, Map<String, String> params) {
        if (params != null && params.size() > 0) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                multipartEntityBuilder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.TEXT_PLAIN));
            }
        }
    }

    private void setPostParams(HttpPost httpPost, Map<String, String> paramsMap) throws Exception {
        if (paramsMap != null && paramsMap.size() > 0) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = paramsMap.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, paramsMap.get(key)));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
    }

    private void setPostHead(HttpPost httpPost, Map<String, String> headMap) {
        if (headMap != null && headMap.size() > 0) {
            Set<String> keySet = headMap.keySet();
            for (String key : keySet) {
                httpPost.addHeader(key, headMap.get(key));
            }
        }
    }

    private void setGetHead(HttpGet httpGet, Map<String, String> headMap) {
        if (headMap != null && headMap.size() > 0) {
            Set<String> keySet = headMap.keySet();
            for (String key : keySet) {
                httpGet.addHeader(key, headMap.get(key));
            }
        }
    }

    private String getRespString(HttpEntity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        StringBuffer strBuf = new StringBuffer();
        byte[] buffer = new byte[128];
        int r = 0;
        while ((r = is.read(buffer)) > 0) {
            strBuf.append(new String(buffer, 0, r, "UTF-8"));
        }
        return strBuf.toString();
    }
}

