/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl.fonts.truetype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.OpenFont;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.fop.render.pcl.fonts.PCLByteWriterUtil;
import org.apache.fop.render.pcl.fonts.PCLFontReader;
import org.apache.fop.render.pcl.fonts.PCLFontSegment;
import org.apache.fop.render.pcl.fonts.PCLSymbolSet;
import org.apache.fop.render.pcl.fonts.truetype.PCLTTFOS2FontTable;
import org.apache.fop.render.pcl.fonts.truetype.PCLTTFPCLTFontTable;
import org.apache.fop.render.pcl.fonts.truetype.PCLTTFPOSTFontTable;
import org.apache.fop.render.pcl.fonts.truetype.PCLTTFTable;
import org.apache.fop.render.pcl.fonts.truetype.PCLTTFTableFactory;

public class PCLTTFFontReader
extends PCLFontReader {
    protected TTFFile ttfFont;
    protected InputStream fontStream;
    protected FontFileReader reader;
    private PCLTTFPCLTFontTable pcltTable;
    private PCLTTFOS2FontTable os2Table;
    private PCLTTFPOSTFontTable postTable;
    private PCLTTFTableFactory ttfTableFactory;
    private Map<Integer, int[]> charOffsets;
    private Map<Integer, Integer> charMtxOffsets;
    private static final int HMTX_RESTRICT_SIZE = 50000;
    private static final Map<Integer, Integer> FONT_WEIGHT = new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(100, -6);
            this.put(200, -4);
            this.put(300, -3);
            this.put(400, 0);
            this.put(500, 0);
            this.put(600, 2);
            this.put(700, 3);
            this.put(800, 4);
            this.put(900, 5);
        }
    };
    private static final Map<Integer, Integer> FONT_SERIF = new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, 0);
            this.put(1, 64);
            this.put(2, 9);
            this.put(3, 12);
            this.put(4, 10);
            this.put(5, 0);
            this.put(6, 128);
            this.put(7, 2);
            this.put(8, 7);
            this.put(9, 11);
            this.put(10, 3);
            this.put(11, 0);
            this.put(12, 4);
            this.put(13, 6);
            this.put(14, 8);
            this.put(15, 1);
        }
    };
    private static final Map<Integer, Integer> FONT_WIDTH = new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1, -5);
            this.put(2, -4);
            this.put(3, -3);
            this.put(4, -2);
            this.put(5, 0);
            this.put(6, 2);
            this.put(7, 3);
        }
    };
    private int scaleFactor = -1;
    private PCLSymbolSet symbolSet = PCLSymbolSet.Bound_Generic;

    public PCLTTFFontReader(Typeface font) throws IOException {
        super(font);
        this.loadFont();
    }

    protected void loadFont() throws IOException {
        if (this.typeface instanceof CustomFontMetricsMapper) {
            CustomFontMetricsMapper fontMetrics = (CustomFontMetricsMapper)this.typeface;
            CustomFont font = (CustomFont)fontMetrics.getRealFont();
            this.setFont((CustomFont)fontMetrics.getRealFont());
            String fontName = font.getFullName();
            this.fontStream = font.getInputStream();
            this.reader = new FontFileReader(this.fontStream);
            this.ttfFont = new TTFFile();
            String header = OFFontLoader.readHeader(this.reader);
            this.ttfFont.readFont(this.reader, header, fontName);
            this.readFontTables();
        }
    }

    protected void readFontTables() throws IOException {
        PCLTTFTable fontTable = this.readFontTable(OFTableName.PCLT);
        if (fontTable instanceof PCLTTFPCLTFontTable) {
            this.pcltTable = (PCLTTFPCLTFontTable)fontTable;
        }
        if ((fontTable = this.readFontTable(OFTableName.OS2)) instanceof PCLTTFOS2FontTable) {
            this.os2Table = (PCLTTFOS2FontTable)fontTable;
        }
        if ((fontTable = this.readFontTable(OFTableName.POST)) instanceof PCLTTFPOSTFontTable) {
            this.postTable = (PCLTTFPOSTFontTable)fontTable;
        }
    }

    private PCLTTFTable readFontTable(OFTableName tableName) throws IOException {
        if (this.ttfFont.seekTab(this.reader, tableName, 0L)) {
            return this.getTTFTableFactory().newInstance(tableName);
        }
        return null;
    }

    private PCLTTFTableFactory getTTFTableFactory() {
        if (this.ttfTableFactory == null) {
            this.ttfTableFactory = PCLTTFTableFactory.getInstance(this.reader);
        }
        return this.ttfTableFactory;
    }

    @Override
    public int getDescriptorSize() {
        return 72;
    }

    @Override
    public int getHeaderFormat() {
        return 15;
    }

    @Override
    public int getFontType() {
        if (this.symbolSet == PCLSymbolSet.Unbound) {
            return 11;
        }
        return 2;
    }

    @Override
    public int getStyleMSB() {
        if (this.pcltTable != null) {
            return this.getMSB(this.pcltTable.getStyle());
        }
        return 3;
    }

    @Override
    public int getBaselinePosition() {
        return 0;
    }

    @Override
    public int getCellWidth() {
        int[] bbox = this.ttfFont.getBBoxRaw();
        return bbox[2] - bbox[0];
    }

    @Override
    public int getCellHeight() {
        int[] bbox = this.ttfFont.getBBoxRaw();
        return bbox[3] - bbox[1];
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public int getSpacing() {
        if (this.os2Table != null) {
            return this.os2Table.getPanose()[4] == 9 ? 0 : 1;
        }
        if (this.postTable != null) {
            return this.postTable.getIsFixedPitch();
        }
        return 1;
    }

    @Override
    public int getSymbolSet() {
        if (this.pcltTable != null) {
            return this.pcltTable.getSymbolSet();
        }
        return this.symbolSet.getKind1();
    }

    @Override
    public int getPitch() {
        int pitch = this.ttfFont.getCharWidthRaw(32);
        if (pitch < 0) {
            return 0;
        }
        return pitch;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public int getXHeight() {
        if (this.pcltTable != null) {
            return this.pcltTable.getXHeight();
        }
        if (this.os2Table != null) {
            return this.os2Table.getXHeight();
        }
        return 0;
    }

    @Override
    public int getWidthType() {
        if (this.pcltTable != null) {
            return this.pcltTable.getWidthType();
        }
        if (this.os2Table != null) {
            return this.convertTTFWidthClass(this.os2Table.getWidthClass());
        }
        return 0;
    }

    private int convertTTFWidthClass(int widthClass) {
        if (FONT_WIDTH.containsKey(widthClass)) {
            return FONT_WIDTH.get(widthClass);
        }
        return 0;
    }

    @Override
    public int getStyleLSB() {
        if (this.pcltTable != null) {
            return this.getLSB(this.pcltTable.getStyle());
        }
        return 224;
    }

    @Override
    public int getStrokeWeight() {
        if (this.pcltTable != null) {
            return this.pcltTable.getStrokeWeight();
        }
        if (this.os2Table != null) {
            return this.convertTTFWeightClass(this.os2Table.getWeightClass());
        }
        return 0;
    }

    private int convertTTFWeightClass(int weightClass) {
        if (FONT_WEIGHT.containsKey(weightClass)) {
            return FONT_WEIGHT.get(weightClass);
        }
        return 0;
    }

    @Override
    public int getTypefaceLSB() {
        if (this.pcltTable != null) {
            return this.getLSB(this.pcltTable.getTypeFamily());
        }
        return 254;
    }

    @Override
    public int getTypefaceMSB() {
        if (this.pcltTable != null) {
            return this.getMSB(this.pcltTable.getTypeFamily());
        }
        return 0;
    }

    @Override
    public int getSerifStyle() {
        if (this.pcltTable != null) {
            return this.pcltTable.getSerifStyle();
        }
        return this.convertFromTTFSerifStyle();
    }

    private int convertFromTTFSerifStyle() {
        if (this.os2Table != null) {
            int serifStyle = this.os2Table.getPanose()[1];
            return FONT_SERIF.get(serifStyle);
        }
        return 0;
    }

    @Override
    public int getQuality() {
        return 2;
    }

    @Override
    public int getPlacement() {
        return 0;
    }

    @Override
    public int getUnderlinePosition() {
        return 0;
    }

    @Override
    public int getUnderlineThickness() {
        return 0;
    }

    @Override
    public int getTextHeight() {
        return 2048;
    }

    @Override
    public int getTextWidth() {
        if (this.os2Table != null) {
            return this.os2Table.getAvgCharWidth();
        }
        return 0;
    }

    @Override
    public int getFirstCode() {
        return 32;
    }

    @Override
    public int getLastCode() {
        return 255;
    }

    @Override
    public int getPitchExtended() {
        return 0;
    }

    @Override
    public int getHeightExtended() {
        return 0;
    }

    @Override
    public int getCapHeight() {
        if (this.pcltTable != null) {
            return this.pcltTable.getStrokeWeight();
        }
        if (this.os2Table != null) {
            return this.os2Table.getCapHeight();
        }
        return 0;
    }

    @Override
    public int getFontNumber() {
        if (this.pcltTable != null) {
            return (int)this.pcltTable.getFontNumber();
        }
        return 0;
    }

    @Override
    public String getFontName() {
        if (this.pcltTable != null) {
            return this.pcltTable.getTypeface();
        }
        return this.ttfFont.getFullName();
    }

    @Override
    public int getScaleFactor() throws IOException {
        if (this.scaleFactor == -1) {
            OFTableName headTag = OFTableName.HEAD;
            if (this.ttfFont.seekTab(this.reader, headTag, 0L)) {
                this.reader.readTTFLong();
                this.reader.readTTFLong();
                this.reader.readTTFLong();
                this.reader.readTTFLong();
                this.reader.readTTFShort();
                this.scaleFactor = this.reader.readTTFUShort();
                return this.scaleFactor;
            }
        } else {
            return this.scaleFactor;
        }
        return 0;
    }

    @Override
    public int getMasterUnderlinePosition() throws IOException {
        return (int)Math.round((double)this.getScaleFactor() * 0.2);
    }

    @Override
    public int getMasterUnderlineThickness() throws IOException {
        return (int)Math.round((double)this.getScaleFactor() * 0.05);
    }

    @Override
    public int getFontScalingTechnology() {
        return 1;
    }

    @Override
    public int getVariety() {
        return 0;
    }

    @Override
    public List<PCLFontSegment> getFontSegments(Map<Character, Integer> mappedGlyphs) throws IOException {
        ArrayList<PCLFontSegment> fontSegments = new ArrayList<PCLFontSegment>();
        fontSegments.add(new PCLFontSegment(PCLFontSegment.SegmentID.CC, this.getCharacterComplement()));
        fontSegments.add(new PCLFontSegment(PCLFontSegment.SegmentID.PA, PCLByteWriterUtil.toByteArray(this.os2Table.getPanose())));
        fontSegments.add(new PCLFontSegment(PCLFontSegment.SegmentID.GT, this.getGlobalTrueTypeData(mappedGlyphs)));
        fontSegments.add(new PCLFontSegment(PCLFontSegment.SegmentID.CP, this.ttfFont.getCopyrightNotice().getBytes("US-ASCII")));
        fontSegments.add(new PCLFontSegment(PCLFontSegment.SegmentID.NULL, new byte[0]));
        return fontSegments;
    }

    private byte[] getCharacterComplement() {
        byte[] ccUnicode = new byte[8];
        ccUnicode[7] = 6;
        return ccUnicode;
    }

    private byte[] getGlobalTrueTypeData(Map<Character, Integer> mappedGlyphs) throws IOException {
        OFDirTabEntry prepTable;
        OFDirTabEntry fpgmTable;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayList<TableOffset> tableOffsets = new ArrayList<TableOffset>();
        baos.write(PCLByteWriterUtil.unsignedInt(1));
        baos.write(PCLByteWriterUtil.unsignedInt(0));
        int numTables = 5;
        OFDirTabEntry headTable = this.ttfFont.getDirectoryEntry(OFTableName.CVT);
        if (headTable != null) {
            ++numTables;
        }
        if ((fpgmTable = this.ttfFont.getDirectoryEntry(OFTableName.FPGM)) != null) {
            ++numTables;
        }
        if ((prepTable = this.ttfFont.getDirectoryEntry(OFTableName.PREP)) != null) {
            ++numTables;
        }
        baos.write(PCLByteWriterUtil.unsignedInt(numTables));
        int maxPowerNumTables = PCLByteWriterUtil.maxPower2(numTables);
        int searchRange = maxPowerNumTables * 16;
        baos.write(PCLByteWriterUtil.unsignedInt(searchRange));
        baos.write(PCLByteWriterUtil.unsignedInt(PCLByteWriterUtil.log(maxPowerNumTables, 2)));
        baos.write(PCLByteWriterUtil.unsignedInt(numTables * 16 - searchRange));
        this.writeTrueTypeTable(baos, OFTableName.HEAD, tableOffsets);
        this.writeTrueTypeTable(baos, OFTableName.HHEA, tableOffsets);
        byte[] hmtxTable = this.createHmtx(mappedGlyphs);
        this.writeSubsetHMTX(baos, OFTableName.HMTX, tableOffsets, hmtxTable);
        this.writeTrueTypeTable(baos, OFTableName.MAXP, tableOffsets);
        this.writeGDIR(baos);
        this.writeTrueTypeTable(baos, OFTableName.CVT, tableOffsets);
        this.writeTrueTypeTable(baos, OFTableName.FPGM, tableOffsets);
        this.writeTrueTypeTable(baos, OFTableName.PREP, tableOffsets);
        baos = this.copyTables(tableOffsets, baos, hmtxTable, mappedGlyphs.size());
        return baos.toByteArray();
    }

    private void writeTrueTypeTable(ByteArrayOutputStream baos, OFTableName table, List<TableOffset> tableOffsets) throws IOException, UnsupportedEncodingException {
        OFDirTabEntry tabEntry = this.ttfFont.getDirectoryEntry(table);
        if (tabEntry != null) {
            baos.write(tabEntry.getTag());
            baos.write(PCLByteWriterUtil.unsignedLongInt(tabEntry.getChecksum()));
            TableOffset newTableOffset = new TableOffset(tabEntry.getOffset(), tabEntry.getLength(), baos.size());
            tableOffsets.add(newTableOffset);
            baos.write(PCLByteWriterUtil.unsignedLongInt(0));
            baos.write(PCLByteWriterUtil.unsignedLongInt(tabEntry.getLength()));
        }
    }

    private void writeGDIR(ByteArrayOutputStream baos) throws UnsupportedEncodingException, IOException {
        baos.write("gdir".getBytes("ISO-8859-1"));
        baos.write(PCLByteWriterUtil.unsignedLongInt(0));
        baos.write(PCLByteWriterUtil.unsignedLongInt(0));
        baos.write(PCLByteWriterUtil.unsignedLongInt(0));
    }

    private ByteArrayOutputStream copyTables(List<TableOffset> tableOffsets, ByteArrayOutputStream baos, byte[] hmtxTable, int hmtxSize) throws IOException {
        HashMap<Integer, byte[]> offsetValues = new HashMap<Integer, byte[]>();
        for (TableOffset tableOffset : tableOffsets) {
            offsetValues.put(tableOffset.getNewOffset(), PCLByteWriterUtil.unsignedLongInt(baos.size()));
            if (tableOffset.getOriginOffset() == -1L) {
                baos.write(hmtxTable);
                continue;
            }
            byte[] tableData = this.reader.getBytes((int)tableOffset.getOriginOffset(), (int)tableOffset.getOriginLength());
            int index = tableOffsets.indexOf(tableOffset);
            if (index == 1) {
                tableData = this.updateHHEA(tableData, hmtxSize + 33);
            }
            baos.write(tableData);
        }
        baos = this.updateOffsets(baos, offsetValues);
        return baos;
    }

    private byte[] updateHHEA(byte[] tableData, int hmtxSize) {
        this.writeUShort(tableData, tableData.length - 2, hmtxSize);
        return tableData;
    }

    private ByteArrayOutputStream updateOffsets(ByteArrayOutputStream baos, Map<Integer, byte[]> offsets) throws IOException {
        byte[] softFont = baos.toByteArray();
        for (Map.Entry<Integer, byte[]> integerEntry : offsets.entrySet()) {
            PCLByteWriterUtil.updateDataAtLocation(softFont, integerEntry.getValue(), integerEntry.getKey());
        }
        baos = new ByteArrayOutputStream();
        baos.write(softFont);
        return baos;
    }

    @Override
    public Map<Integer, int[]> getCharacterOffsets() throws IOException {
        if (this.charOffsets == null) {
            List<OFMtxEntry> mtx = this.ttfFont.getMtx();
            OFTableName glyfTag = OFTableName.GLYF;
            this.charOffsets = new HashMap<Integer, int[]>();
            OFDirTabEntry tabEntry = this.ttfFont.getDirectoryEntry(glyfTag);
            if (this.ttfFont.seekTab(this.reader, glyfTag, 0L)) {
                for (int i = 1; i < mtx.size(); ++i) {
                    OFMtxEntry entry = mtx.get(i);
                    int nextOffset = 0;
                    int charCode = 0;
                    charCode = entry.getUnicodeIndex().size() > 0 ? ((Integer)entry.getUnicodeIndex().get(0)).intValue() : entry.getIndex();
                    if (i < mtx.size() - 1) {
                        OFMtxEntry nextEntry = mtx.get(i + 1);
                        nextOffset = (int)nextEntry.getOffset();
                    } else {
                        nextOffset = (int)this.ttfFont.getLastGlyfLocation();
                    }
                    int glyphOffset = (int)entry.getOffset();
                    int glyphLength = nextOffset - glyphOffset;
                    this.charOffsets.put(charCode, new int[]{(int)tabEntry.getOffset() + glyphOffset, glyphLength});
                }
            }
        }
        return this.charOffsets;
    }

    @Override
    public OpenFont getFontFile() {
        return this.ttfFont;
    }

    @Override
    public FontFileReader getFontFileReader() {
        return this.reader;
    }

    private void writeSubsetHMTX(ByteArrayOutputStream baos, OFTableName table, List<TableOffset> tableOffsets, byte[] hmtxTable) throws IOException {
        OFDirTabEntry tabEntry = this.ttfFont.getDirectoryEntry(table);
        if (tabEntry != null) {
            baos.write(tabEntry.getTag());
            baos.write(PCLByteWriterUtil.unsignedLongInt(PCLTTFFontReader.getCheckSum(hmtxTable, 0, hmtxTable.length)));
            TableOffset newTableOffset = new TableOffset(-1L, hmtxTable.length, baos.size());
            tableOffsets.add(newTableOffset);
            baos.write(PCLByteWriterUtil.unsignedLongInt(0));
            baos.write(PCLByteWriterUtil.unsignedLongInt(hmtxTable.length));
        }
    }

    protected static int getCheckSum(byte[] data, int start, int size) {
        int remainder = size % 4;
        if (remainder != 0) {
            size += remainder;
        }
        long sum = 0L;
        for (int i = 0; i < size; i += 4) {
            long l = 0L;
            for (int j = 0; j < 4; ++j) {
                l <<= 8;
                if (data.length <= start + i + j) continue;
                l |= (long)(data[start + i + j] & 0xFF);
            }
            sum += l;
        }
        return (int)sum;
    }

    protected byte[] createHmtx(Map<Character, Integer> mappedGlyphs) throws IOException {
        byte[] hmtxTable = new byte[(mappedGlyphs.size() + 32) * 4];
        OFDirTabEntry entry = this.ttfFont.getDirectoryEntry(OFTableName.HMTX);
        if (entry != null) {
            for (Map.Entry<Character, Integer> glyphSubset : mappedGlyphs.entrySet()) {
                char unicode = glyphSubset.getKey().charValue();
                int originalIndex = 0;
                int softFontGlyphIndex = glyphSubset.getValue();
                if (this.font instanceof MultiByteFont) {
                    originalIndex = ((MultiByteFont)this.font).getGIDFromChar(unicode);
                    this.writeUShort(hmtxTable, softFontGlyphIndex * 4, this.ttfFont.getMtx().get(originalIndex).getWx());
                    this.writeUShort(hmtxTable, softFontGlyphIndex * 4 + 2, this.ttfFont.getMtx().get(originalIndex).getLsb());
                    continue;
                }
                originalIndex = ((SingleByteFont)this.font).getGIDFromChar(unicode);
                this.writeUShort(hmtxTable, softFontGlyphIndex * 4, this.font.getWidth(originalIndex, 1));
                this.writeUShort(hmtxTable, softFontGlyphIndex * 4 + 2, 0);
            }
        }
        return hmtxTable;
    }

    private void writeUShort(byte[] out, int offset, int s) {
        byte b1 = (byte)(s >> 8 & 0xFF);
        byte b2 = (byte)(s & 0xFF);
        out[offset] = b1;
        out[offset + 1] = b2;
    }

    @Override
    public Map<Integer, Integer> scanMtxCharacters() throws IOException {
        if (this.charMtxOffsets == null) {
            this.charMtxOffsets = new HashMap<Integer, Integer>();
            List<OFMtxEntry> mtx = this.ttfFont.getMtx();
            OFTableName glyfTag = OFTableName.GLYF;
            if (this.ttfFont.seekTab(this.reader, glyfTag, 0L)) {
                for (int i = 1; i < mtx.size(); ++i) {
                    OFMtxEntry entry = mtx.get(i);
                    int charCode = 0;
                    charCode = entry.getUnicodeIndex().size() > 0 ? ((Integer)entry.getUnicodeIndex().get(0)).intValue() : entry.getIndex();
                    this.charMtxOffsets.put(charCode, i);
                }
            }
        }
        return this.charMtxOffsets;
    }

    private static class TableOffset {
        private long originOffset;
        private long originLength;
        private int newOffset;

        public TableOffset(long originOffset, long originLength, int newOffset) {
            this.originOffset = originOffset;
            this.originLength = originLength;
            this.newOffset = newOffset;
        }

        public long getOriginOffset() {
            return this.originOffset;
        }

        public long getOriginLength() {
            return this.originLength;
        }

        public int getNewOffset() {
            return this.newOffset;
        }
    }
}

