/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4;

import com.alibaba.qlexpress4.InitOptions;
import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.QLResult;
import com.alibaba.qlexpress4.aparser.GeneratorScope;
import com.alibaba.qlexpress4.aparser.ImportManager;
import com.alibaba.qlexpress4.aparser.MacroDefine;
import com.alibaba.qlexpress4.aparser.OutFunctionVisitor;
import com.alibaba.qlexpress4.aparser.OutVarNamesVisitor;
import com.alibaba.qlexpress4.aparser.QCompileCache;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.QvmInstructionVisitor;
import com.alibaba.qlexpress4.aparser.SyntaxTreeFactory;
import com.alibaba.qlexpress4.aparser.TraceExpressionVisitor;
import com.alibaba.qlexpress4.aparser.compiletimefunction.CompileTimeFunction;
import com.alibaba.qlexpress4.api.BatchAddFunctionResult;
import com.alibaba.qlexpress4.api.QLFunctionalVarargs;
import com.alibaba.qlexpress4.exception.PureErrReporter;
import com.alibaba.qlexpress4.exception.QLException;
import com.alibaba.qlexpress4.exception.QLSyntaxException;
import com.alibaba.qlexpress4.runtime.DelegateQContext;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinitionInner;
import com.alibaba.qlexpress4.runtime.QLambdaTrace;
import com.alibaba.qlexpress4.runtime.QvmGlobalScope;
import com.alibaba.qlexpress4.runtime.QvmRuntime;
import com.alibaba.qlexpress4.runtime.ReflectLoader;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.context.ExpressContext;
import com.alibaba.qlexpress4.runtime.context.MapExpressContext;
import com.alibaba.qlexpress4.runtime.context.ObjectFieldExpressContext;
import com.alibaba.qlexpress4.runtime.context.QLAliasContext;
import com.alibaba.qlexpress4.runtime.function.CustomFunction;
import com.alibaba.qlexpress4.runtime.function.QMethodFunction;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.operator.CustomBinaryOperator;
import com.alibaba.qlexpress4.runtime.operator.OperatorManager;
import com.alibaba.qlexpress4.runtime.trace.ExpressionTrace;
import com.alibaba.qlexpress4.runtime.trace.QTraces;
import com.alibaba.qlexpress4.runtime.trace.TracePointTree;
import com.alibaba.qlexpress4.utils.BasicUtil;
import com.alibaba.qlexpress4.utils.QLFunctionUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Express4Runner {
    private final OperatorManager operatorManager = new OperatorManager();
    private final Map<String, Future<QCompileCache>> compileCache = new ConcurrentHashMap<String, Future<QCompileCache>>();
    private final Map<String, CustomFunction> userDefineFunction = new ConcurrentHashMap<String, CustomFunction>();
    private final Map<String, CompileTimeFunction> compileTimeFunctions = new ConcurrentHashMap<String, CompileTimeFunction>();
    private final GeneratorScope globalScope = new GeneratorScope(null, "global", new ConcurrentHashMap<String, MacroDefine>());
    private final ReflectLoader reflectLoader;
    private final InitOptions initOptions;

    public Express4Runner(InitOptions initOptions) {
        this.initOptions = initOptions;
        this.reflectLoader = new ReflectLoader(initOptions.getSecurityStrategy(), initOptions.getExtensionFunctions(), initOptions.isAllowPrivateAccess());
        SyntaxTreeFactory.warmUp();
    }

    public CustomFunction getFunction(String functionName) {
        return this.userDefineFunction.get(functionName);
    }

    public CompileTimeFunction getCompileTimeFunction(String functionName) {
        return this.compileTimeFunctions.get(functionName);
    }

    public QLResult execute(String script, Map<String, Object> context, QLOptions qlOptions) throws QLException {
        return this.execute(script, new MapExpressContext(context), qlOptions);
    }

    public QLResult execute(String script, Object context, QLOptions qlOptions) throws QLException {
        return this.execute(script, new ObjectFieldExpressContext(context, this), qlOptions);
    }

    public QLResult executeWithAliasObjects(String script, QLOptions qlOptions, Object ... objects) {
        return this.execute(script, new QLAliasContext(objects), qlOptions);
    }

    public QLResult execute(String script, ExpressContext context, QLOptions qlOptions) {
        QLambdaTrace mainLambdaTrace;
        if (this.initOptions.isDebug()) {
            long start = System.currentTimeMillis();
            mainLambdaTrace = this.parseToLambda(script, context, qlOptions);
            this.initOptions.getDebugInfoConsumer().accept("Compile consume time: " + (System.currentTimeMillis() - start) + " ms");
        } else {
            mainLambdaTrace = this.parseToLambda(script, context, qlOptions);
        }
        QLambda mainLambda = mainLambdaTrace.getqLambda();
        try {
            Object result;
            if (this.initOptions.isDebug()) {
                long start = System.currentTimeMillis();
                result = mainLambda.call(new Object[0]).getResult().get();
                this.initOptions.getDebugInfoConsumer().accept("Execute consume time: " + (System.currentTimeMillis() - start) + " ms");
            } else {
                result = mainLambda.call(new Object[0]).getResult().get();
            }
            return new QLResult(result, mainLambdaTrace.getTraces().getExpressionTraces());
        }
        catch (QLException e) {
            throw e;
        }
        catch (Throwable nuKnown) {
            throw new RuntimeException(nuKnown);
        }
    }

    private QTraces convertPoints2QTraces(List<TracePointTree> expressionTracePoints) {
        HashMap<Integer, ExpressionTrace> traceMap = new HashMap<Integer, ExpressionTrace>();
        List<ExpressionTrace> expressionTraces = expressionTracePoints.stream().map(tracePoint -> this.convertPoint2Trace((TracePointTree)tracePoint, (Map<Integer, ExpressionTrace>)traceMap)).collect(Collectors.toList());
        return new QTraces(expressionTraces, traceMap);
    }

    private ExpressionTrace convertPoint2Trace(TracePointTree tree, Map<Integer, ExpressionTrace> traceMap) {
        if (tree.getChildren().isEmpty()) {
            ExpressionTrace result = new ExpressionTrace(tree.getType(), tree.getToken(), Collections.emptyList(), tree.getLine(), tree.getCol(), tree.getPosition());
            traceMap.put(result.getPosition(), result);
            return result;
        }
        List<ExpressionTrace> mergedChildren = tree.getChildren().stream().map(child -> this.convertPoint2Trace((TracePointTree)child, traceMap)).collect(Collectors.toList());
        ExpressionTrace result = new ExpressionTrace(tree.getType(), tree.getToken(), mergedChildren, tree.getLine(), tree.getCol(), tree.getPosition());
        traceMap.put(result.getPosition(), result);
        return result;
    }

    public Set<String> getOutVarNames(String script) {
        QLParser.ProgramContext programContext = this.parseToSyntaxTree(script);
        OutVarNamesVisitor outVarNamesVisitor = new OutVarNamesVisitor(this.inheritDefaultImport());
        programContext.accept(outVarNamesVisitor);
        return outVarNamesVisitor.getOutVars();
    }

    public Set<String> getOutFunctions(String script) {
        QLParser.ProgramContext programContext = this.parseToSyntaxTree(script);
        OutFunctionVisitor outFunctionVisitor = new OutFunctionVisitor();
        programContext.accept(outFunctionVisitor);
        return outFunctionVisitor.getOutFunctions();
    }

    public List<TracePointTree> getExpressionTracePoints(String script) {
        QLParser.ProgramContext programContext = this.parseToSyntaxTree(script);
        TraceExpressionVisitor traceExpressionVisitor = new TraceExpressionVisitor();
        programContext.accept(traceExpressionVisitor);
        return traceExpressionVisitor.getExpressionTracePoints();
    }

    public boolean addMacro(String name, String macroScript) {
        return this.globalScope.defineMacroIfAbsent(name, this.parseMacroDefine(name, macroScript));
    }

    public void addOrReplaceMacro(String name, String macroScript) {
        this.globalScope.defineMacro(name, this.parseMacroDefine(name, macroScript));
    }

    private MacroDefine parseMacroDefine(String name, String macroScript) {
        QLParser.ProgramContext macroProgram = this.parseToSyntaxTree(macroScript);
        QvmInstructionVisitor macroVisitor = new QvmInstructionVisitor(macroScript, this.inheritDefaultImport(), new GeneratorScope("MACRO_" + name, this.globalScope), this.operatorManager, QvmInstructionVisitor.Context.MACRO, this.compileTimeFunctions, this.initOptions);
        macroProgram.accept(macroVisitor);
        List<QLInstruction> macroInstructions = macroVisitor.getInstructions();
        List<QLParser.BlockStatementContext> blockStatementContexts = macroProgram.blockStatements().blockStatement();
        boolean lastStmtExpress = !blockStatementContexts.isEmpty() && blockStatementContexts.get(blockStatementContexts.size() - 1) instanceof QLParser.ExpressionStatementContext;
        return new MacroDefine(macroInstructions, lastStmtExpress);
    }

    public boolean addFunction(String name, CustomFunction function) {
        CustomFunction preFunction = this.userDefineFunction.putIfAbsent(name, function);
        return preFunction == null;
    }

    public <T, R> boolean addFunction(String name, Function<T, R> function) {
        return this.addFunction(name, (QContext qContext, Parameters parameters) -> {
            Object t = parameters.size() > 0 ? parameters.get(0).get() : null;
            return function.apply(t);
        });
    }

    public boolean addVarArgsFunction(String name, QLFunctionalVarargs functionalVarargs) {
        return this.addFunction(name, (QContext qContext, Parameters parameters) -> {
            Object[] paramArr = new Object[parameters.size()];
            for (int i = 0; i < paramArr.length; ++i) {
                paramArr[i] = parameters.get(i).get();
            }
            return functionalVarargs.call(paramArr);
        });
    }

    public <T> boolean addFunction(String name, Predicate<T> predicate) {
        return this.addFunction(name, (QContext qContext, Parameters parameters) -> {
            Object t = parameters.size() > 0 ? parameters.get(0).get() : null;
            return predicate.test(t);
        });
    }

    public boolean addFunction(String name, Runnable runnable) {
        return this.addFunction(name, (QContext qContext, Parameters parameters) -> {
            runnable.run();
            return null;
        });
    }

    public <T> boolean addFunction(String name, Consumer<T> consumer) {
        return this.addFunction(name, (QContext qContext, Parameters parameters) -> {
            Object t = parameters.size() > 0 ? parameters.get(0).get() : null;
            consumer.accept(t);
            return null;
        });
    }

    public BatchAddFunctionResult addFunctionsDefinedInScript(String scriptWithFunctionDefine, ExpressContext context, QLOptions qlOptions) {
        BatchAddFunctionResult batchResult = new BatchAddFunctionResult();
        QLambdaTrace mainLambdaTrace = this.parseToLambda(scriptWithFunctionDefine, context, qlOptions);
        try {
            Map<String, CustomFunction> functionTableInScript = mainLambdaTrace.getqLambda().getFunctionDefined(new Object[0]);
            for (Map.Entry<String, CustomFunction> entry : functionTableInScript.entrySet()) {
                boolean addResult = this.addFunction(entry.getKey(), entry.getValue());
                (addResult ? batchResult.getSucc() : batchResult.getFail()).add(entry.getKey());
            }
            return batchResult;
        }
        catch (QLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public BatchAddFunctionResult addObjFunction(Object object) {
        return this.addFunctionByAnnotation(object.getClass(), object);
    }

    public BatchAddFunctionResult addStaticFunction(Class<?> clazz) {
        return this.addFunctionByAnnotation(clazz, null);
    }

    private BatchAddFunctionResult addFunctionByAnnotation(Class<?> clazz, Object object) {
        Method[] methods;
        BatchAddFunctionResult result = new BatchAddFunctionResult();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!BasicUtil.isPublic(method)) {
                result.getFail().add(method.getName());
                continue;
            }
            if (!QLFunctionUtil.containsQLFunctionForMethod(method)) continue;
            for (String functionName : QLFunctionUtil.getQLFunctionValue(method)) {
                boolean addResult = this.addFunction(functionName, new QMethodFunction(object, method));
                (addResult ? result.getSucc() : result.getFail()).add(method.getName());
            }
        }
        return result;
    }

    public boolean addCompileTimeFunction(String name, CompileTimeFunction compileTimeFunction) {
        return this.compileTimeFunctions.putIfAbsent(name, compileTimeFunction) == null;
    }

    public QLParser.ProgramContext parseToSyntaxTree(String script) {
        return SyntaxTreeFactory.buildTree(script, this.operatorManager, this.initOptions.isDebug(), false, this.initOptions.getDebugInfoConsumer(), this.initOptions.getInterpolationMode(), this.initOptions.getSelectorStart(), this.initOptions.getSelectorEnd());
    }

    public QLambdaTrace parseToLambda(String script, ExpressContext context, QLOptions qlOptions) {
        QCompileCache mainLambdaDefine;
        QCompileCache qCompileCache = mainLambdaDefine = qlOptions.isCache() ? this.parseToDefinitionWithCache(script) : this.parseDefinition(script);
        if (this.initOptions.isDebug()) {
            this.initOptions.getDebugInfoConsumer().accept("\nInstructions:");
            mainLambdaDefine.getQLambdaDefinition().println(0, this.initOptions.getDebugInfoConsumer());
        }
        QTraces qTraces = this.initOptions.isTraceExpression() && qlOptions.isTraceExpression() ? this.convertPoints2QTraces(mainLambdaDefine.getExpressionTracePoints()) : new QTraces(null, null);
        QvmRuntime qvmRuntime = new QvmRuntime(qTraces, qlOptions.getAttachments(), this.reflectLoader, System.currentTimeMillis());
        QvmGlobalScope globalScope = new QvmGlobalScope(context, this.userDefineFunction, qlOptions);
        QLambda qLambda = mainLambdaDefine.getQLambdaDefinition().toLambda(new DelegateQContext(qvmRuntime, globalScope), qlOptions, true);
        return new QLambdaTrace(qLambda, qTraces);
    }

    public QCompileCache parseToDefinitionWithCache(String script) {
        try {
            return this.getParseFuture(script).get();
        }
        catch (Exception e) {
            Throwable compileException = e.getCause();
            throw compileException instanceof QLSyntaxException ? (QLSyntaxException)compileException : new RuntimeException(compileException);
        }
    }

    public Value loadField(Object object, String fieldName) {
        return this.reflectLoader.loadField(object, fieldName, true, PureErrReporter.INSTANCE);
    }

    public void clearCompileCache() {
        this.compileCache.clear();
    }

    private Future<QCompileCache> getParseFuture(String script) {
        Future<QCompileCache> parseFuture = this.compileCache.get(script);
        if (parseFuture != null) {
            return parseFuture;
        }
        FutureTask<QCompileCache> parseTask = new FutureTask<QCompileCache>(() -> this.parseDefinition(script));
        Future preTask = this.compileCache.putIfAbsent(script, parseTask);
        if (preTask == null) {
            parseTask.run();
            return parseTask;
        }
        return preTask;
    }

    private QCompileCache parseDefinition(String script) {
        QLParser.ProgramContext program = this.parseToSyntaxTree(script);
        QvmInstructionVisitor qvmInstructionVisitor = new QvmInstructionVisitor(script, this.inheritDefaultImport(), this.globalScope, this.operatorManager, this.compileTimeFunctions, this.initOptions);
        program.accept(qvmInstructionVisitor);
        QLambdaDefinitionInner qLambdaDefinition = new QLambdaDefinitionInner("main", qvmInstructionVisitor.getInstructions(), Collections.emptyList(), qvmInstructionVisitor.getMaxStackSize());
        if (this.initOptions.isTraceExpression()) {
            TraceExpressionVisitor traceExpressionVisitor = new TraceExpressionVisitor();
            program.accept(traceExpressionVisitor);
            List<TracePointTree> tracePoints = traceExpressionVisitor.getExpressionTracePoints();
            return new QCompileCache(qLambdaDefinition, tracePoints);
        }
        return new QCompileCache(qLambdaDefinition, Collections.emptyList());
    }

    private ImportManager inheritDefaultImport() {
        return new ImportManager(this.initOptions.getClassSupplier(), this.initOptions.getDefaultImport());
    }

    public <T, U, R> boolean addOperatorBiFunction(String operator, BiFunction<T, U, R> biFunction) {
        return this.operatorManager.addBinaryOperator(operator, (left, right) -> biFunction.apply(left.get(), right.get()), 12);
    }

    public boolean addOperator(String operator, CustomBinaryOperator customBinaryOperator) {
        return this.operatorManager.addBinaryOperator(operator, customBinaryOperator, 12);
    }

    public boolean addOperator(String operator, CustomBinaryOperator customBinaryOperator, int precedence) {
        return this.operatorManager.addBinaryOperator(operator, customBinaryOperator, precedence);
    }

    public boolean replaceDefaultOperator(String operator, CustomBinaryOperator customBinaryOperator) {
        return this.operatorManager.replaceDefaultOperator(operator, customBinaryOperator);
    }

    public boolean addAlias(String alias, String originToken) {
        boolean addKeyWordAliasResult = this.operatorManager.addKeyWordAlias(alias, originToken);
        boolean addOperatorAliasResult = this.operatorManager.addOperatorAlias(alias, originToken);
        boolean addFunctionAliasResult = this.addFunctionAlias(alias, originToken);
        return addKeyWordAliasResult || addOperatorAliasResult || addFunctionAliasResult;
    }

    private boolean addFunctionAlias(String alias, String originToken) {
        CustomFunction customFunction = this.userDefineFunction.get(originToken);
        if (customFunction != null) {
            return this.userDefineFunction.putIfAbsent(alias, customFunction) == null;
        }
        return false;
    }
}

