/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.ClassSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportManager {
    private final ClassSupplier classSupplier;
    private final List<QLImport> importedPacks;
    private final Map<String, Class<?>> importedClses;

    public ImportManager(ClassSupplier classSupplier, List<QLImport> imports) {
        this.classSupplier = classSupplier;
        this.importedPacks = new ArrayList<QLImport>();
        this.importedClses = new HashMap();
        imports.forEach(this::addImport);
    }

    public ImportManager(ClassSupplier classSupplier, List<QLImport> importedPacks, Map<String, Class<?>> importedClses) {
        this.classSupplier = classSupplier;
        this.importedPacks = importedPacks;
        this.importedClses = importedClses;
    }

    public boolean addImport(QLImport anImport) {
        switch (anImport.getScope()) {
            case PACK: 
            case InnerCls: {
                this.importedPacks.add(anImport);
                return true;
            }
            case CLS: {
                Class<?> importCls = this.classSupplier.loadCls(anImport.getTarget());
                if (importCls == null) {
                    return false;
                }
                String[] split = anImport.getTarget().split("\\.");
                this.importedClses.put(split[split.length - 1], importCls);
                return true;
            }
        }
        return false;
    }

    public Class<?> loadQualified(String qualifiedCls) {
        return this.classSupplier.loadCls(qualifiedCls);
    }

    public LoadPartQualifiedResult loadPartQualified(List<String> fieldIds) {
        Class<?> qualifiedCls = null;
        ArrayList<String> qualifiedPath = null;
        String innerClsId = null;
        boolean initState = false;
        boolean continueState = true;
        int loadClsState = 2;
        int loadInnerClsState = 3;
        int preLoadInnerClsState = 4;
        int state = 0;
        block17: for (int i = 0; i < fieldIds.size(); ++i) {
            String fieldId = fieldIds.get(i);
            switch (state) {
                case 0: {
                    Class<?> aCls = this.importedClses.get(fieldId);
                    if (aCls != null) {
                        qualifiedCls = aCls;
                        state = 4;
                        continue block17;
                    }
                    if (!Character.isLowerCase(fieldId.charAt(0))) {
                        for (QLImport importedPack : this.importedPacks) {
                            switch (importedPack.getScope()) {
                                case PACK: {
                                    Class<?> packCls = this.classSupplier.loadCls(importedPack.getTarget() + "." + fieldId);
                                    if (packCls == null) break;
                                    qualifiedCls = packCls;
                                    state = 4;
                                    continue block17;
                                }
                                case InnerCls: {
                                    Class<?> innerCls = this.classSupplier.loadCls(importedPack.getTarget() + "$" + fieldId);
                                    if (innerCls == null) break;
                                    qualifiedCls = innerCls;
                                    state = 4;
                                    continue block17;
                                }
                            }
                        }
                        return new LoadPartQualifiedResult(null, 0);
                    }
                    state = 1;
                    qualifiedPath = new ArrayList<String>();
                    qualifiedPath.add(fieldId);
                    continue block17;
                }
                case 4: {
                    if (!Character.isLowerCase(fieldId.charAt(0))) {
                        state = 3;
                        innerClsId = fieldId;
                        continue block17;
                    }
                    return new LoadPartQualifiedResult(qualifiedCls, i);
                }
                case 1: {
                    qualifiedPath.add(fieldId);
                    if (Character.isLowerCase(fieldId.charAt(0))) continue block17;
                    state = 2;
                    continue block17;
                }
                case 2: {
                    qualifiedCls = this.classSupplier.loadCls(String.join((CharSequence)".", (Iterable<? extends CharSequence>)qualifiedPath));
                    if (qualifiedCls == null) {
                        return new LoadPartQualifiedResult(null, 0);
                    }
                    if (!Character.isLowerCase(fieldId.charAt(0))) {
                        qualifiedPath = null;
                        innerClsId = fieldId;
                        state = 3;
                        continue block17;
                    }
                    return new LoadPartQualifiedResult(qualifiedCls, i);
                }
                case 3: {
                    Class<?> innerCls = this.classSupplier.loadCls(qualifiedCls.getName() + "$" + innerClsId);
                    if (innerCls == null) {
                        return new LoadPartQualifiedResult(qualifiedCls, i - 1);
                    }
                    if (!Character.isLowerCase(fieldId.charAt(0))) {
                        qualifiedCls = innerCls;
                        innerClsId = fieldId;
                        continue block17;
                    }
                    return new LoadPartQualifiedResult(innerCls, i);
                }
            }
        }
        switch (state) {
            case 1: {
                return new LoadPartQualifiedResult(null, 0);
            }
            case 2: {
                qualifiedCls = this.classSupplier.loadCls(String.join((CharSequence)".", qualifiedPath));
                return qualifiedCls == null ? new LoadPartQualifiedResult(null, fieldIds.size()) : new LoadPartQualifiedResult(qualifiedCls, fieldIds.size());
            }
            case 4: {
                return new LoadPartQualifiedResult(qualifiedCls, fieldIds.size());
            }
            case 3: {
                Class<?> innerCls = this.classSupplier.loadCls(qualifiedCls.getName() + "$" + innerClsId);
                return innerCls == null ? new LoadPartQualifiedResult(qualifiedCls, fieldIds.size() - 1) : new LoadPartQualifiedResult(innerCls, fieldIds.size());
            }
        }
        return new LoadPartQualifiedResult(null, 0);
    }

    public static QLImport importInnerCls(String clsPath) {
        return new QLImport(ImportScope.InnerCls, clsPath);
    }

    public static QLImport importPack(String packPath) {
        return new QLImport(ImportScope.PACK, packPath);
    }

    public static QLImport importCls(String clsPath) {
        return new QLImport(ImportScope.CLS, clsPath);
    }

    public static class QLImport {
        private final ImportScope scope;
        private final String target;

        public QLImport(ImportScope scope, String target) {
            this.scope = scope;
            this.target = target;
        }

        public ImportScope getScope() {
            return this.scope;
        }

        public String getTarget() {
            return this.target;
        }
    }

    static enum ImportScope {
        PACK,
        InnerCls,
        CLS;

    }

    public static class LoadPartQualifiedResult {
        private final Class<?> cls;
        private final int restIndex;

        public LoadPartQualifiedResult(Class<?> cls, int restIndex) {
            this.cls = cls;
            this.restIndex = restIndex;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public int getRestIndex() {
            return this.restIndex;
        }
    }
}

