/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.aparser.ExistStack;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.ScopeStackVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OutFunctionVisitor
extends ScopeStackVisitor {
    private final Set<String> outFunctions = new HashSet<String>();

    public OutFunctionVisitor() {
        super(new ExistFunctionStack(null));
    }

    @Override
    public Void visitBlockStatements(QLParser.BlockStatementsContext ctx) {
        List nonEmptyChildren = ctx.blockStatement().stream().filter(bs -> !(bs instanceof QLParser.EmptyStatementContext)).collect(Collectors.toList());
        for (QLParser.BlockStatementContext child : nonEmptyChildren) {
            if (!(child instanceof QLParser.FunctionStatementContext)) continue;
            child.accept(this);
        }
        for (QLParser.BlockStatementContext child : nonEmptyChildren) {
            if (child instanceof QLParser.FunctionStatementContext) continue;
            child.accept(this);
        }
        return null;
    }

    @Override
    public Void visitPrimary(QLParser.PrimaryContext ctx) {
        QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext = ctx.primaryNoFixPathable();
        if (primaryNoFixPathableContext != null) {
            List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
            if (primaryNoFixPathableContext instanceof QLParser.VarIdExprContext && !pathPartContexts.isEmpty() && pathPartContexts.get(0) instanceof QLParser.CallExprContext) {
                String functionName = primaryNoFixPathableContext.getText();
                if (!this.getStack().exist(functionName)) {
                    this.outFunctions.add(functionName);
                }
            }
        }
        return (Void)super.visitPrimary(ctx);
    }

    @Override
    public Void visitFunctionStatement(QLParser.FunctionStatementContext ctx) {
        QLParser.BlockStatementsContext functionBlockStatements;
        String functionName = ctx.varId().getText();
        this.getStack().add(functionName);
        QLParser.FormalOrInferredParameterListContext paramList = ctx.formalOrInferredParameterList();
        if (paramList != null) {
            paramList.accept(this);
        }
        if ((functionBlockStatements = ctx.blockStatements()) != null) {
            this.push();
            this.getStack().add(functionName);
            functionBlockStatements.accept(this);
            this.pop();
        }
        return null;
    }

    public Set<String> getOutFunctions() {
        return this.outFunctions;
    }

    private static class ExistFunctionStack
    implements ExistStack {
        private final ExistFunctionStack parent;
        private final Set<String> existVars = new HashSet<String>();

        private ExistFunctionStack(ExistFunctionStack parent) {
            this.parent = parent;
        }

        @Override
        public void add(String varName) {
            this.existVars.add(varName);
        }

        @Override
        public boolean exist(String varName) {
            if (this.existVars.contains(varName)) {
                return true;
            }
            return this.parent != null && this.parent.exist(varName);
        }

        @Override
        public ExistFunctionStack push() {
            return new ExistFunctionStack(this);
        }

        @Override
        public ExistFunctionStack pop() {
            return this.parent;
        }
    }
}

