/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.a4runtime.ParserRuleContext;
import com.alibaba.qlexpress4.a4runtime.Token;
import com.alibaba.qlexpress4.a4runtime.tree.TerminalNode;
import com.alibaba.qlexpress4.aparser.ExistStack;
import com.alibaba.qlexpress4.aparser.ImportManager;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.ScopeStackVisitor;
import com.alibaba.qlexpress4.utils.QLStringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OutVarNamesVisitor
extends ScopeStackVisitor {
    private final Set<String> outVars = new HashSet<String>();
    private final ImportManager importManager;

    public OutVarNamesVisitor(ImportManager importManager) {
        super(new ExistVarStack(null));
        this.importManager = importManager;
    }

    @Override
    public Void visitImportCls(QLParser.ImportClsContext ctx) {
        String importClsPath = ctx.varId().stream().map(ParserRuleContext::getStart).map(Token::getText).collect(Collectors.joining("."));
        this.importManager.addImport(ImportManager.importCls(importClsPath));
        return null;
    }

    @Override
    public Void visitImportPack(QLParser.ImportPackContext ctx) {
        List<QLParser.VarIdContext> importPackPathTokens = ctx.varId();
        boolean isInnerCls = !Character.isLowerCase(importPackPathTokens.get(importPackPathTokens.size() - 1).getText().charAt(0));
        String importPath = importPackPathTokens.stream().map(ParserRuleContext::getStart).map(Token::getText).collect(Collectors.joining("."));
        this.importManager.addImport(isInnerCls ? ImportManager.importInnerCls(importPath) : ImportManager.importPack(importPath));
        return null;
    }

    @Override
    public Void visitVariableDeclaratorId(QLParser.VariableDeclaratorIdContext ctx) {
        QLParser.VarIdContext varIdContext = ctx.varId();
        this.getStack().add(varIdContext.getText());
        return null;
    }

    @Override
    public Void visitLeftHandSide(QLParser.LeftHandSideContext ctx) {
        List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
        String leftVarName = ctx.varId().getText();
        if (pathPartContexts.isEmpty()) {
            this.getStack().add(leftVarName);
        } else if (!this.getStack().exist(leftVarName)) {
            this.outVars.add(leftVarName);
        }
        return null;
    }

    @Override
    public Void visitContextSelectExpr(QLParser.ContextSelectExprContext ctx) {
        String variableName = ctx.SelectorVariable_VANME().getText().trim();
        if (!this.getStack().exist(variableName)) {
            this.outVars.add(variableName);
        }
        return null;
    }

    @Override
    public Void visitPrimary(QLParser.PrimaryContext ctx) {
        QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext = ctx.primaryNoFixPathable();
        if (primaryNoFixPathableContext != null) {
            List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
            if (primaryNoFixPathableContext instanceof QLParser.VarIdExprContext && !pathPartContexts.isEmpty() && pathPartContexts.get(0) instanceof QLParser.CallExprContext) {
                for (QLParser.PathPartContext pathPartContext : pathPartContexts) {
                    pathPartContext.accept(this);
                }
                return null;
            }
            if (primaryNoFixPathableContext instanceof QLParser.VarIdExprContext) {
                int restIndex;
                for (int i = restIndex = this.parseVarIdInPath(((QLParser.VarIdExprContext)primaryNoFixPathableContext).varId(), pathPartContexts); i < pathPartContexts.size(); ++i) {
                    pathPartContexts.get(i).accept(this);
                }
                return null;
            }
        }
        return (Void)super.visitPrimary(ctx);
    }

    private int parseVarIdInPath(QLParser.VarIdContext idContext, List<QLParser.PathPartContext> pathPartContexts) {
        ArrayList<String> headPartIds = new ArrayList<String>();
        String primaryId = idContext.getText();
        headPartIds.add(primaryId);
        for (QLParser.PathPartContext pathPartContext : pathPartContexts) {
            if (!(pathPartContext instanceof QLParser.FieldAccessContext)) break;
            headPartIds.add(this.parseFieldId(((QLParser.FieldAccessContext)pathPartContext).fieldId()));
        }
        ImportManager.LoadPartQualifiedResult loadPartQualifiedResult = this.importManager.loadPartQualified(headPartIds);
        if (loadPartQualifiedResult.getCls() != null) {
            return loadPartQualifiedResult.getRestIndex() - 1;
        }
        if (!this.getStack().exist(primaryId)) {
            this.outVars.add(primaryId);
        }
        return 0;
    }

    private String parseFieldId(QLParser.FieldIdContext ctx) {
        TerminalNode quoteStringLiteral = ctx.QuoteStringLiteral();
        if (quoteStringLiteral != null) {
            return QLStringUtils.parseStringEscape(quoteStringLiteral.getText());
        }
        return ctx.getStart().getText();
    }

    @Override
    public Void visitVarIdExpr(QLParser.VarIdExprContext ctx) {
        String varName = ctx.varId().getText();
        if (!this.getStack().exist(varName)) {
            this.outVars.add(varName);
        }
        return null;
    }

    public Set<String> getOutVars() {
        return this.outVars;
    }

    private static class ExistVarStack
    implements ExistStack {
        private final ExistVarStack parent;
        private final Set<String> existVars = new HashSet<String>();

        private ExistVarStack(ExistVarStack parent) {
            this.parent = parent;
        }

        @Override
        public void add(String varName) {
            this.existVars.add(varName);
        }

        @Override
        public boolean exist(String varName) {
            if (this.existVars.contains(varName)) {
                return true;
            }
            return this.parent != null && this.parent.exist(varName);
        }

        @Override
        public ExistVarStack push() {
            return new ExistVarStack(this);
        }

        @Override
        public ExistVarStack pop() {
            return this.parent;
        }
    }
}

