/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.a4runtime.BaseErrorListener;
import com.alibaba.qlexpress4.a4runtime.Parser;
import com.alibaba.qlexpress4.a4runtime.ParserRuleContext;
import com.alibaba.qlexpress4.a4runtime.RecognitionException;
import com.alibaba.qlexpress4.a4runtime.Recognizer;
import com.alibaba.qlexpress4.a4runtime.Token;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLException;

public class QLErrorListener
extends BaseErrorListener {
    private final String script;

    public QLErrorListener(String script) {
        this.script = script;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        Token currentToken = (Token)offendingSymbol;
        String tokenText = currentToken.getType() == -1 ? "<EOF>" : currentToken.getText();
        String preHandledScript = currentToken.getType() == -1 ? this.script + "<EOF>" : this.script;
        String preHandledMsg = this.errMsg(((Parser)recognizer).getContext(), currentToken, msg);
        throw QLException.reportScannerErr(preHandledScript, currentToken.getStartIndex(), currentToken.getLine(), currentToken.getCharPositionInLine(), tokenText, QLErrorCodes.SYNTAX_ERROR.name(), preHandledMsg);
    }

    private String errMsg(ParserRuleContext ruleContext, Token currentToken, String msg) {
        if ("'".equals(currentToken.getText()) || "\"".equals(currentToken.getText()) || ruleContext.getRuleIndex() == 55) {
            return "unterminated string literal";
        }
        if ("import".equals(currentToken.getText())) {
            return "Import statement is not at the beginning of the file.";
        }
        if (ruleContext.getRuleIndex() == 61 && "static".equals(currentToken.getText())) {
            return "'import static' not supported temporarily";
        }
        return msg;
    }
}

