/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.a4runtime.CharStream;
import com.alibaba.qlexpress4.aparser.InterpolationMode;
import com.alibaba.qlexpress4.aparser.QLexer;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLException;

public class QLExtendLexer
extends QLexer {
    private final String script;
    private final InterpolationMode interpolationMode;
    private final String selectorStart;
    private final String selectorEnd;

    public QLExtendLexer(CharStream input, String script, InterpolationMode interpolationMode, String selectorStart, String selectorEnd) {
        super(input);
        this.script = script;
        this.interpolationMode = interpolationMode;
        this.selectorStart = selectorStart;
        this.selectorEnd = selectorEnd;
    }

    @Override
    protected InterpolationMode getInterpolationMode() {
        return this.interpolationMode;
    }

    @Override
    protected String getSelectorStart() {
        return this.selectorStart;
    }

    @Override
    protected void consumeSelectorVariable() {
        char curCh;
        StringBuilder t = new StringBuilder();
        int selectorEndLength = this.selectorEnd.length();
        char lastCharOfSelector = this.selectorEnd.charAt(selectorEndLength - 1);
        t.ensureCapacity(selectorEndLength * 2);
        do {
            int curChInt;
            if ((curChInt = this._input.LA(1)) == -1 || curChInt == 10) {
                this.throwScannerException(t.toString(), "unterminated selector");
            }
            curCh = (char)curChInt;
            t.append(curCh);
            this._input.consume();
        } while (curCh != lastCharOfSelector || t.length() < selectorEndLength || !this.checkEndsWith(t, this.selectorEnd));
        String text = t.toString();
        this.setText(text.substring(0, text.length() - selectorEndLength));
        this.popMode();
    }

    @Override
    protected void throwScannerException(String lexeme, String reason) {
        throw QLException.reportScannerErr(this.script, this._tokenStartCharIndex, this._tokenStartLine, this._tokenStartCharPositionInLine, lexeme, QLErrorCodes.SYNTAX_ERROR.name(), reason);
    }

    private boolean checkEndsWith(StringBuilder sb, String suffix) {
        int suffixLength = suffix.length();
        int sbLength = sb.length();
        for (int i = 0; i < suffixLength; ++i) {
            if (sb.charAt(sbLength - suffixLength + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

