/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime;

import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLRuntimeException;
import com.alibaba.qlexpress4.member.FieldHandler;
import com.alibaba.qlexpress4.member.MethodHandler;
import com.alibaba.qlexpress4.runtime.IMethod;
import com.alibaba.qlexpress4.runtime.JvmIMethod;
import com.alibaba.qlexpress4.runtime.MemberResolver;
import com.alibaba.qlexpress4.runtime.MetaClass;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.data.FieldValue;
import com.alibaba.qlexpress4.runtime.data.MapItemValue;
import com.alibaba.qlexpress4.runtime.function.ExtensionFunction;
import com.alibaba.qlexpress4.security.QLSecurityStrategy;
import com.alibaba.qlexpress4.security.StrategyIsolation;
import com.alibaba.qlexpress4.utils.BasicUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ReflectLoader {
    private final QLSecurityStrategy securityStrategy;
    private final boolean allowPrivateAccess;
    private final Map<List<Class<?>>, Constructor<?>> constructorCache = new ConcurrentHashMap();
    private final Map<List<?>, FieldReflectCache> fieldCache = new ConcurrentHashMap();
    private final Map<MethodCacheKey, Method> staticMethodCache = new ConcurrentHashMap<MethodCacheKey, Method>();
    private final Map<MethodCacheKey, Method> memberMethodCache = new ConcurrentHashMap<MethodCacheKey, Method>();
    private final List<ExtensionFunction> extensionFunctions;

    public ReflectLoader(QLSecurityStrategy securityStrategy, List<ExtensionFunction> extensionFunctions, boolean allowPrivateAccess) {
        this.securityStrategy = securityStrategy;
        this.allowPrivateAccess = allowPrivateAccess;
        this.extensionFunctions = extensionFunctions;
    }

    public Constructor<?> loadConstructor(Class<?> cls, Class<?>[] paramTypes) {
        if (this.securityStrategy instanceof StrategyIsolation) {
            return null;
        }
        ArrayList cacheKey = new ArrayList(paramTypes.length + 1);
        cacheKey.add(cls);
        cacheKey.addAll(Arrays.asList(paramTypes));
        Constructor<?> cachedConstructor = this.constructorCache.get(cacheKey);
        if (cachedConstructor != null) {
            return cachedConstructor;
        }
        Constructor<?> constructor = this.securityFilter(MemberResolver.resolveConstructor(cls, paramTypes));
        if (constructor == null) {
            return null;
        }
        this.constructorCache.put(cacheKey, constructor);
        return constructor;
    }

    public Value loadField(Object bean, String fieldName, boolean skipSecurity, ErrorReporter errorReporter) {
        if (bean.getClass().isArray() && "length".equals(fieldName)) {
            return new DataValue(((Object[])bean).length);
        }
        if (bean instanceof List && "length".equals(fieldName)) {
            return new DataValue(((List)bean).size());
        }
        if (bean instanceof Map) {
            return new MapItemValue((Map)bean, fieldName);
        }
        if (!skipSecurity && this.securityStrategy instanceof StrategyIsolation) {
            return null;
        }
        if (bean instanceof MetaClass) {
            MetaClass metaClass = (MetaClass)bean;
            if ("class".equals(fieldName)) {
                return new DataValue(metaClass.getClz());
            }
            return this.loadJavaField(metaClass.getClz(), null, fieldName, skipSecurity, errorReporter);
        }
        return this.loadJavaField(bean.getClass(), bean, fieldName, skipSecurity, errorReporter);
    }

    public IMethod loadMethod(Object bean, String methodName, Class<?>[] argTypes) {
        MethodCacheKey cacheKey;
        IMethod extendFunction;
        Class<?> clz;
        boolean isStaticMethod = bean instanceof MetaClass;
        Class<?> clazz = clz = isStaticMethod ? ((MetaClass)bean).getClz() : bean.getClass();
        if (!isStaticMethod && (extendFunction = this.loadExtendFunction(clz, methodName, argTypes)) != null) {
            return extendFunction;
        }
        if (this.securityStrategy instanceof StrategyIsolation) {
            return null;
        }
        Map<MethodCacheKey, Method> methodCache = isStaticMethod ? this.staticMethodCache : this.memberMethodCache;
        Method cachedMethod = methodCache.get(cacheKey = new MethodCacheKey(clz, methodName, argTypes));
        if (cachedMethod != null) {
            return new JvmIMethod(cachedMethod);
        }
        Method method = this.securityFilter(MemberResolver.resolveMethod(clz, methodName, argTypes, isStaticMethod, this.allowPrivateAccess));
        if (method == null) {
            return null;
        }
        methodCache.put(cacheKey, method);
        return new JvmIMethod(method);
    }

    private IMethod loadExtendFunction(Class<?> clz, String methodName, Class<?>[] argTypes) {
        List assignableExtensionFunctions = this.extensionFunctions.stream().filter(extensionFunction -> extensionFunction.getDeclaringClass().isAssignableFrom(clz) && methodName.equals(extensionFunction.getName())).collect(Collectors.toList());
        if (assignableExtensionFunctions.isEmpty()) {
            return null;
        }
        Class[][] candidates = new Class[assignableExtensionFunctions.size()][];
        for (int i = 0; i < assignableExtensionFunctions.size(); ++i) {
            candidates[i] = ((ExtensionFunction)assignableExtensionFunctions.get(i)).getParameterTypes();
        }
        Integer bestIndex = MemberResolver.resolveBestMatch(candidates, argTypes);
        if (bestIndex == null) {
            return null;
        }
        return (IMethod)assignableExtensionFunctions.get(bestIndex);
    }

    private Value loadJavaField(Class<?> cls, Object bean, String fieldName, boolean skipSecurity, ErrorReporter errorReporter) {
        FieldReflectCache fieldReflectCache = this.loadFieldReflectCache(cls, fieldName, skipSecurity);
        if (fieldReflectCache == null) {
            return null;
        }
        Supplier getterOp = (Supplier)fieldReflectCache.getterSupplier.apply(errorReporter, bean);
        if (fieldReflectCache.setterSupplier == null) {
            return new DataValue(getterOp.get());
        }
        Consumer setterOp = (Consumer)fieldReflectCache.setterSupplier.apply(errorReporter, bean);
        return new FieldValue(getterOp, setterOp, fieldReflectCache.defType);
    }

    private FieldReflectCache loadFieldReflectCache(Class<?> cls, String fieldName, boolean skipSecurity) {
        List<Serializable> cacheKey = Arrays.asList(cls, fieldName);
        FieldReflectCache cachedField = this.fieldCache.get(cacheKey);
        if (cachedField != null) {
            return cachedField;
        }
        FieldReflectCache fieldReflect = this.loadJavaFieldInner(cls, fieldName, skipSecurity);
        if (fieldReflect != null) {
            this.fieldCache.put(cacheKey, fieldReflect);
        }
        return fieldReflect;
    }

    private FieldReflectCache loadJavaFieldInner(Class<?> cls, String fieldName, boolean skipSecurity) {
        Field field;
        String preHandledName = FieldHandler.Preferred.preHandleAlias(cls, fieldName);
        Method getMethod = skipSecurity ? MethodHandler.getGetter(cls, preHandledName) : this.securityFilter(MethodHandler.getGetter(cls, preHandledName));
        BiFunction<ErrorReporter, Object, Supplier<Object>> getterSupplier = this.fieldGetter(getMethod, field = skipSecurity ? FieldHandler.Preferred.gatherFieldRecursive(cls, preHandledName) : this.securityFilter(FieldHandler.Preferred.gatherFieldRecursive(cls, preHandledName)));
        if (getterSupplier == null) {
            return null;
        }
        Method setMethod = this.securityFilter(MethodHandler.getSetter(cls, preHandledName));
        BiFunction<ErrorReporter, Object, Consumer<Object>> setterSupplier = this.fieldSetter(setMethod, field);
        return new FieldReflectCache(getterSupplier, setterSupplier, this.fieldDefCls(setMethod, field));
    }

    private <T extends Member> T securityFilter(T member) {
        return member == null ? null : (this.securityStrategy.check(member) ? member : null);
    }

    private Class<?> fieldDefCls(Method setMethod, Field field) {
        return setMethod != null ? setMethod.getParameterTypes()[0] : (field != null ? field.getType() : Object.class);
    }

    private BiFunction<ErrorReporter, Object, Consumer<Object>> fieldSetter(Method setMethod, Field field) {
        if (setMethod != null) {
            if (BasicUtil.isPublic(setMethod)) {
                return this.setMethodAccessible(setMethod);
            }
            if (this.allowPrivateAccess) {
                return this.setMethodUnAccessible(setMethod);
            }
        }
        if (field != null) {
            if (BasicUtil.isPublic(field)) {
                return this.setFieldAccessible(field);
            }
            if (this.allowPrivateAccess) {
                return this.setFieldUnAccessible(field);
            }
        }
        return null;
    }

    private BiFunction<ErrorReporter, Object, Supplier<Object>> fieldGetter(Method getMethod, Field field) {
        if (getMethod != null) {
            if (BasicUtil.isPublic(getMethod)) {
                return this.getMethodAccessible(getMethod);
            }
            if (this.allowPrivateAccess) {
                return this.getMethodUnAccessible(getMethod);
            }
        }
        if (field != null) {
            if (BasicUtil.isPublic(field)) {
                return this.getFieldAccessible(field);
            }
            if (this.allowPrivateAccess) {
                return this.getFieldUnAccessible(field);
            }
        }
        return null;
    }

    private BiFunction<ErrorReporter, Object, Consumer<Object>> setMethodAccessible(Method setMethod) {
        return (errorReporter, bean) -> newValue -> {
            try {
                setMethod.invoke(bean, newValue);
            }
            catch (Exception e) {
                throw ReflectLoader.unwrapMethodInvokeEx(errorReporter, setMethod.getName(), e);
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Consumer<Object>> setMethodUnAccessible(Method setMethod) {
        return (errorReporter, bean) -> newValue -> {
            try {
                setMethod.setAccessible(true);
                setMethod.invoke(bean, newValue);
            }
            catch (Exception e) {
                throw ReflectLoader.unwrapMethodInvokeEx(errorReporter, setMethod.getName(), e);
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Consumer<Object>> setFieldAccessible(Field field) {
        return (errorReporter, bean) -> newValue -> {
            try {
                field.set(bean, newValue);
            }
            catch (Exception e) {
                throw errorReporter.report(e, QLErrorCodes.SET_FIELD_UNKNOWN_ERROR.name(), String.format(QLErrorCodes.SET_FIELD_UNKNOWN_ERROR.getErrorMsg(), field.getName()));
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Consumer<Object>> setFieldUnAccessible(Field field) {
        return (errorReporter, bean) -> newValue -> {
            try {
                field.setAccessible(true);
                field.set(bean, newValue);
            }
            catch (Exception e) {
                throw errorReporter.report(e, QLErrorCodes.SET_FIELD_UNKNOWN_ERROR.name(), String.format(QLErrorCodes.SET_FIELD_UNKNOWN_ERROR.getErrorMsg(), field.getName()));
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Supplier<Object>> getMethodAccessible(Method getMethod) {
        return (errorReporter, bean) -> () -> {
            try {
                return getMethod.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw ReflectLoader.unwrapMethodInvokeEx(errorReporter, getMethod.getName(), e);
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Supplier<Object>> getMethodUnAccessible(Method getMethod) {
        return (errorReporter, bean) -> () -> {
            try {
                getMethod.setAccessible(true);
                return getMethod.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw ReflectLoader.unwrapMethodInvokeEx(errorReporter, getMethod.getName(), e);
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Supplier<Object>> getFieldAccessible(Field field) {
        return (errorReporter, bean) -> () -> {
            try {
                return field.get(bean);
            }
            catch (Exception e) {
                throw errorReporter.report(e, QLErrorCodes.GET_FIELD_UNKNOWN_ERROR.name(), String.format(QLErrorCodes.GET_FIELD_UNKNOWN_ERROR.getErrorMsg(), field.getName()));
            }
        };
    }

    private BiFunction<ErrorReporter, Object, Supplier<Object>> getFieldUnAccessible(Field field) {
        return (errorReporter, bean) -> () -> {
            try {
                field.setAccessible(true);
                return field.get(bean);
            }
            catch (Exception e) {
                throw errorReporter.report(e, QLErrorCodes.GET_FIELD_UNKNOWN_ERROR.name(), String.format(QLErrorCodes.GET_FIELD_UNKNOWN_ERROR.getErrorMsg(), field.getName()));
            }
        };
    }

    public static QLRuntimeException unwrapMethodInvokeEx(ErrorReporter errorReporter, String methodName, Exception ex) {
        if (ex instanceof IllegalArgumentException) {
            return errorReporter.reportFormat(QLErrorCodes.INVOKE_METHOD_WITH_WRONG_ARGUMENTS.name(), String.format(QLErrorCodes.INVOKE_METHOD_WITH_WRONG_ARGUMENTS.getErrorMsg(), methodName), new Object[0]);
        }
        if (ex instanceof InvocationTargetException) {
            return errorReporter.report(((InvocationTargetException)ex).getTargetException(), QLErrorCodes.INVOKE_METHOD_INNER_ERROR.name(), String.format(QLErrorCodes.INVOKE_METHOD_INNER_ERROR.getErrorMsg(), methodName));
        }
        return errorReporter.report(ex, QLErrorCodes.INVOKE_METHOD_UNKNOWN_ERROR.name(), String.format(QLErrorCodes.INVOKE_METHOD_UNKNOWN_ERROR.getErrorMsg(), methodName));
    }

    private static class MethodCacheKey {
        private final Class<?> cls;
        private final String methodName;
        private final Class<?>[] argTypes;

        public MethodCacheKey(Class<?> cls, String methodName, Class<?>[] argTypes) {
            this.cls = cls;
            this.methodName = methodName;
            this.argTypes = argTypes;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCacheKey that = (MethodCacheKey)o;
            return this.cls.equals(that.cls) && this.methodName.equals(that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
        }

        public int hashCode() {
            int result = Objects.hash(this.cls, this.methodName);
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }

    private static class ExtensionMapKey {
        private final Class<?> cls;
        private final String methodName;

        public ExtensionMapKey(Class<?> cls, String methodName) {
            this.cls = cls;
            this.methodName = methodName;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtensionMapKey that = (ExtensionMapKey)o;
            return Objects.equals(this.cls, that.cls) && Objects.equals(this.methodName, that.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.cls, this.methodName);
        }
    }

    private static class FieldReflectCache {
        private final BiFunction<ErrorReporter, Object, Supplier<Object>> getterSupplier;
        private final BiFunction<ErrorReporter, Object, Consumer<Object>> setterSupplier;
        private final Class<?> defType;

        private FieldReflectCache(BiFunction<ErrorReporter, Object, Supplier<Object>> getterSupplier, BiFunction<ErrorReporter, Object, Consumer<Object>> setterSupplier, Class<?> defType) {
            this.getterSupplier = getterSupplier;
            this.setterSupplier = setterSupplier;
            this.defType = defType;
        }
    }
}

