/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.data.convert.ObjTypeConvertor;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.lang.reflect.Array;
import java.util.function.Consumer;

public class NewArrayInstruction
extends QLInstruction {
    private final Class<?> clz;
    private final int length;

    public NewArrayInstruction(ErrorReporter errorReporter, Class<?> clz, int length) {
        super(errorReporter);
        this.clz = clz;
        this.length = length;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        if (!qlOptions.checkArrLen(this.length)) {
            throw this.errorReporter.reportFormat(QLErrorCodes.EXCEED_MAX_ARR_LENGTH.name(), QLErrorCodes.EXCEED_MAX_ARR_LENGTH.getErrorMsg(), this.length, qlOptions.getMaxArrLength());
        }
        Object array = Array.newInstance(this.clz, this.length);
        Parameters initItems = qContext.pop(this.length);
        for (int i = 0; i < initItems.size(); ++i) {
            Object initItemObj = initItems.get(i).get();
            ObjTypeConvertor.QConverted qlConvertResult = ObjTypeConvertor.cast(initItemObj, this.clz);
            if (!qlConvertResult.isConvertible()) {
                throw this.errorReporter.reportFormat(QLErrorCodes.INCOMPATIBLE_ARRAY_ITEM_TYPE.name(), QLErrorCodes.INCOMPATIBLE_ARRAY_ITEM_TYPE.getErrorMsg(), i, initItemObj == null ? "null" : initItemObj.getClass().getName(), this.clz.getName());
            }
            Array.set(array, i, qlConvertResult.getConverted());
        }
        qContext.push(new DataValue(array));
        return QResult.NEXT_INSTRUCTION;
    }

    public Class<?> getClz() {
        return this.clz;
    }

    @Override
    public int stackInput() {
        return this.length;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": NewArray with length " + this.length, debug);
    }
}

