/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.util.MethodInvokeUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Consumer;

public class SpreadMethodInvokeInstruction
extends QLInstruction {
    private final String methodName;
    private final int argNum;

    public SpreadMethodInvokeInstruction(ErrorReporter errorReporter, String methodName, int argNum) {
        super(errorReporter);
        this.methodName = methodName;
        this.argNum = argNum;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        ArrayList<Object> result;
        Parameters parameters = qContext.pop(this.argNum + 1);
        Object traversable = parameters.get(0).get();
        if (traversable == null) {
            if (qlOptions.isAvoidNullPointer()) {
                qContext.push(DataValue.NULL_VALUE);
                return QResult.NEXT_INSTRUCTION;
            }
            throw this.errorReporter.reportFormat(QLErrorCodes.NONTRAVERSABLE_OBJECT.name(), QLErrorCodes.NONTRAVERSABLE_OBJECT.getErrorMsg(), "null");
        }
        Class[] type = new Class[this.argNum];
        Object[] params = new Object[this.argNum];
        for (int i = 0; i < this.argNum; ++i) {
            Value v = parameters.get(i + 1);
            params[i] = v.get();
            type[i] = v.getType();
        }
        if (traversable instanceof Iterable) {
            Iterable iterable = (Iterable)traversable;
            result = new ArrayList<Object>();
            for (Object item : iterable) {
                if (item == null) {
                    if (qlOptions.isAvoidNullPointer()) {
                        result.add(null);
                        continue;
                    }
                    throw this.errorReporter.report(new NullPointerException(), QLErrorCodes.NULL_METHOD_ACCESS.name(), QLErrorCodes.NULL_METHOD_ACCESS.getErrorMsg());
                }
                Value invokeRes = MethodInvokeUtils.findMethodAndInvoke(item, this.methodName, params, type, qContext.getReflectLoader(), this.errorReporter);
                result.add(invokeRes.get());
            }
            qContext.push(new DataValue(result));
        } else if (traversable.getClass().isArray()) {
            int arrLen = Array.getLength(traversable);
            result = new ArrayList();
            for (int i = 0; i < arrLen; ++i) {
                Object item = Array.get(traversable, i);
                if (item == null) {
                    if (qlOptions.isAvoidNullPointer()) {
                        result.add(null);
                        continue;
                    }
                    throw this.errorReporter.report(new NullPointerException(), QLErrorCodes.NULL_METHOD_ACCESS.name(), QLErrorCodes.NULL_METHOD_ACCESS.getErrorMsg());
                }
                Value invokeRes = MethodInvokeUtils.findMethodAndInvoke(item, this.methodName, params, type, qContext.getReflectLoader(), this.errorReporter);
                result.add(invokeRes.get());
            }
            qContext.push(new DataValue(result));
        } else {
            throw this.errorReporter.reportFormat(QLErrorCodes.NONTRAVERSABLE_OBJECT.name(), QLErrorCodes.NONTRAVERSABLE_OBJECT.getErrorMsg(), traversable.getClass().getName());
        }
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return this.argNum + 1;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": SpreadMethodInvoke " + this.methodName, debug);
    }
}

