/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLRuntimeException;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinition;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.util.ThrowUtils;
import com.alibaba.qlexpress4.runtime.util.ValueUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TryCatchInstruction
extends QLInstruction {
    private final QLambdaDefinition body;
    private final List<Map.Entry<Class<?>, QLambdaDefinition>> exceptionTable;
    private final QLambdaDefinition finalBody;

    public TryCatchInstruction(ErrorReporter errorReporter, QLambdaDefinition body, List<Map.Entry<Class<?>, QLambdaDefinition>> exceptionTable, QLambdaDefinition finalBody) {
        super(errorReporter);
        this.body = body;
        this.exceptionTable = exceptionTable;
        this.finalBody = finalBody;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        QResult tryCatchResult = this.tryCatchResult(qContext, qlOptions);
        Value resultValue = tryCatchResult.getResult();
        qContext.push(ValueUtils.toImmutable(resultValue));
        if (this.finalBody != null) {
            this.callFinal(qContext, qlOptions);
        }
        if (tryCatchResult.getResultType() == QResult.ResultType.RETURN) {
            return tryCatchResult;
        }
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return 0;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": TryCatch", debug);
        PrintlnUtils.printlnByCurDepth(depth + 1, "Body", debug);
        this.body.println(depth + 2, debug);
        for (Map.Entry<Class<?>, QLambdaDefinition> clsLambdaEn : this.exceptionTable) {
            PrintlnUtils.printlnByCurDepth(depth + 1, clsLambdaEn.getKey().getSimpleName(), debug);
            clsLambdaEn.getValue().println(depth + 2, debug);
        }
        if (this.finalBody != null) {
            PrintlnUtils.printlnByCurDepth(depth + 1, "Finally", debug);
            this.finalBody.println(depth + 2, debug);
        }
    }

    private void callFinal(QContext qContext, QLOptions qlOptions) {
        QLambda finalLambda = this.finalBody.toLambda(qContext, qlOptions, true);
        try {
            finalLambda.call(new Object[0]);
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.EXECUTE_FINAL_BLOCK_ERROR.name(), QLErrorCodes.EXECUTE_FINAL_BLOCK_ERROR.getErrorMsg(), new String[0]);
        }
    }

    private QResult tryCatchResult(QContext qContext, QLOptions qlOptions) {
        try {
            QLambda bodyLambda = this.body.toLambda(qContext, qlOptions, true);
            return bodyLambda.call(new Object[0]);
        }
        catch (QLRuntimeException e) {
            QResult result;
            Object catchObj = e.getCatchObj();
            if (catchObj == null) {
                catchObj = new Object();
            }
            if ((result = this.callExceptionHandler(catchObj, qContext, qlOptions)) == null) {
                throw e;
            }
            return result;
        }
        catch (Throwable t) {
            QResult result = this.callExceptionHandler(t, qContext, qlOptions);
            if (result == null) {
                throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.EXECUTE_TRY_BLOCK_ERROR.name(), QLErrorCodes.EXECUTE_TRY_BLOCK_ERROR.getErrorMsg(), new String[0]);
            }
            return result;
        }
    }

    private QResult callExceptionHandler(Object catchObj, QContext qContext, QLOptions qlOptions) {
        QLambdaDefinition exceptionHandler = this.getExceptionHandler(catchObj.getClass());
        if (exceptionHandler == null) {
            return null;
        }
        QLambda catchHandlerLambda = exceptionHandler.toLambda(qContext, qlOptions, true);
        try {
            return catchHandlerLambda.call(catchObj);
        }
        catch (Throwable th) {
            throw ThrowUtils.wrapThrowable(th, this.errorReporter, QLErrorCodes.EXECUTE_CATCH_HANDLER_ERROR.name(), QLErrorCodes.EXECUTE_CATCH_HANDLER_ERROR.getErrorMsg(), catchObj.getClass().getName());
        }
    }

    private QLambdaDefinition getExceptionHandler(Class<?> catchObjClass) {
        for (Map.Entry<Class<?>, QLambdaDefinition> clsLambdaEn : this.exceptionTable) {
            if (!clsLambdaEn.getKey().isAssignableFrom(catchObjClass)) continue;
            return clsLambdaEn.getValue();
        }
        return null;
    }
}

