/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.DelegateQContext;
import com.alibaba.qlexpress4.runtime.ExceptionTable;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinition;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.scope.QScope;
import com.alibaba.qlexpress4.runtime.scope.QvmBlockScope;
import com.alibaba.qlexpress4.runtime.util.ThrowUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.Collections;
import java.util.function.Consumer;

public class WhileInstruction
extends QLInstruction {
    private final QLambdaDefinition condition;
    private final QLambdaDefinition body;
    private final int whileScopeMaxStackSize;

    public WhileInstruction(ErrorReporter errorReporter, QLambdaDefinition condition, QLambdaDefinition body, int whileScopeMaxStackSize) {
        super(errorReporter);
        this.condition = condition;
        this.body = body;
        this.whileScopeMaxStackSize = whileScopeMaxStackSize;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        DelegateQContext whileScopeContext = new DelegateQContext(qContext, new QvmBlockScope((QScope)qContext, Collections.emptyMap(), this.whileScopeMaxStackSize, ExceptionTable.EMPTY));
        QLambda conditionLambda = this.condition.toLambda(whileScopeContext, qlOptions, false);
        QLambda bodyLambda = this.body.toLambda(whileScopeContext, qlOptions, true);
        block6: while (this.evalCondition(conditionLambda)) {
            try {
                QResult bodyResult = bodyLambda.call(new Object[0]);
                switch (bodyResult.getResultType()) {
                    case RETURN: {
                        return bodyResult;
                    }
                    case BREAK: {
                        break block6;
                    }
                }
            }
            catch (Throwable t) {
                throw ThrowUtils.wrapThrowable(t, this.errorReporter, "WHILE_BODY_EXECUTE_ERROR", "while body execute error", new String[0]);
            }
        }
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return 0;
    }

    @Override
    public int stackOutput() {
        return 0;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": While", debug);
        PrintlnUtils.printlnByCurDepth(depth + 1, "Condition", debug);
        this.condition.println(depth + 2, debug);
        PrintlnUtils.printlnByCurDepth(depth + 1, "Body", debug);
        this.body.println(depth + 2, debug);
    }

    private boolean evalCondition(QLambda conditionLambda) {
        try {
            Object conditionResult = conditionLambda.call(new Object[0]).getResult().get();
            if (!(conditionResult instanceof Boolean)) {
                throw this.errorReporter.report(QLErrorCodes.WHILE_CONDITION_BOOL_REQUIRED.name(), QLErrorCodes.WHILE_CONDITION_BOOL_REQUIRED.getErrorMsg());
            }
            return (Boolean)conditionResult;
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.WHILE_CONDITION_ERROR.name(), QLErrorCodes.WHILE_CONDITION_ERROR.getErrorMsg(), new String[0]);
        }
    }
}

