/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.operator.number;

import com.alibaba.qlexpress4.runtime.operator.number.NumberMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public final class BigDecimalMath
extends NumberMath {
    public static final int DIVISION_EXTRA_PRECISION = Integer.getInteger("qlexpress4.division.extra.precision", 10);
    public static final int DIVISION_MIN_SCALE = Integer.getInteger("qlexpress4.division.min.scale", 10);
    public static final BigDecimalMath INSTANCE = new BigDecimalMath();

    private BigDecimalMath() {
    }

    @Override
    public Number absImpl(Number number) {
        return BigDecimalMath.toBigDecimal(number).abs();
    }

    @Override
    public Number addImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).add(BigDecimalMath.toBigDecimal(right));
    }

    @Override
    public Number subtractImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).subtract(BigDecimalMath.toBigDecimal(right));
    }

    @Override
    public Number multiplyImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).multiply(BigDecimalMath.toBigDecimal(right));
    }

    @Override
    public Number divideImpl(Number left, Number right) {
        BigDecimal bigLeft = BigDecimalMath.toBigDecimal(left);
        BigDecimal bigRight = BigDecimalMath.toBigDecimal(right);
        try {
            return bigLeft.divide(bigRight);
        }
        catch (ArithmeticException e) {
            int precision = Math.max(bigLeft.precision(), bigRight.precision()) + DIVISION_EXTRA_PRECISION;
            BigDecimal result = bigLeft.divide(bigRight, new MathContext(precision));
            int scale = Math.max(Math.max(bigLeft.scale(), bigRight.scale()), DIVISION_MIN_SCALE);
            if (result.scale() > scale) {
                result = result.setScale(scale, RoundingMode.HALF_UP);
            }
            return result;
        }
    }

    @Override
    public int compareToImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).compareTo(BigDecimalMath.toBigDecimal(right));
    }

    @Override
    public Number unaryMinusImpl(Number left) {
        return BigDecimalMath.toBigDecimal(left).negate();
    }

    @Override
    public Number unaryPlusImpl(Number left) {
        return BigDecimalMath.toBigDecimal(left);
    }

    @Override
    public Number remainderImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).remainder(BigDecimalMath.toBigDecimal(right));
    }

    @Override
    public Number modImpl(Number self, Number divisor) {
        BigDecimal divDecimal;
        BigDecimal selfDecimal = BigDecimalMath.toBigDecimal(self);
        BigDecimal remainder = selfDecimal.remainder(divDecimal = BigDecimalMath.toBigDecimal(divisor));
        return remainder.signum() < 0 ? remainder.add(divDecimal) : remainder;
    }
}

