/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.service;

import com.alipay.sofa.healthcheck.core.HealthCheckerProcessor;
import com.alipay.sofa.healthcheck.startup.ReadinessCheckListener;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.util.Assert;

public class SofaBootHealthIndicator
implements HealthIndicator {
    private static final String CHECK_RESULT_PREFIX = "Middleware";
    @Autowired
    private HealthCheckerProcessor healthCheckerProcessor;
    @Autowired
    private ReadinessCheckListener readinessCheckListener;

    public Health health() {
        Assert.isTrue((boolean)this.readinessCheckListener.isReadinessCheckFinish(), (String)"App is still in startup process, please try later!");
        HashMap<String, Health> healths = new HashMap<String, Health>();
        boolean checkSuccessful = this.healthCheckerProcessor.livenessHealthCheck(healths);
        if (checkSuccessful) {
            return Health.up().withDetail(CHECK_RESULT_PREFIX, healths).build();
        }
        return Health.down().withDetail(CHECK_RESULT_PREFIX, healths).build();
    }
}

