/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.startup;

import com.alipay.sofa.healthcheck.core.AfterReadinessCheckCallbackProcessor;
import com.alipay.sofa.healthcheck.core.HealthCheckerProcessor;
import com.alipay.sofa.healthcheck.core.HealthIndicatorProcessor;
import com.alipay.sofa.healthcheck.log.SofaBootHealthCheckLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ReadinessCheckListener
implements ApplicationContextAware,
PriorityOrdered,
ApplicationListener<ContextRefreshedEvent> {
    private static Logger logger = SofaBootHealthCheckLoggerFactory.getLogger(ReadinessCheckListener.class);
    private ApplicationContext applicationContext;
    @Autowired
    private Environment environment;
    @Autowired
    private HealthCheckerProcessor healthCheckerProcessor;
    @Autowired
    private HealthIndicatorProcessor healthIndicatorProcessor;
    @Autowired
    private AfterReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor;
    private boolean healthCheckerStatus = true;
    private Map<String, Health> healthCheckerDetails = new HashMap<String, Health>();
    private boolean healthIndicatorStatus = true;
    private Map<String, Health> healthIndicatorDetails = new HashMap<String, Health>();
    private boolean healthCallbackStatus = true;
    private boolean readinessCheckFinish = false;
    private Map<String, Health> healthCallbackDetails = new HashMap<String, Health>();

    public void setApplicationContext(ApplicationContext cxt) throws BeansException {
        this.applicationContext = cxt;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext())) {
            this.healthCheckerProcessor.init();
            this.healthIndicatorProcessor.init();
            this.afterReadinessCheckCallbackProcessor.init();
            this.readinessHealthCheck();
            this.readinessCheckFinish = true;
        }
    }

    public void readinessHealthCheck() {
        if (this.skipAllCheck()) {
            logger.warn("Skip all readiness health check.");
        } else {
            if (this.skipComponent()) {
                logger.warn("Skip HealthChecker health check.");
            } else {
                this.healthCheckerStatus = this.healthCheckerProcessor.readinessHealthCheck(this.healthCheckerDetails);
            }
            if (this.skipIndicator()) {
                logger.warn("Skip HealthIndicator health check.");
            } else {
                this.healthIndicatorStatus = this.healthIndicatorProcessor.readinessHealthCheck(this.healthIndicatorDetails);
            }
        }
        this.healthCallbackStatus = this.afterReadinessCheckCallbackProcessor.afterReadinessCheckCallback(this.healthCallbackDetails);
        if (this.healthCheckerStatus && this.healthIndicatorStatus && this.healthCallbackStatus) {
            logger.info("Readiness check result: success");
        } else {
            logger.error("Readiness check result: fail");
        }
    }

    public boolean skipAllCheck() {
        String skipAllCheck = this.environment.getProperty("com.alipay.sofa.healthcheck.skip.all");
        return StringUtils.hasText((String)skipAllCheck) && "true".equalsIgnoreCase(skipAllCheck);
    }

    public boolean skipComponent() {
        String skipComponent = this.environment.getProperty("com.alipay.sofa.healthcheck.skip.component");
        return StringUtils.hasText((String)skipComponent) && "true".equalsIgnoreCase(skipComponent);
    }

    public boolean skipIndicator() {
        String skipIndicator = this.environment.getProperty("com.alipay.sofa.healthcheck.skip.indicator");
        return StringUtils.hasText((String)skipIndicator) && "true".equalsIgnoreCase(skipIndicator);
    }

    public boolean getHealthCheckerStatus() {
        return this.healthCheckerStatus;
    }

    public Map<String, Health> getHealthCheckerDetails() {
        return this.healthCheckerDetails;
    }

    public boolean getHealthIndicatorStatus() {
        return this.healthIndicatorStatus;
    }

    public Map<String, Health> getHealthIndicatorDetails() {
        return this.healthIndicatorDetails;
    }

    public boolean getHealthCallbackStatus() {
        return this.healthCallbackStatus;
    }

    public Map<String, Health> getHealthCallbackDetails() {
        return this.healthCallbackDetails;
    }

    public boolean isReadinessCheckFinish() {
        return this.readinessCheckFinish;
    }
}

