/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.common.top;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.common.top.RollableTopGauge;
import com.alipay.lookout.common.top.TopUtil;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractTopMetric {
    private volatile TreeSet<TopUtil.Entry<Id, Long>> set = new TreeSet<TopUtil.Entry<Id, Long>>(comparator);
    private final int maxNumber;
    private final Registry registry;
    protected final Id id;
    static final Comparator<TopUtil.Entry<Id, Long>> comparator = new Comparator<TopUtil.Entry<Id, Long>>(){

        @Override
        public int compare(TopUtil.Entry<Id, Long> o1, TopUtil.Entry<Id, Long> o2) {
            return o1.getValue() > o2.getValue() ? 1 : (o1.getValue() < o2.getValue() ? -1 : 0);
        }
    };
    private final TopUtil.Order order;
    private long lastRolledStamp = -1L;
    private final Lock lock = new ReentrantLock();

    AbstractTopMetric(Registry registry, Id id, int maxNumber, TopUtil.Order order) {
        this.maxNumber = maxNumber;
        this.registry = registry;
        this.id = id;
        this.order = order;
    }

    protected void pushAsync(Long value, Id timerId) {
        final TopUtil.Entry<Id, Long> entry = new TopUtil.Entry<Id, Long>(timerId, value);
        TopUtil.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractTopMetric.this.lock.lock();
                try {
                    AbstractTopMetric.this.pushSafe(AbstractTopMetric.this.set, entry);
                }
                finally {
                    AbstractTopMetric.this.lock.unlock();
                }
            }
        });
    }

    private void pushSafe(TreeSet<TopUtil.Entry<Id, Long>> set, TopUtil.Entry<Id, Long> e) {
        if (!set.isEmpty()) {
            boolean replaceable = false;
            TopUtil.Entry<Id, Long> boundaryTarget = null;
            replaceable = this.order == TopUtil.Order.DESC ? (boundaryTarget = set.first()).getValue() < e.getValue() : (boundaryTarget = set.last()).getValue() > e.getValue();
            if (replaceable & set.size() >= this.maxNumber) {
                this.remove(set, boundaryTarget);
            }
            if (!replaceable & set.size() >= this.maxNumber) {
                return;
            }
        }
        this.add(set, e);
    }

    private void remove(TreeSet<TopUtil.Entry<Id, Long>> set, TopUtil.Entry<Id, Long> boundaryTarget) {
        if (set.remove(boundaryTarget)) {
            this.registry.removeMetric(boundaryTarget.getKey());
        }
    }

    private void add(TreeSet<TopUtil.Entry<Id, Long>> set, TopUtil.Entry<Id, Long> e) {
        if (set.add(e)) {
            this.getOrAddFromRegistry(this.registry, e);
        }
    }

    protected void getOrAddFromRegistry(Registry registry, TopUtil.Entry<Id, Long> e) {
        registry.gauge(e.getKey(), new RollableTopGauge(this, e.getValue()));
    }

    public void roll(long rollStamp) {
        if (rollStamp > this.lastRolledStamp) {
            this.lastRolledStamp = rollStamp;
            this.set = new TreeSet<TopUtil.Entry<Id, Long>>(comparator);
        }
    }

    public String toString() {
        return "Top_" + this.maxNumber + "_gauger@" + this.id;
    }
}

