/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.autoconfigure.health;

import com.alipay.sofa.boot.actuator.health.MultiApplicationHealthIndicator;
import com.alipay.sofa.boot.actuator.health.ReadinessEndpointWebExtension;
import com.alipay.sofa.boot.actuator.health.SofaBootHealthIndicator;
import com.alipay.sofa.boot.actuator.health.SofaBootReadinessEndpoint;
import com.alipay.sofa.boot.actuator.health.SofaModuleHealthIndicator;
import com.alipay.sofa.healthcheck.AfterReadinessCheckCallbackProcessor;
import com.alipay.sofa.healthcheck.HealthCheckProperties;
import com.alipay.sofa.healthcheck.HealthCheckerProcessor;
import com.alipay.sofa.healthcheck.HealthIndicatorProcessor;
import com.alipay.sofa.healthcheck.ReadinessCheckListener;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.healthcheck.impl.ComponentHealthChecker;
import com.alipay.sofa.healthcheck.impl.ModuleHealthChecker;
import com.alipay.sofa.healthcheck.impl.SofaRuntimeHealthChecker;
import com.alipay.sofa.isle.stage.ModelCreatingStage;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HealthCheckProperties.class})
@ConditionalOnClass(value={HealthChecker.class})
public class SofaBootHealthCheckAutoConfiguration {
    @Bean
    public ReadinessCheckListener readinessCheckListener() {
        return new ReadinessCheckListener();
    }

    @Bean
    public HealthCheckerProcessor healthCheckerProcessor() {
        return new HealthCheckerProcessor();
    }

    @Bean
    public HealthIndicatorProcessor healthIndicatorProcessor() {
        return new HealthIndicatorProcessor();
    }

    @Bean
    public AfterReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor() {
        return new AfterReadinessCheckCallbackProcessor();
    }

    @Bean
    public SofaBootHealthIndicator sofaBootHealthIndicator() {
        return new SofaBootHealthIndicator();
    }

    @Bean
    public SofaRuntimeHealthChecker defaultRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        return new SofaRuntimeHealthChecker(sofaRuntimeContext);
    }

    @Bean
    @ConditionalOnClass(name={"com.alipay.sofa.ark.spi.model.Biz"})
    public MultiApplicationHealthIndicator multiApplicationHealthIndicator() {
        return new MultiApplicationHealthIndicator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint(endpoint=SofaBootReadinessEndpoint.class)
    public SofaBootReadinessEndpoint sofaBootReadinessCheckEndpoint() {
        return new SofaBootReadinessEndpoint();
    }

    @Bean
    public ComponentHealthChecker sofaComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        return new ComponentHealthChecker(sofaRuntimeContext);
    }

    @Configuration
    @AutoConfigureBefore(value={HealthEndpointAutoConfiguration.class})
    @ConditionalOnClass(value={HealthChecker.class})
    public static class ReadinessCheckExtensionConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(endpoint=ReadinessEndpointWebExtension.class)
        public ReadinessEndpointWebExtension readinessEndpointWebExtension() {
            return new ReadinessEndpointWebExtension();
        }

        @Bean
        @ConditionalOnMissingBean
        public HealthStatusHttpMapper createHealthStatusHttpMapper(HealthIndicatorProperties healthIndicatorProperties) {
            HealthStatusHttpMapper statusHttpMapper = new HealthStatusHttpMapper();
            if (healthIndicatorProperties.getHttpMapping() != null) {
                statusHttpMapper.addStatusMapping(healthIndicatorProperties.getHttpMapping());
            }
            statusHttpMapper.addStatusMapping(Status.UNKNOWN, Integer.valueOf(500));
            return statusHttpMapper;
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class, ModelCreatingStage.class})
    public static class SofaModuleHealthIndicatorConfiguration {
        @Bean
        public SofaModuleHealthIndicator sofaModuleHealthIndicator() {
            return new SofaModuleHealthIndicator();
        }

        @Bean
        public ModuleHealthChecker sofaModuleHealthChecker() {
            return new ModuleHealthChecker();
        }
    }
}

