/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.runtime;

import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.api.client.ReferenceClient;
import com.alipay.sofa.runtime.api.client.ServiceClient;
import com.alipay.sofa.runtime.client.impl.ClientFactoryImpl;
import com.alipay.sofa.runtime.component.impl.StandardSofaRuntimeManager;
import com.alipay.sofa.runtime.configure.SofaRuntimeConfigurationProperties;
import com.alipay.sofa.runtime.service.client.ReferenceClientImpl;
import com.alipay.sofa.runtime.service.client.ServiceClientImpl;
import com.alipay.sofa.runtime.service.impl.BindingAdapterFactoryImpl;
import com.alipay.sofa.runtime.service.impl.BindingConverterFactoryImpl;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.AsyncProxyBeanPostProcessor;
import com.alipay.sofa.runtime.spring.RuntimeContextBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.spring.ServiceBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.spring.async.AsyncTaskExecutionListener;
import com.alipay.sofa.runtime.spring.aware.DefaultRuntimeShutdownAware;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SofaRuntimeConfigurationProperties.class})
@ConditionalOnClass(value={SofaFramework.class})
public class SofaRuntimeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DefaultRuntimeShutdownAware defaultRuntimeShutdownAware() {
        return new DefaultRuntimeShutdownAware();
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncTaskExecutionListener asyncTaskExecutionListener() {
        return new AsyncTaskExecutionListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public static AsyncProxyBeanPostProcessor asyncProxyBeanPostProcessor() {
        return new AsyncProxyBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public static BindingConverterFactory bindingConverterFactory() {
        BindingConverterFactoryImpl bindingConverterFactory = new BindingConverterFactoryImpl();
        bindingConverterFactory.addBindingConverters(SofaRuntimeAutoConfiguration.getClassesByServiceLoader(BindingConverter.class));
        return bindingConverterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public static BindingAdapterFactory bindingAdapterFactory() {
        BindingAdapterFactoryImpl bindingAdapterFactory = new BindingAdapterFactoryImpl();
        bindingAdapterFactory.addBindingAdapters(SofaRuntimeAutoConfiguration.getClassesByServiceLoader(BindingAdapter.class));
        return bindingAdapterFactory;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public static SofaRuntimeManager sofaRuntimeManager(@Value(value="${spring.application.name}") String appName, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory) {
        ClientFactoryImpl clientFactoryInternal = new ClientFactoryImpl();
        StandardSofaRuntimeManager sofaRuntimeManager = new StandardSofaRuntimeManager(appName, Thread.currentThread().getContextClassLoader(), (ClientFactoryInternal)clientFactoryInternal);
        sofaRuntimeManager.getComponentManager().registerComponentClient(ReferenceClient.class, (Object)new ReferenceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        sofaRuntimeManager.getComponentManager().registerComponentClient(ServiceClient.class, (Object)new ServiceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        SofaFramework.registerSofaRuntimeManager((SofaRuntimeManager)sofaRuntimeManager);
        return sofaRuntimeManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public static SofaRuntimeContext sofaRuntimeContext(SofaRuntimeManager sofaRuntimeManager) {
        return sofaRuntimeManager.getSofaRuntimeContext();
    }

    @Bean
    @ConditionalOnMissingBean
    public static RuntimeContextBeanFactoryPostProcessor runtimeContextBeanFactoryPostProcessor(BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory, SofaRuntimeContext sofaRuntimeContext) {
        return new RuntimeContextBeanFactoryPostProcessor(bindingAdapterFactory, bindingConverterFactory, sofaRuntimeContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public static ServiceBeanFactoryPostProcessor serviceBeanFactoryPostProcessor(SofaRuntimeContext sofaRuntimeContext, BindingConverterFactory bindingConverterFactory) {
        return new ServiceBeanFactoryPostProcessor(sofaRuntimeContext, bindingConverterFactory);
    }

    public static <T> Set<T> getClassesByServiceLoader(Class<T> clazz) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        HashSet<T> result = new HashSet<T>();
        for (T t : serviceLoader) {
            result.add(t);
        }
        return result;
    }
}

