/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.transport.NamespaceClient;
import com.corundumstudio.socketio.transport.PollingTransport;
import java.util.Collections;
import java.util.List;

public class PacketListener {
    private final NamespacesHub namespacesHub;
    private final AckManager ackManager;
    private final CancelableScheduler scheduler;

    public PacketListener(AckManager ackManager, NamespacesHub namespacesHub, PollingTransport xhrPollingTransport, CancelableScheduler scheduler) {
        this.ackManager = ackManager;
        this.namespacesHub = namespacesHub;
        this.scheduler = scheduler;
    }

    public void onPacket(Packet packet, NamespaceClient client, Transport transport) {
        AckRequest ackRequest = new AckRequest(packet, client);
        if (packet.isAckRequested()) {
            this.ackManager.initAckIndex(client.getSessionId(), packet.getAckId());
        }
        switch (packet.getType()) {
            case PING: {
                Packet outPacket = new Packet(PacketType.PONG);
                outPacket.setData(packet.getData());
                client.getBaseClient().send(outPacket, transport);
                if ("probe".equals(packet.getData())) {
                    client.getBaseClient().send(new Packet(PacketType.NOOP), Transport.POLLING);
                    break;
                }
                client.getBaseClient().schedulePingTimeout();
                break;
            }
            case UPGRADE: {
                client.getBaseClient().schedulePingTimeout();
                SchedulerKey key = new SchedulerKey(SchedulerKey.Type.UPGRADE_TIMEOUT, client.getSessionId());
                this.scheduler.cancel(key);
                client.getBaseClient().upgradeCurrentTransport(transport);
                break;
            }
            case MESSAGE: {
                Namespace namespace;
                client.getBaseClient().schedulePingTimeout();
                if (packet.getSubType() == PacketType.DISCONNECT) {
                    client.onDisconnect();
                }
                if (packet.getSubType() == PacketType.CONNECT) {
                    namespace = this.namespacesHub.get(packet.getNsp());
                    namespace.onConnect(client);
                    client.getBaseClient().send(packet, transport);
                }
                if (packet.getSubType() == PacketType.ACK || packet.getSubType() == PacketType.BINARY_ACK) {
                    this.ackManager.onAck(client, packet);
                }
                if (packet.getSubType() != PacketType.EVENT && packet.getSubType() != PacketType.BINARY_EVENT) break;
                namespace = this.namespacesHub.get(packet.getNsp());
                List args = Collections.emptyList();
                if (packet.getData() != null) {
                    args = (List)packet.getData();
                }
                namespace.onEvent(client, packet.getName(), args, ackRequest);
                break;
            }
            case CLOSE: {
                client.getBaseClient().onChannelDisconnect();
                break;
            }
        }
    }
}

