/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.CompletionCallback;
import io.netty.channel.uring.CompletionQueue;
import io.netty.util.internal.MathUtil;

final class CompletionBuffer {
    private final CompletionCallback callback = this::add;
    private final long[] array;
    private final int capacity;
    private final int mask;
    private final long tombstone;
    private int size;
    private int head;
    private int tail = -1;

    CompletionBuffer(int numCompletions, long tombstone) {
        this.capacity = MathUtil.findNextPositivePowerOfTwo((int)numCompletions);
        this.array = new long[this.capacity];
        this.mask = this.capacity - 1;
        for (int i = 0; i < this.capacity; i += 2) {
            this.array[i] = tombstone;
        }
        this.tombstone = tombstone;
    }

    boolean add(int res, int flags, long udata) {
        if (udata == this.tombstone) {
            throw new IllegalStateException("udata can't be the same as the tombstone");
        }
        this.array[this.combinedIdx((int)(this.tail + 1))] = (long)res << 32 | (long)flags & 0xFFFFFFFFL;
        this.array[this.udataIdx((int)(this.tail + 1))] = udata;
        this.tail += 2;
        this.size += 2;
        return this.size < this.capacity;
    }

    boolean drain(CompletionQueue queue) {
        if (this.size == this.capacity) {
            return false;
        }
        queue.process(this.callback);
        return !queue.hasCompletions();
    }

    int processNow(CompletionCallback callback) {
        int i = 0;
        boolean processing = true;
        while (this.size != 0) {
            long combined = this.array[this.combinedIdx(this.head)];
            long udata = this.array[this.udataIdx(this.head)];
            this.head += 2;
            this.size -= 2;
            if (udata != this.tombstone) {
                processing = CompletionBuffer.handle(callback, combined, udata);
                ++i;
            }
            if (processing) continue;
        }
        return i;
    }

    boolean processOneNow(CompletionCallback callback, long udata) {
        int idx = this.tail - 1;
        int i = 0;
        while (i < this.size) {
            int udataIdx = this.udataIdx(idx);
            long data = this.array[udataIdx];
            if (udata == data) {
                long combined = this.array[this.combinedIdx(idx)];
                this.array[udataIdx] = this.tombstone;
                return CompletionBuffer.handle(callback, combined, udata);
            }
            i += 2;
            idx -= 2;
        }
        return false;
    }

    private int combinedIdx(int idx) {
        return idx & this.mask;
    }

    private int udataIdx(int idx) {
        return idx + 1 & this.mask;
    }

    private static boolean handle(CompletionCallback callback, long combined, long udata) {
        int res = (int)(combined >> 32);
        int flags = (int)combined;
        return callback.handle(res, flags, udata);
    }
}

