/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.aggregation;

import java.util.Comparator;
import java.util.PriorityQueue;
import reactor.core.Dispatcher;
import reactor.rx.action.aggregation.BatchAction;

public class SortAction<T>
extends BatchAction<T, T> {
    private final PriorityQueue<T> values;

    public SortAction(Dispatcher dispatcher, int batchsize, Comparator<? super T> comparator) {
        super(dispatcher, batchsize, true, false, batchsize > 0);
        this.values = comparator == null ? new PriorityQueue() : new PriorityQueue<T>(batchsize > 0 && batchsize < 0x7FFFFFFB ? batchsize : 128, comparator);
    }

    @Override
    public void nextCallback(T value) {
        this.values.add(value);
    }

    @Override
    public void flushCallback(T ev) {
        T value;
        if (this.values.isEmpty()) {
            return;
        }
        while ((value = this.values.poll()) != null) {
            this.broadcastNext(value);
        }
    }
}

