/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos.infra;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosClient {
    private static final Logger logger = LoggerFactory.getLogger(NacosClient.class);
    private String baseUrl;

    public NacosClient(String host, int port) {
        this.baseUrl = String.format("http://%s:%d", host, port);
    }

    public boolean isHealthy() {
        try {
            URL url = new URL(this.baseUrl + "/nacos/actuator/health");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(1000);
            urlConnection.setReadTimeout(1000);
            int status = urlConnection.getResponseCode();
            if (status == 200) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

