/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos.infra;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import name.jervyshi.nacos.exception.NacosEmbeddedException;
import name.jervyshi.nacos.infra.NacosClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosWaiter {
    private static final Logger logger = LoggerFactory.getLogger(NacosWaiter.class);
    private static final int DEFAULT_WAIT_TIME_IN_SECONDS = 30;
    private NacosClient nacosClient;
    private String host;
    private int port;
    private long timeoutMillis;

    public NacosWaiter(String host, int port) {
        this(host, port, 30);
    }

    public NacosWaiter(String host, int port, int timeoutMillis) {
        this.host = host;
        this.port = port;
        this.timeoutMillis = TimeUnit.SECONDS.toMillis(timeoutMillis);
        this.nacosClient = new NacosClient(host, port);
    }

    public void avoidUntilNacosServerStarted() {
        boolean healthy;
        long startTime = System.currentTimeMillis();
        while (!(healthy = this.nacosClient.isHealthy()) && !this.isTimedOut(startTime)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("avoid sleep error", (Throwable)e);
            }
        }
        if (!healthy) {
            throw new NacosEmbeddedException(String.format("Can not start nacos server in %d seconds", TimeUnit.MILLISECONDS.toSeconds(this.timeoutMillis)));
        }
    }

    public boolean avoidUntilNacosServerStopped() {
        long startTime = System.currentTimeMillis();
        while (!this.isTimedOut(startTime)) {
            try {
                Socket ignored = new Socket(this.host, this.port);
                Throwable throwable = null;
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (IOException ignore) {
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    private boolean isTimedOut(long startTime) {
        return System.currentTimeMillis() - startTime >= this.timeoutMillis;
    }
}

