/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.text.Format;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnsynchronizedStaticFormatterRule
extends AbstractJavaRule {
    private Class<?> formatterClassToCheck = Format.class;
    private static final List<String> THREAD_SAFE_FORMATTER = Arrays.asList("org.apache.commons.lang3.time.FastDateFormat");
    private static final PropertyDescriptor<Boolean> ALLOW_METHOD_LEVEL_SYNC = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowMethodLevelSynchronization").desc("If true, method level synchronization is allowed as well as synchronized block. Otherwise only synchronized blocks are allowed.")).defaultValue((Object)false)).build();

    public UnsynchronizedStaticFormatterRule() {
        this.addRuleChainVisit(ASTFieldDeclaration.class);
        this.definePropertyDescriptor(ALLOW_METHOD_LEVEL_SYNC);
    }

    UnsynchronizedStaticFormatterRule(Class<?> formatterClassToCheck) {
        this();
        this.formatterClassToCheck = formatterClassToCheck;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!node.isStatic()) {
            return data;
        }
        ASTClassOrInterfaceType cit = (ASTClassOrInterfaceType)node.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (cit == null || !TypeHelper.isA((TypeNode)cit, this.formatterClassToCheck)) {
            return data;
        }
        ASTVariableDeclaratorId var = (ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        for (String formatter : THREAD_SAFE_FORMATTER) {
            if (!TypeHelper.isA((TypeNode)var, formatter)) continue;
            return data;
        }
        for (NameOccurrence occ : var.getUsages()) {
            ASTMethodDeclaration method;
            ASTName name;
            ASTExpression expression;
            ASTSynchronizedStatement syncStatement;
            ScopedNode n = occ.getLocation();
            if (!n.getImage().contains(".") || (syncStatement = (ASTSynchronizedStatement)n.getFirstParentOfType(ASTSynchronizedStatement.class)) != null && (expression = (ASTExpression)syncStatement.getFirstChildOfType(ASTExpression.class)) != null && (name = (ASTName)expression.getFirstDescendantOfType(ASTName.class)) != null && name.hasImageEqualTo(var.getVariableName()) || ((Boolean)this.getProperty(ALLOW_METHOD_LEVEL_SYNC)).booleanValue() && (method = (ASTMethodDeclaration)n.getFirstParentOfType(ASTMethodDeclaration.class)) != null && method.isSynchronized() && method.isStatic()) continue;
            this.addViolation(data, (Node)n);
        }
        return data;
    }
}

