/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.ReplicaGetOperation;
import net.spy.memcached.protocol.binary.SingleKeyOperationImpl;

public class ReplicaGetOperationImpl
extends SingleKeyOperationImpl
implements ReplicaGetOperation {
    static final byte REPLICA_GET_CMD = -125;
    private final int replicaIndex;
    static final int EXTRA_HDR_LEN = 4;

    public ReplicaGetOperationImpl(String k, int index, ReplicaGetOperation.Callback cb) {
        super((byte)-125, ReplicaGetOperationImpl.generateOpaque(), k, cb);
        this.replicaIndex = index;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected void decodePayload(byte[] pl) {
        int flags = ReplicaGetOperationImpl.decodeInt(pl, 0);
        byte[] data = new byte[pl.length - 4 - this.keyLen];
        System.arraycopy(pl, 4 + this.keyLen, data, 0, pl.length - 4 - this.keyLen);
        ReplicaGetOperation.Callback gcb = (ReplicaGetOperation.Callback)this.getCallback();
        gcb.gotData(this.key, flags, data);
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    public int getReplicaIndex() {
        return this.replicaIndex;
    }
}

