/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 25: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.pushIdentifier();
                this.flushCommentsDefinedPriorTo(this.currentTokenStart);
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 44: {
                this.consumePrimitiveType();
                break;
            }
            case 58: {
                this.consumeReferenceType();
                break;
            }
            case 62: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 63: {
                this.consumeClassOrInterface();
                break;
            }
            case 64: {
                this.consumeGenericType();
                break;
            }
            case 65: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 66: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 67: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 68: {
                this.consumeNameArrayType();
                break;
            }
            case 69: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 70: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 76: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 77: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 86: {
                this.consumeQualifiedName();
                break;
            }
            case 89: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 94: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 95: {
                this.consumeQualifiedName(false);
                break;
            }
            case 96: {
                this.consumeQualifiedName(true);
                break;
            }
            case 97: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 101: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 102: {
                this.consumeTypeAnnotation();
                break;
            }
            case 103: {
                this.consumeTypeAnnotation();
                break;
            }
            case 104: {
                this.consumeTypeAnnotation();
                break;
            }
            case 105: {
                this.consumeAnnotationName();
                break;
            }
            case 106: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 107: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 108: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 109: {
                this.consumeNonTypeUseName();
                break;
            }
            case 110: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 111: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 112: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 113: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 114: {
                this.consumeCompilationUnit();
                break;
            }
            case 115: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 116: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 117: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 118: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 119: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 120: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 121: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 122: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 123: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 124: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 125: {
                this.consumeModuleDeclaration();
                break;
            }
            case 126: {
                this.consumeModuleHeader();
                break;
            }
            case 128: {
                this.consumeModuleModifiers();
                break;
            }
            case 131: {
                this.consumeEmptyModuleStatementsOpt();
                break;
            }
            case 134: {
                this.consumeModuleStatements();
                break;
            }
            case 140: {
                this.consumeRequiresStatement();
                break;
            }
            case 141: {
                this.consumeSingleRequiresModuleName();
                break;
            }
            case 142: {
                this.consumeModifiers();
                break;
            }
            case 143: {
                this.consumeDefaultModifiers();
                break;
            }
            case 145: {
                this.consumeModifiers2();
                break;
            }
            case 148: {
                this.consumeExportsStatement();
                break;
            }
            case 149: {
                this.consumeExportsHeader();
                break;
            }
            case 151: {
                this.consumeTargetModuleList();
                break;
            }
            case 152: {
                this.consumeSingleTargetModuleName();
                break;
            }
            case 154: {
                this.consumeTargetModuleNameList();
                break;
            }
            case 155: {
                this.consumeSinglePkgName();
                break;
            }
            case 156: {
                this.consumeOpensStatement();
                break;
            }
            case 157: {
                this.consumeOpensHeader();
                break;
            }
            case 158: {
                this.consumeUsesStatement();
                break;
            }
            case 159: {
                this.consumeUsesHeader();
                break;
            }
            case 160: {
                this.consumeProvidesStatement();
                break;
            }
            case 161: {
                this.consumeProvidesInterface();
                break;
            }
            case 162: {
                this.consumeSingleServiceImplName();
                break;
            }
            case 164: {
                this.consumeServiceImplNameList();
                break;
            }
            case 165: {
                this.consumeWithClause();
                break;
            }
            case 166: {
                this.consumeReduceImports();
                break;
            }
            case 167: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 190: {
                this.consumeCatchHeader();
                break;
            }
            case 192: {
                this.consumeImportDeclarations();
                break;
            }
            case 194: {
                this.consumeTypeDeclarations();
                break;
            }
            case 195: {
                this.consumePackageDeclaration();
                break;
            }
            case 196: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 197: {
                this.consumePackageDeclarationName();
                break;
            }
            case 198: {
                this.consumePackageComment();
                break;
            }
            case 203: {
                this.consumeImportDeclaration();
                break;
            }
            case 204: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 205: {
                this.consumeImportDeclaration();
                break;
            }
            case 206: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 209: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 214: {
                this.consumeModifiers2();
                break;
            }
            case 229: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 242: {
                this.consumeAspectDeclaration();
                break;
            }
            case 243: {
                this.consumeAspectHeader();
                break;
            }
            case 246: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 247: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 248: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 249: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 251: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 252: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 255: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 256: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 257: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 258: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 262: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 273: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 275: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 276: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 277: {
                this.consumeMethodHeader();
                break;
            }
            case 278: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 279: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 280: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 281: {
                this.consumePointcutDeclaration();
                break;
            }
            case 282: {
                this.consumePointcutHeader();
                break;
            }
            case 285: {
                this.consumeAroundDeclaration();
                break;
            }
            case 286: {
                this.consumeAroundHeader();
                break;
            }
            case 287: {
                this.consumeAroundHeaderName();
                break;
            }
            case 288: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 289: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 292: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 293: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 294: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 295: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 296: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 297: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 298: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 300: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 301: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 306: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 307: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 308: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 309: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 310: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 311: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 312: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 313: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 314: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 315: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 316: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 317: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 318: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 319: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 320: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 321: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 322: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 323: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 324: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 325: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 326: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 327: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 328: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 329: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 330: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 332: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 333: {
                this.consumeDeclareHeader();
                break;
            }
            case 334: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 335: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 336: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 339: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 342: {
                this.consumePseudoTokens();
                break;
            }
            case 343: {
                this.consumePseudoTokens();
                break;
            }
            case 345: {
                this.consumePseudoTokens();
                break;
            }
            case 346: {
                this.consumePseudoToken(":");
                break;
            }
            case 347: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 348: {
                this.consumePseudoToken("(");
                break;
            }
            case 349: {
                this.consumePseudoToken(")");
                break;
            }
            case 350: {
                this.consumePseudoToken(".");
                break;
            }
            case 351: {
                this.consumePseudoToken("*");
                break;
            }
            case 352: {
                this.consumePseudoToken("+");
                break;
            }
            case 353: {
                this.consumePseudoToken("=");
                break;
            }
            case 354: {
                this.consumePseudoToken("&&");
                break;
            }
            case 355: {
                this.consumePseudoToken("||");
                break;
            }
            case 356: {
                this.consumePseudoToken("!");
                break;
            }
            case 357: {
                this.consumePseudoToken(",");
                break;
            }
            case 358: {
                this.consumePseudoToken("[");
                break;
            }
            case 359: {
                this.consumePseudoToken("]");
                break;
            }
            case 360: {
                this.consumePseudoToken("@");
                break;
            }
            case 361: {
                this.consumePseudoToken("...");
                break;
            }
            case 362: {
                this.consumePseudoToken("?");
                break;
            }
            case 363: {
                this.consumePseudoToken("<");
                break;
            }
            case 364: {
                this.consumePseudoToken(">");
                break;
            }
            case 365: {
                this.consumePseudoToken(">>");
                break;
            }
            case 366: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 367: {
                this.consumePseudoToken("&");
                break;
            }
            case 368: {
                this.consumePseudoToken("!=");
                break;
            }
            case 369: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 370: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 371: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 372: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 373: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 374: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 375: {
                this.consumePseudoTokenIf();
                break;
            }
            case 376: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 377: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 378: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 379: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 380: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 381: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 382: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 383: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 384: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 385: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 386: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 387: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 388: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 389: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 390: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 391: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 392: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 393: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 394: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 395: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 396: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 397: {
                this.consumeClassDeclaration();
                break;
            }
            case 398: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 399: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 400: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 402: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 403: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 404: {
                this.consumeClassHeader();
                break;
            }
            case 405: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 407: {
                this.consumeClassHeaderName1();
                break;
            }
            case 408: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 409: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 411: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 412: {
                this.consumeInterfaceType();
                break;
            }
            case 415: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 419: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 420: {
                this.consumeDiet();
                break;
            }
            case 421: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 422: {
                this.consumeCreateInitializer();
                break;
            }
            case 430: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 433: {
                this.consumeFieldDeclaration();
                break;
            }
            case 435: {
                this.consumeVariableDeclarators();
                break;
            }
            case 438: {
                this.consumeEnterVariable();
                break;
            }
            case 439: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 440: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 441: {
                this.consumeForceNoDiet();
                break;
            }
            case 442: {
                this.consumeRestoreDiet();
                break;
            }
            case 447: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 448: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 449: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 450: {
                this.consumeMethodHeader();
                break;
            }
            case 451: {
                this.consumeMethodHeader();
                break;
            }
            case 452: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 453: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 454: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 455: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 456: {
                this.consumePushCombineModifiers();
                break;
            }
            case 457: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 458: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 459: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 460: {
                this.consumeConstructorHeader();
                break;
            }
            case 461: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 462: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 463: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 465: {
                this.consumeFormalParameterList();
                break;
            }
            case 466: {
                this.consumeFormalParameter(false);
                break;
            }
            case 467: {
                this.consumeFormalParameter(true);
                break;
            }
            case 468: {
                this.consumeFormalParameter(true);
                break;
            }
            case 469: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 470: {
                this.consumeCatchType();
                break;
            }
            case 471: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 472: {
                this.consumeUnionType();
                break;
            }
            case 474: {
                this.consumeClassTypeList();
                break;
            }
            case 475: {
                this.consumeClassTypeElt();
                break;
            }
            case 476: {
                this.consumeMethodBody();
                break;
            }
            case 477: {
                this.consumeNestedMethod();
                break;
            }
            case 478: {
                this.consumeStaticInitializer();
                break;
            }
            case 479: {
                this.consumeStaticOnly();
                break;
            }
            case 480: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 481: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 482: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 483: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 484: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 485: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 486: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 487: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 488: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 489: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 490: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 491: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 492: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 493: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 494: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 495: {
                this.consumeInterfaceHeader();
                break;
            }
            case 496: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 498: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 499: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 502: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 503: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 505: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 506: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 507: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 508: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 509: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 520: {
                this.consumeRecordDeclaration();
                break;
            }
            case 521: {
                this.consumeRecordHeaderPart();
                break;
            }
            case 522: {
                this.consumeRecordHeaderNameWithTypeParameters();
                break;
            }
            case 524: {
                this.consumeRecordHeaderName1();
                break;
            }
            case 525: {
                this.consumeRecordComponentHeaderRightParen();
                break;
            }
            case 526: {
                this.consumeRecordHeader();
                break;
            }
            case 527: {
                this.consumeRecordComponentsopt();
                break;
            }
            case 530: {
                this.consumeRecordComponents();
                break;
            }
            case 532: {
                this.consumeRecordComponent(false);
                break;
            }
            case 533: {
                this.consumeRecordComponent(true);
                break;
            }
            case 534: {
                this.consumeRecordComponent(true);
                break;
            }
            case 535: {
                this.consumeRecordBody();
                break;
            }
            case 536: {
                this.consumeEmptyRecordBodyDeclaration();
                break;
            }
            case 539: {
                this.consumeRecordBodyDeclarations();
                break;
            }
            case 540: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 541: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 542: {
                this.consumeCompactConstructorDeclaration();
                break;
            }
            case 543: {
                this.consumeCompactConstructorHeader();
                break;
            }
            case 544: {
                this.consumeCompactConstructorHeaderName();
                break;
            }
            case 545: {
                this.consumeCompactConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 547: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 549: {
                this.consumeInstanceOfRHS();
                break;
            }
            case 550: {
                this.consumeInstanceOfClassic();
                break;
            }
            case 551: {
                this.consumeInstanceofPattern();
                break;
            }
            case 553: {
                this.consumePushLeftBrace();
                break;
            }
            case 554: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 555: {
                this.consumeArrayInitializer();
                break;
            }
            case 556: {
                this.consumeArrayInitializer();
                break;
            }
            case 558: {
                this.consumeVariableInitializers();
                break;
            }
            case 559: {
                this.consumeBlock();
                break;
            }
            case 560: {
                this.consumeOpenBlock();
                break;
            }
            case 561: {
                this.consumeBlockStatement();
                break;
            }
            case 562: {
                this.consumeBlockStatements();
                break;
            }
            case 570: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 571: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 572: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 573: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 574: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 575: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 576: {
                this.consumePushModifiers();
                break;
            }
            case 577: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 578: {
                this.consumePushRealModifiers();
                break;
            }
            case 606: {
                this.consumeEmptyStatement();
                break;
            }
            case 607: {
                this.consumeStatementLabel();
                break;
            }
            case 608: {
                this.consumeStatementLabel();
                break;
            }
            case 609: {
                this.consumeLabel();
                break;
            }
            case 610: {
                this.consumeExpressionStatement();
                break;
            }
            case 619: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 620: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 621: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 622: {
                this.consumeStatementSwitch();
                break;
            }
            case 623: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 626: {
                this.consumeSwitchBlock();
                break;
            }
            case 628: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 630: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 632: {
                this.consumeSwitchLabels();
                break;
            }
            case 633: {
                this.consumeCaseLabel();
                break;
            }
            case 634: {
                this.consumeDefaultLabel();
                break;
            }
            case 637: {
                this.consumeSwitchExpression();
                break;
            }
            case 640: {
                this.consumeSwitchLabeledRule();
                break;
            }
            case 641: {
                this.consumeSwitchLabeledExpression();
                break;
            }
            case 642: {
                this.consumeSwitchLabeledBlock();
                break;
            }
            case 643: {
                this.consumeSwitchLabeledThrowStatement();
                break;
            }
            case 644: {
                this.consumeDefaultLabelExpr();
                break;
            }
            case 645: {
                this.consumeCaseLabelExpr();
                break;
            }
            case 646: {
                this.consumeSwitchLabelCaseLhs();
                break;
            }
            case 647: {
                this.consumeStatementYield();
                break;
            }
            case 648: {
                this.consumeStatementWhile();
                break;
            }
            case 649: {
                this.consumeStatementWhile();
                break;
            }
            case 650: {
                this.consumeStatementDo();
                break;
            }
            case 651: {
                this.consumeStatementFor();
                break;
            }
            case 652: {
                this.consumeStatementFor();
                break;
            }
            case 653: {
                this.consumeForInit();
                break;
            }
            case 657: {
                this.consumeStatementExpressionList();
                break;
            }
            case 658: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 659: {
                this.consumeAssertStatement();
                break;
            }
            case 660: {
                this.consumeStatementBreak();
                break;
            }
            case 661: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 662: {
                this.consumeStatementContinue();
                break;
            }
            case 663: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 664: {
                this.consumeStatementReturn();
                break;
            }
            case 665: {
                this.consumeStatementThrow();
                break;
            }
            case 666: {
                this.consumeThrowExpression();
                break;
            }
            case 667: {
                this.consumeStatementSynchronized();
                break;
            }
            case 668: {
                this.consumeOnlySynchronized();
                break;
            }
            case 669: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 670: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 671: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 672: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 673: {
                this.consumeResourceSpecification();
                break;
            }
            case 674: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 675: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 676: {
                this.consumeSingleResource();
                break;
            }
            case 677: {
                this.consumeMultipleResources();
                break;
            }
            case 678: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 679: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 680: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 681: {
                this.consumeResourceAsLocalVariable();
                break;
            }
            case 682: {
                this.consumeResourceAsFieldAccess();
                break;
            }
            case 684: {
                this.consumeExitTryBlock();
                break;
            }
            case 686: {
                this.consumeCatches();
                break;
            }
            case 687: {
                this.consumeStatementCatch();
                break;
            }
            case 689: {
                this.consumeLeftParen();
                break;
            }
            case 690: {
                this.consumeRightParen();
                break;
            }
            case 695: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 696: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 697: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 700: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 701: {
                this.consumeQualifiedSuperReceiver();
                break;
            }
            case 702: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 703: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 704: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 705: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 711: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 712: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 713: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 714: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 715: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 716: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 717: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 718: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 719: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 721: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 722: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 723: {
                this.consumeLambdaExpression();
                break;
            }
            case 724: {
                this.consumeNestedLambda();
                break;
            }
            case 725: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 731: {
                this.consumeFormalParameterList();
                break;
            }
            case 732: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 735: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 736: {
                this.consumeAllocationHeader();
                break;
            }
            case 737: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 738: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 739: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 740: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 741: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 742: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 743: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 744: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 745: {
                this.consumeClassBodyopt();
                break;
            }
            case 747: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 748: {
                this.consumeClassBodyopt();
                break;
            }
            case 750: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 752: {
                this.consumeArgumentList();
                break;
            }
            case 753: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 754: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 755: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 756: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 757: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 758: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 760: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 762: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 763: {
                this.consumeDims();
                break;
            }
            case 766: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 767: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 768: {
                this.consumeFieldAccess(false);
                break;
            }
            case 769: {
                this.consumeFieldAccess(true);
                break;
            }
            case 770: {
                this.consumeFieldAccess(false);
                break;
            }
            case 771: {
                this.consumeMethodInvocationName();
                break;
            }
            case 772: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 773: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 774: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 775: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 776: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 777: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 778: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 779: {
                this.consumeArrayAccess(true);
                break;
            }
            case 780: {
                this.consumeArrayAccess(true);
                break;
            }
            case 781: {
                this.consumeArrayAccess(false);
                break;
            }
            case 782: {
                this.consumeArrayAccess(false);
                break;
            }
            case 784: {
                this.consumePostfixExpression();
                break;
            }
            case 787: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 788: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 789: {
                this.consumePushPosition();
                break;
            }
            case 792: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 793: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 795: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 796: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 798: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 799: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 801: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 802: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 803: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 804: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 805: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 806: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 807: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 811: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 812: {
                this.consumeInsideCastExpression();
                break;
            }
            case 813: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 814: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 815: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 817: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 818: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 819: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 821: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 822: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 824: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 825: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 826: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 828: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 829: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 830: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 831: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 833: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 834: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 836: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 838: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 840: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 842: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 844: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 846: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 849: {
                this.consumeAssignment();
                break;
            }
            case 851: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 852: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 853: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 854: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 855: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 856: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 857: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 858: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 859: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 860: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 861: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 862: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 863: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 864: {
                this.consumeExpression();
                break;
            }
            case 867: {
                this.consumeEmptyExpression();
                break;
            }
            case 870: {
                this.consumeConstantExpressions();
                break;
            }
            case 874: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 875: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 876: {
                this.consumeDefaultModifiers();
                break;
            }
            case 877: {
                this.consumeModifiers();
                break;
            }
            case 878: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 880: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 882: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 886: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 893: {
                this.consumeClassHeaderPermittedSubclasses();
                break;
            }
            case 896: {
                this.consumeInterfaceHeaderPermittedSubClassesAndSubInterfaces();
                break;
            }
            case 897: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 898: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 899: {
                this.consumeNestedType();
                break;
            }
            case 900: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 902: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 906: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 908: {
                this.consumeEnumDeclaration();
                break;
            }
            case 909: {
                this.consumeEnumHeader();
                break;
            }
            case 910: {
                this.consumeEnumHeaderName();
                break;
            }
            case 911: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 912: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 913: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 914: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 915: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 917: {
                this.consumeEnumConstants();
                break;
            }
            case 918: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 919: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 920: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 921: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 922: {
                this.consumeArguments();
                break;
            }
            case 923: {
                this.consumeEmptyArguments();
                break;
            }
            case 925: {
                this.consumeEnumDeclarations();
                break;
            }
            case 926: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 928: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 929: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 930: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 931: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 932: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 933: {
                this.consumeImportDeclaration();
                break;
            }
            case 934: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 935: {
                this.consumeImportDeclaration();
                break;
            }
            case 936: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 937: {
                this.consumeTypeArguments();
                break;
            }
            case 938: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 940: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 942: {
                this.consumeTypeArgumentList();
                break;
            }
            case 943: {
                this.consumeTypeArgument();
                break;
            }
            case 947: {
                this.consumeReferenceType1();
                break;
            }
            case 948: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 950: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 953: {
                this.consumeReferenceType2();
                break;
            }
            case 954: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 956: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 959: {
                this.consumeReferenceType3();
                break;
            }
            case 960: {
                this.consumeWildcard();
                break;
            }
            case 961: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 962: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 963: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 964: {
                this.consumeWildcard1();
                break;
            }
            case 965: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 966: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 967: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 968: {
                this.consumeWildcard2();
                break;
            }
            case 969: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 970: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 971: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 972: {
                this.consumeWildcard3();
                break;
            }
            case 973: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 974: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 975: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 976: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 977: {
                this.consumeTypeParameters();
                break;
            }
            case 979: {
                this.consumeTypeParameterList();
                break;
            }
            case 981: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 982: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 984: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 985: {
                this.consumeAdditionalBound();
                break;
            }
            case 987: {
                this.consumeTypeParameterList1();
                break;
            }
            case 988: {
                this.consumeTypeParameter1();
                break;
            }
            case 989: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 990: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 992: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 993: {
                this.consumeAdditionalBound1();
                break;
            }
            case 999: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 1000: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 1003: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 1004: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 1007: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 1008: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 1009: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 1010: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 1011: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 1012: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 1014: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 1015: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 1016: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 1017: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 1019: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 1020: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 1021: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 1022: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 1023: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 1024: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 1026: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 1027: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 1028: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 1029: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 1030: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 1031: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 1032: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 1033: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 1035: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 1036: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 1038: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 1039: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 1040: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 1041: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 1043: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 1044: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 1046: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 1047: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 1049: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 1050: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 1052: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 1053: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 1055: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 1056: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 1058: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 1059: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 1063: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1064: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1065: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1066: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1067: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 1068: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 1070: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1071: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1073: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 1074: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 1075: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 1076: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 1077: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 1078: {
                this.consumeMethodHeader();
                break;
            }
            case 1079: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 1087: {
                this.consumeAnnotationName();
                break;
            }
            case 1088: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 1089: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 1092: {
                this.consumeMemberValuePairs();
                break;
            }
            case 1093: {
                this.consumeMemberValuePair();
                break;
            }
            case 1094: {
                this.consumeEnterMemberValue();
                break;
            }
            case 1095: {
                this.consumeExitMemberValue();
                break;
            }
            case 1097: {
                this.consumeMemberValueAsName();
                break;
            }
            case 1100: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1101: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1102: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1103: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1104: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 1106: {
                this.consumeMemberValues();
                break;
            }
            case 1107: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 1108: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 1109: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 1110: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1111: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1112: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1113: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1114: {
                this.consumeMethodHeader();
                break;
            }
            case 1115: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 58) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 12, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

