/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.io;

import cfca.com.itextpdf.text.io.RandomAccessSource;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static byte[] inputStreamToArray(InputStream is) throws IOException {
        int read;
        byte[] b = new byte[8192];
        ByteBuffer byteBuffer = new ByteBuffer();
        while ((read = is.read(b)) >= 1) {
            byteBuffer.write(b, 0, read);
        }
        byteBuffer.close();
        return byteBuffer.toByteArray();
    }

    public static void CopyBytes(RandomAccessSource source, long start, long length, OutputStream outs) throws IOException {
        if (length <= 0L) {
            return;
        }
        long idx = start;
        byte[] buf = new byte[8192];
        while (length > 0L) {
            long n = source.get(idx, buf, 0, (int)Math.min((long)buf.length, length));
            if (n <= 0L) {
                throw new EOFException();
            }
            outs.write(buf, 0, (int)n);
            idx += n;
            length -= n;
        }
    }

    public static InputStream getResourceStream(String key) {
        return StreamUtil.getResourceStream(key, null);
    }

    public static InputStream getResourceStream(String key, ClassLoader loader) {
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        InputStream is = null;
        if (loader != null && (is = loader.getResourceAsStream(key)) != null) {
            return is;
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                is = contextClassLoader.getResourceAsStream(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (is == null) {
            is = StreamUtil.class.getResourceAsStream("/" + key);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(key);
        }
        return is;
    }
}

