/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.log.Counter;
import cfca.com.itextpdf.text.log.CounterFactory;
import cfca.com.itextpdf.text.pdf.PRIndirectReference;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FdfReader
extends PdfReader {
    HashMap<String, PdfDictionary> fields;
    String fileSpec;
    PdfName encoding;
    protected static Counter COUNTER = CounterFactory.getCounter(FdfReader.class);

    public FdfReader(String filename) throws IOException {
        super(filename);
    }

    public FdfReader(byte[] pdfIn) throws IOException {
        super(pdfIn);
    }

    public FdfReader(URL url) throws IOException {
        super(url);
    }

    public FdfReader(InputStream is) throws IOException {
        super(is);
    }

    @Override
    protected Counter getCounter() {
        return COUNTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
        this.readFields();
    }

    protected void kidNode(PdfDictionary merged, String name) {
        PdfArray kids = merged.getAsArray(PdfName.KIDS);
        if (kids == null || kids.isEmpty()) {
            if (name.length() > 0) {
                name = name.substring(1);
            }
            this.fields.put(name, merged);
        } else {
            merged.remove(PdfName.KIDS);
            for (int k = 0; k < kids.size(); ++k) {
                PdfDictionary dic = new PdfDictionary();
                dic.merge(merged);
                PdfDictionary newDic = kids.getAsDict(k);
                PdfString t = newDic.getAsString(PdfName.T);
                String newName = name;
                if (t != null) {
                    newName = newName + "." + t.toUnicodeString();
                }
                dic.merge(newDic);
                dic.remove(PdfName.T);
                this.kidNode(dic, newName);
            }
        }
    }

    protected void readFields() {
        PdfArray fld;
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        PdfDictionary fdf = this.catalog.getAsDict(PdfName.FDF);
        if (fdf == null) {
            return;
        }
        PdfString fs = fdf.getAsString(PdfName.F);
        if (fs != null) {
            this.fileSpec = fs.toUnicodeString();
        }
        if ((fld = fdf.getAsArray(PdfName.FIELDS)) == null) {
            return;
        }
        this.encoding = fdf.getAsName(PdfName.ENCODING);
        PdfDictionary merged = new PdfDictionary();
        merged.put(PdfName.KIDS, fld);
        this.kidNode(merged, "");
    }

    public HashMap<String, PdfDictionary> getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String name) {
        return this.fields.get(name);
    }

    public byte[] getAttachedFile(String name) throws IOException {
        PdfDictionary field = this.fields.get(name);
        if (field != null) {
            PRIndirectReference ir = (PRIndirectReference)field.get(PdfName.V);
            PdfDictionary filespec = (PdfDictionary)this.getPdfObject(ir.getNumber());
            PdfDictionary ef = filespec.getAsDict(PdfName.EF);
            ir = (PRIndirectReference)ef.get(PdfName.F);
            PRStream stream = (PRStream)this.getPdfObject(ir.getNumber());
            return FdfReader.getStreamBytes(stream);
        }
        return new byte[0];
    }

    public String getFieldValue(String name) {
        PdfDictionary field = this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject v = FdfReader.getPdfObject(field.get(PdfName.V));
        if (v == null) {
            return null;
        }
        if (v.isName()) {
            return PdfName.decodeName(((PdfName)v).toString());
        }
        if (v.isString()) {
            PdfString vs = (PdfString)v;
            if (this.encoding == null || vs.getEncoding() != null) {
                return vs.toUnicodeString();
            }
            byte[] b = vs.getBytes();
            if (b.length >= 2 && b[0] == -2 && b[1] == -1) {
                return vs.toUnicodeString();
            }
            try {
                if (this.encoding.equals(PdfName.SHIFT_JIS)) {
                    return new String(b, "SJIS");
                }
                if (this.encoding.equals(PdfName.UHC)) {
                    return new String(b, "MS949");
                }
                if (this.encoding.equals(PdfName.GBK)) {
                    return new String(b, "GBK");
                }
                if (this.encoding.equals(PdfName.BIGFIVE)) {
                    return new String(b, "Big5");
                }
                if (this.encoding.equals(PdfName.UTF_8)) {
                    return new String(b, "UTF8");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return vs.toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

