/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.awt.FontMapper;
import cfca.com.itextpdf.awt.PdfGraphics2D;
import cfca.com.itextpdf.awt.PdfPrinterGraphics2D;
import cfca.com.itextpdf.awt.geom.Point2D;
import cfca.com.itextpdf.text.Annotation;
import cfca.com.itextpdf.text.BaseColor;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.ExceptionConverter;
import cfca.com.itextpdf.text.Image;
import cfca.com.itextpdf.text.ImgJBIG2;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.exceptions.IllegalPdfSyntaxException;
import cfca.com.itextpdf.text.pdf.BaseFont;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.CMYKColor;
import cfca.com.itextpdf.text.pdf.ColorDetails;
import cfca.com.itextpdf.text.pdf.ExtendedColor;
import cfca.com.itextpdf.text.pdf.FontDetails;
import cfca.com.itextpdf.text.pdf.GrayColor;
import cfca.com.itextpdf.text.pdf.PageResources;
import cfca.com.itextpdf.text.pdf.PatternColor;
import cfca.com.itextpdf.text.pdf.PdfAction;
import cfca.com.itextpdf.text.pdf.PdfAnnotation;
import cfca.com.itextpdf.text.pdf.PdfAppearance;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDestination;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfDocument;
import cfca.com.itextpdf.text.pdf.PdfGState;
import cfca.com.itextpdf.text.pdf.PdfImage;
import cfca.com.itextpdf.text.pdf.PdfIndirectReference;
import cfca.com.itextpdf.text.pdf.PdfLayer;
import cfca.com.itextpdf.text.pdf.PdfLayerMembership;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfOCG;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfOutline;
import cfca.com.itextpdf.text.pdf.PdfPSXObject;
import cfca.com.itextpdf.text.pdf.PdfPatternPainter;
import cfca.com.itextpdf.text.pdf.PdfShading;
import cfca.com.itextpdf.text.pdf.PdfShadingPattern;
import cfca.com.itextpdf.text.pdf.PdfSpotColor;
import cfca.com.itextpdf.text.pdf.PdfStructureElement;
import cfca.com.itextpdf.text.pdf.PdfTemplate;
import cfca.com.itextpdf.text.pdf.PdfTextArray;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import cfca.com.itextpdf.text.pdf.ShadingColor;
import cfca.com.itextpdf.text.pdf.SpotColor;
import cfca.com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import cfca.com.itextpdf.text.pdf.internal.PdfAnnotationsImp;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfContentByte {
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int LINE_CAP_BUTT = 0;
    public static final int LINE_CAP_ROUND = 1;
    public static final int LINE_CAP_PROJECTING_SQUARE = 2;
    public static final int LINE_JOIN_MITER = 0;
    public static final int LINE_JOIN_ROUND = 1;
    public static final int LINE_JOIN_BEVEL = 2;
    public static final int TEXT_RENDER_MODE_FILL = 0;
    public static final int TEXT_RENDER_MODE_STROKE = 1;
    public static final int TEXT_RENDER_MODE_FILL_STROKE = 2;
    public static final int TEXT_RENDER_MODE_INVISIBLE = 3;
    public static final int TEXT_RENDER_MODE_FILL_CLIP = 4;
    public static final int TEXT_RENDER_MODE_STROKE_CLIP = 5;
    public static final int TEXT_RENDER_MODE_FILL_STROKE_CLIP = 6;
    public static final int TEXT_RENDER_MODE_CLIP = 7;
    private static final float[] unitRect = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    protected ByteBuffer content = new ByteBuffer();
    protected int markedContentSize = 0;
    protected PdfWriter writer;
    protected PdfDocument pdf;
    protected GraphicState state = new GraphicState();
    protected ArrayList<GraphicState> stateList = new ArrayList();
    protected ArrayList<Integer> layerDepth;
    protected int separator = 10;
    private int mcDepth = 0;
    private boolean inText = false;
    private static HashMap<PdfName, String> abrev = new HashMap();
    private ArrayList<IAccessibleElement> mcElements = new ArrayList();
    protected PdfContentByte duplicatedFrom = null;

    public PdfContentByte(PdfWriter wr) {
        if (wr != null) {
            this.writer = wr;
            this.pdf = this.writer.getPdfDocument();
        }
    }

    public String toString() {
        return this.content.toString();
    }

    public boolean isTagged() {
        return this.writer != null && this.writer.isTagged();
    }

    public ByteBuffer getInternalBuffer() {
        return this.content;
    }

    public byte[] toPdf(PdfWriter writer) {
        this.sanityCheck();
        return this.content.toByteArray();
    }

    public void add(PdfContentByte other) {
        if (other.writer != null && this.writer != other.writer) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.writers.are.you.mixing.two.documents", new Object[0]));
        }
        this.content.append(other.content);
        this.markedContentSize += other.markedContentSize;
    }

    public float getXTLM() {
        return this.state.xTLM;
    }

    public float getYTLM() {
        return this.state.yTLM;
    }

    public float getLeading() {
        return this.state.leading;
    }

    public float getCharacterSpacing() {
        return this.state.charSpace;
    }

    public float getWordSpacing() {
        return this.state.wordSpace;
    }

    public float getHorizontalScaling() {
        return this.state.scale;
    }

    public void setFlatness(float flatness) {
        if (flatness >= 0.0f && flatness <= 100.0f) {
            this.content.append(flatness).append(" i").append_i(this.separator);
        }
    }

    public void setLineCap(int style) {
        if (style >= 0 && style <= 2) {
            this.content.append(style).append(" J").append_i(this.separator);
        }
    }

    public void setLineDash(float phase) {
        this.content.append("[] ").append(phase).append(" d").append_i(this.separator);
    }

    public void setLineDash(float unitsOn, float phase) {
        this.content.append("[").append(unitsOn).append("] ").append(phase).append(" d").append_i(this.separator);
    }

    public void setLineDash(float unitsOn, float unitsOff, float phase) {
        this.content.append("[").append(unitsOn).append(' ').append(unitsOff).append("] ").append(phase).append(" d").append_i(this.separator);
    }

    public final void setLineDash(float[] array, float phase) {
        this.content.append("[");
        for (int i = 0; i < array.length; ++i) {
            this.content.append(array[i]);
            if (i >= array.length - 1) continue;
            this.content.append(' ');
        }
        this.content.append("] ").append(phase).append(" d").append_i(this.separator);
    }

    public void setLineJoin(int style) {
        if (style >= 0 && style <= 2) {
            this.content.append(style).append(" j").append_i(this.separator);
        }
    }

    public void setLineWidth(float w) {
        this.content.append(w).append(" w").append_i(this.separator);
    }

    public void setMiterLimit(float miterLimit) {
        if (miterLimit > 1.0f) {
            this.content.append(miterLimit).append(" M").append_i(this.separator);
        }
    }

    public void clip() {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.content.append("W").append_i(this.separator);
    }

    public void eoClip() {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.content.append("W*").append_i(this.separator);
    }

    public void setGrayFill(float gray) {
        this.saveColor(new GrayColor(gray), true);
        this.content.append(gray).append(" g").append_i(this.separator);
    }

    public void resetGrayFill() {
        this.saveColor(new GrayColor(0), true);
        this.content.append("0 g").append_i(this.separator);
    }

    public void setGrayStroke(float gray) {
        this.saveColor(new GrayColor(gray), false);
        this.content.append(gray).append(" G").append_i(this.separator);
    }

    public void resetGrayStroke() {
        this.saveColor(new GrayColor(0), false);
        this.content.append("0 G").append_i(this.separator);
    }

    private void HelperRGB(float red, float green, float blue) {
        if (red < 0.0f) {
            red = 0.0f;
        } else if (red > 1.0f) {
            red = 1.0f;
        }
        if (green < 0.0f) {
            green = 0.0f;
        } else if (green > 1.0f) {
            green = 1.0f;
        }
        if (blue < 0.0f) {
            blue = 0.0f;
        } else if (blue > 1.0f) {
            blue = 1.0f;
        }
        this.content.append(red).append(' ').append(green).append(' ').append(blue);
    }

    public void setRGBColorFillF(float red, float green, float blue) {
        this.saveColor(new BaseColor(red, green, blue), true);
        this.HelperRGB(red, green, blue);
        this.content.append(" rg").append_i(this.separator);
    }

    public void resetRGBColorFill() {
        this.resetGrayFill();
    }

    public void setRGBColorStrokeF(float red, float green, float blue) {
        this.saveColor(new BaseColor(red, green, blue), false);
        this.HelperRGB(red, green, blue);
        this.content.append(" RG").append_i(this.separator);
    }

    public void resetRGBColorStroke() {
        this.resetGrayStroke();
    }

    private void HelperCMYK(float cyan, float magenta, float yellow, float black) {
        if (cyan < 0.0f) {
            cyan = 0.0f;
        } else if (cyan > 1.0f) {
            cyan = 1.0f;
        }
        if (magenta < 0.0f) {
            magenta = 0.0f;
        } else if (magenta > 1.0f) {
            magenta = 1.0f;
        }
        if (yellow < 0.0f) {
            yellow = 0.0f;
        } else if (yellow > 1.0f) {
            yellow = 1.0f;
        }
        if (black < 0.0f) {
            black = 0.0f;
        } else if (black > 1.0f) {
            black = 1.0f;
        }
        this.content.append(cyan).append(' ').append(magenta).append(' ').append(yellow).append(' ').append(black);
    }

    public void setCMYKColorFillF(float cyan, float magenta, float yellow, float black) {
        this.saveColor(new CMYKColor(cyan, magenta, yellow, black), true);
        this.HelperCMYK(cyan, magenta, yellow, black);
        this.content.append(" k").append_i(this.separator);
    }

    public void resetCMYKColorFill() {
        this.saveColor(new CMYKColor(0, 0, 0, 1), true);
        this.content.append("0 0 0 1 k").append_i(this.separator);
    }

    public void setCMYKColorStrokeF(float cyan, float magenta, float yellow, float black) {
        this.saveColor(new CMYKColor(cyan, magenta, yellow, black), false);
        this.HelperCMYK(cyan, magenta, yellow, black);
        this.content.append(" K").append_i(this.separator);
    }

    public void resetCMYKColorStroke() {
        this.saveColor(new CMYKColor(0, 0, 0, 1), false);
        this.content.append("0 0 0 1 K").append_i(this.separator);
    }

    public void moveTo(float x, float y) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x).append(' ').append(y).append(" m").append_i(this.separator);
    }

    public void lineTo(float x, float y) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x).append(' ').append(y).append(" l").append_i(this.separator);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x1).append(' ').append(y1).append(' ').append(x2).append(' ').append(y2).append(' ').append(x3).append(' ').append(y3).append(" c").append_i(this.separator);
    }

    public void curveTo(float x2, float y2, float x3, float y3) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x2).append(' ').append(y2).append(' ').append(x3).append(' ').append(y3).append(" v").append_i(this.separator);
    }

    public void curveFromTo(float x1, float y1, float x3, float y3) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x1).append(' ').append(y1).append(' ').append(x3).append(' ').append(y3).append(" y").append_i(this.separator);
    }

    public void circle(float x, float y, float r) {
        float b = 0.5523f;
        this.moveTo(x + r, y);
        this.curveTo(x + r, y + r * b, x + r * b, y + r, x, y + r);
        this.curveTo(x - r * b, y + r, x - r, y + r * b, x - r, y);
        this.curveTo(x - r, y - r * b, x - r * b, y - r, x, y - r);
        this.curveTo(x + r * b, y - r, x + r, y - r * b, x + r, y);
    }

    public void rectangle(float x, float y, float w, float h) {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append(x).append(' ').append(y).append(' ').append(w).append(' ').append(h).append(" re").append_i(this.separator);
    }

    private boolean compareColors(BaseColor c1, BaseColor c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1 instanceof ExtendedColor) {
            return c1.equals(c2);
        }
        return c2.equals(c1);
    }

    public void variableRectangle(Rectangle rect) {
        boolean bb;
        boolean bt;
        float t = rect.getTop();
        float b = rect.getBottom();
        float r = rect.getRight();
        float l = rect.getLeft();
        float wt = rect.getBorderWidthTop();
        float wb = rect.getBorderWidthBottom();
        float wr = rect.getBorderWidthRight();
        float wl = rect.getBorderWidthLeft();
        BaseColor ct = rect.getBorderColorTop();
        BaseColor cb = rect.getBorderColorBottom();
        BaseColor cr = rect.getBorderColorRight();
        BaseColor cl = rect.getBorderColorLeft();
        this.saveState();
        this.setLineCap(0);
        this.setLineJoin(0);
        float clw = 0.0f;
        boolean cdef = false;
        BaseColor ccol = null;
        boolean cdefi = false;
        BaseColor cfil = null;
        if (wt > 0.0f) {
            clw = wt;
            this.setLineWidth(clw);
            cdef = true;
            if (ct == null) {
                this.resetRGBColorStroke();
            } else {
                this.setColorStroke(ct);
            }
            ccol = ct;
            this.moveTo(l, t - wt / 2.0f);
            this.lineTo(r, t - wt / 2.0f);
            this.stroke();
        }
        if (wb > 0.0f) {
            if (wb != clw) {
                clw = wb;
                this.setLineWidth(clw);
            }
            if (!cdef || !this.compareColors(ccol, cb)) {
                cdef = true;
                if (cb == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke(cb);
                }
                ccol = cb;
            }
            this.moveTo(r, b + wb / 2.0f);
            this.lineTo(l, b + wb / 2.0f);
            this.stroke();
        }
        if (wr > 0.0f) {
            if (wr != clw) {
                clw = wr;
                this.setLineWidth(clw);
            }
            if (!cdef || !this.compareColors(ccol, cr)) {
                cdef = true;
                if (cr == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke(cr);
                }
                ccol = cr;
            }
            bt = this.compareColors(ct, cr);
            bb = this.compareColors(cb, cr);
            this.moveTo(r - wr / 2.0f, bt ? t : t - wt);
            this.lineTo(r - wr / 2.0f, bb ? b : b + wb);
            this.stroke();
            if (!bt || !bb) {
                cdefi = true;
                if (cr == null) {
                    this.resetRGBColorFill();
                } else {
                    this.setColorFill(cr);
                }
                cfil = cr;
                if (!bt) {
                    this.moveTo(r, t);
                    this.lineTo(r, t - wt);
                    this.lineTo(r - wr, t - wt);
                    this.fill();
                }
                if (!bb) {
                    this.moveTo(r, b);
                    this.lineTo(r, b + wb);
                    this.lineTo(r - wr, b + wb);
                    this.fill();
                }
            }
        }
        if (wl > 0.0f) {
            if (wl != clw) {
                this.setLineWidth(wl);
            }
            if (!cdef || !this.compareColors(ccol, cl)) {
                if (cl == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke(cl);
                }
            }
            bt = this.compareColors(ct, cl);
            bb = this.compareColors(cb, cl);
            this.moveTo(l + wl / 2.0f, bt ? t : t - wt);
            this.lineTo(l + wl / 2.0f, bb ? b : b + wb);
            this.stroke();
            if (!bt || !bb) {
                if (!cdefi || !this.compareColors(cfil, cl)) {
                    if (cl == null) {
                        this.resetRGBColorFill();
                    } else {
                        this.setColorFill(cl);
                    }
                }
                if (!bt) {
                    this.moveTo(l, t);
                    this.lineTo(l, t - wt);
                    this.lineTo(l + wl, t - wt);
                    this.fill();
                }
                if (!bb) {
                    this.moveTo(l, b);
                    this.lineTo(l, b + wb);
                    this.lineTo(l + wl, b + wb);
                    this.fill();
                }
            }
        }
        this.restoreState();
    }

    public void rectangle(Rectangle rectangle) {
        float x1 = rectangle.getLeft();
        float y1 = rectangle.getBottom();
        float x2 = rectangle.getRight();
        float y2 = rectangle.getTop();
        BaseColor background = rectangle.getBackgroundColor();
        if (background != null) {
            this.saveState();
            this.setColorFill(background);
            this.rectangle(x1, y1, x2 - x1, y2 - y1);
            this.fill();
            this.restoreState();
        }
        if (!rectangle.hasBorders()) {
            return;
        }
        if (rectangle.isUseVariableBorders()) {
            this.variableRectangle(rectangle);
        } else {
            BaseColor color;
            if (rectangle.getBorderWidth() != -1.0f) {
                this.setLineWidth(rectangle.getBorderWidth());
            }
            if ((color = rectangle.getBorderColor()) != null) {
                this.setColorStroke(color);
            }
            if (rectangle.hasBorder(15)) {
                this.rectangle(x1, y1, x2 - x1, y2 - y1);
            } else {
                if (rectangle.hasBorder(8)) {
                    this.moveTo(x2, y1);
                    this.lineTo(x2, y2);
                }
                if (rectangle.hasBorder(4)) {
                    this.moveTo(x1, y1);
                    this.lineTo(x1, y2);
                }
                if (rectangle.hasBorder(2)) {
                    this.moveTo(x1, y1);
                    this.lineTo(x2, y1);
                }
                if (rectangle.hasBorder(1)) {
                    this.moveTo(x1, y2);
                    this.lineTo(x2, y2);
                }
            }
            this.stroke();
            if (color != null) {
                this.resetRGBColorStroke();
            }
        }
    }

    public void closePath() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append("h").append_i(this.separator);
    }

    public void newPath() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        this.content.append("n").append_i(this.separator);
    }

    public void stroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("S").append_i(this.separator);
    }

    public void closePathStroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("s").append_i(this.separator);
    }

    public void fill() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("f").append_i(this.separator);
    }

    public void eoFill() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("f*").append_i(this.separator);
    }

    public void fillStroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("B").append_i(this.separator);
    }

    public void closePathFillStroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("b").append_i(this.separator);
    }

    public void eoFillStroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("B*").append_i(this.separator);
    }

    public void closePathEoFillStroke() {
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("path.construction.operator.inside.text.object", new Object[0]));
            }
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorFill);
        PdfWriter.checkPdfIsoConformance(this.writer, 1, this.state.colorStroke);
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
        this.content.append("b*").append_i(this.separator);
    }

    public void addImage(Image image) throws DocumentException {
        this.addImage(image, false);
    }

    public void addImage(Image image, boolean inlineImage) throws DocumentException {
        if (!image.hasAbsoluteY()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.image.must.have.absolute.positioning", new Object[0]));
        }
        float[] matrix = image.matrix();
        matrix[4] = image.getAbsoluteX() - matrix[4];
        matrix[5] = image.getAbsoluteY() - matrix[5];
        this.addImage(image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], inlineImage);
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        this.addImage(image, a, b, c, d, e, f, false);
    }

    public void addImage(Image image, cfca.com.itextpdf.awt.geom.AffineTransform transform) throws DocumentException {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.addImage(image, (float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5], false);
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f, boolean inlineImage) throws DocumentException {
        try {
            Annotation annot;
            if (image.getLayer() != null) {
                this.beginLayer(image.getLayer());
            }
            if (this.isTagged()) {
                if (this.inText) {
                    this.endText();
                }
                cfca.com.itextpdf.awt.geom.AffineTransform transform = new cfca.com.itextpdf.awt.geom.AffineTransform(a, b, c, d, e, f);
                Point2D[] src = new Point2D.Float[]{new Point2D.Float(0.0f, 0.0f), new Point2D.Float(1.0f, 0.0f), new Point2D.Float(1.0f, 1.0f), new Point2D.Float(0.0f, 1.0f)};
                Point2D[] dst = new Point2D.Float[4];
                transform.transform(src, 0, dst, 0, 4);
                float left = Float.MAX_VALUE;
                float right = -3.4028235E38f;
                float bottom = Float.MAX_VALUE;
                float top = -3.4028235E38f;
                for (int i = 0; i < 4; ++i) {
                    if (dst[i].getX() < (double)left) {
                        left = (float)dst[i].getX();
                    }
                    if (dst[i].getX() > (double)right) {
                        right = (float)dst[i].getX();
                    }
                    if (dst[i].getY() < (double)bottom) {
                        bottom = (float)dst[i].getY();
                    }
                    if (!(dst[i].getY() > (double)top)) continue;
                    top = (float)dst[i].getY();
                }
                image.setAccessibleAttribute(PdfName.BBOX, new PdfArray(new float[]{left, bottom, right, top}));
            }
            if (this.writer != null && image.isImgTemplate()) {
                this.writer.addDirectImageSimple(image);
                PdfTemplate template = image.getTemplateData();
                float w = template.getWidth();
                float h = template.getHeight();
                this.addTemplate(template, a / w, b / w, c / h, d / h, e, f);
            } else {
                this.content.append("q ");
                this.content.append(a).append(' ');
                this.content.append(b).append(' ');
                this.content.append(c).append(' ');
                this.content.append(d).append(' ');
                this.content.append(e).append(' ');
                this.content.append(f).append(" cm");
                if (inlineImage) {
                    byte[] globals;
                    this.content.append("\nBI\n");
                    PdfImage pimage = new PdfImage(image, "", null);
                    if (image instanceof ImgJBIG2 && (globals = ((ImgJBIG2)image).getGlobalBytes()) != null) {
                        PdfDictionary decodeparms = new PdfDictionary();
                        decodeparms.put(PdfName.JBIG2GLOBALS, this.writer.getReferenceJBIG2Globals(globals));
                        pimage.put(PdfName.DECODEPARMS, decodeparms);
                    }
                    PdfWriter.checkPdfIsoConformance(this.writer, 17, pimage);
                    Iterator<PdfName> i$ = pimage.getKeys().iterator();
                    while (i$.hasNext()) {
                        PdfArray ar;
                        PdfName element;
                        PdfName key = element = i$.next();
                        PdfObject value = pimage.get(key);
                        String s = abrev.get(key);
                        if (s == null) continue;
                        this.content.append(s);
                        boolean check = true;
                        if (key.equals(PdfName.COLORSPACE) && value.isArray() && (ar = (PdfArray)value).size() == 4 && PdfName.INDEXED.equals(ar.getAsName(0)) && ar.getPdfObject(1).isName() && ar.getPdfObject(2).isNumber() && ar.getPdfObject(3).isString()) {
                            check = false;
                        }
                        if (check && key.equals(PdfName.COLORSPACE) && !value.isName()) {
                            PdfName cs = this.writer.getColorspaceName();
                            PageResources prs = this.getPageResources();
                            prs.addColor(cs, this.writer.addToBody(value).getIndirectReference());
                            value = cs;
                        }
                        value.toPdf(null, this.content);
                        this.content.append('\n');
                    }
                    this.content.append("ID\n");
                    pimage.writeContent(this.content);
                    this.content.append("\nEI\nQ").append_i(this.separator);
                } else {
                    PdfName name;
                    PageResources prs = this.getPageResources();
                    Image maskImage = image.getImageMask();
                    if (maskImage != null) {
                        name = this.writer.addDirectImageSimple(maskImage);
                        prs.addXObject(name, this.writer.getImageReference(name));
                    }
                    name = this.writer.addDirectImageSimple(image);
                    name = prs.addXObject(name, this.writer.getImageReference(name));
                    this.content.append(' ').append(name.getBytes()).append(" Do Q").append_i(this.separator);
                }
            }
            if (image.hasBorders()) {
                this.saveState();
                float w = image.getWidth();
                float h = image.getHeight();
                this.concatCTM(a / w, b / w, c / h, d / h, e, f);
                this.rectangle(image);
                this.restoreState();
            }
            if (image.getLayer() != null) {
                this.endLayer();
            }
            if ((annot = image.getAnnotation()) == null) {
                return;
            }
            float[] r = new float[unitRect.length];
            for (int k = 0; k < unitRect.length; k += 2) {
                r[k] = a * unitRect[k] + c * unitRect[k + 1] + e;
                r[k + 1] = b * unitRect[k] + d * unitRect[k + 1] + f;
            }
            float llx = r[0];
            float lly = r[1];
            float urx = llx;
            float ury = lly;
            for (int k = 2; k < r.length; k += 2) {
                llx = Math.min(llx, r[k]);
                lly = Math.min(lly, r[k + 1]);
                urx = Math.max(urx, r[k]);
                ury = Math.max(ury, r[k + 1]);
            }
            annot = new Annotation(annot);
            annot.setDimensions(llx, lly, urx, ury);
            PdfAnnotation an = PdfAnnotationsImp.convertAnnotation(this.writer, annot, new Rectangle(llx, lly, urx, ury));
            if (an == null) {
                return;
            }
            this.addAnnotation(an);
        }
        catch (Exception ee) {
            throw new DocumentException(ee);
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean validateContent) {
        this.content.reset();
        this.markedContentSize = 0;
        if (validateContent) {
            this.sanityCheck();
        }
        this.state = new GraphicState();
        this.stateList = new ArrayList();
    }

    protected void beginText(boolean restoreTM) {
        if (this.inText) {
            if (!this.isTagged()) {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators", new Object[0]));
            }
        } else {
            this.inText = true;
            this.content.append("BT").append_i(this.separator);
            if (restoreTM) {
                float xTLM = this.state.xTLM;
                float tx = this.state.tx;
                this.setTextMatrix(this.state.aTLM, this.state.bTLM, this.state.cTLM, this.state.dTLM, this.state.tx, this.state.yTLM);
                this.state.xTLM = xTLM;
                this.state.tx = tx;
            } else {
                this.state.xTLM = 0.0f;
                this.state.yTLM = 0.0f;
                this.state.tx = 0.0f;
            }
            if (this.isTagged()) {
                try {
                    this.restoreColor();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void beginText() {
        this.beginText(false);
    }

    public void endText() {
        if (!this.inText) {
            if (!this.isTagged()) {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators", new Object[0]));
            }
        } else {
            this.inText = false;
            this.content.append("ET").append_i(this.separator);
            if (this.isTagged()) {
                try {
                    this.restoreColor();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void saveState() {
        PdfWriter.checkPdfIsoConformance(this.writer, 12, "q");
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.content.append("q").append_i(this.separator);
        this.stateList.add(new GraphicState(this.state));
    }

    public void restoreState() {
        PdfWriter.checkPdfIsoConformance(this.writer, 12, "Q");
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.content.append("Q").append_i(this.separator);
        int idx = this.stateList.size() - 1;
        if (idx < 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.save.restore.state.operators", new Object[0]));
        }
        this.state.restore(this.stateList.get(idx));
        this.stateList.remove(idx);
    }

    public void setCharacterSpacing(float charSpace) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.charSpace = charSpace;
        this.content.append(charSpace).append(" Tc").append_i(this.separator);
    }

    public void setWordSpacing(float wordSpace) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.wordSpace = wordSpace;
        this.content.append(wordSpace).append(" Tw").append_i(this.separator);
    }

    public void setHorizontalScaling(float scale) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.scale = scale;
        this.content.append(scale).append(" Tz").append_i(this.separator);
    }

    public void setLeading(float leading) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.leading = leading;
        this.content.append(leading).append(" TL").append_i(this.separator);
    }

    public void setFontAndSize(BaseFont bf, float size) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.checkWriter();
        if (size < 1.0E-4f && size > -1.0E-4f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("font.size.too.small.1", String.valueOf(size)));
        }
        this.state.size = size;
        this.state.fontDetails = this.writer.addSimple(bf);
        PageResources prs = this.getPageResources();
        PdfName name = this.state.fontDetails.getFontName();
        name = prs.addFont(name, this.state.fontDetails.getIndirectReference());
        this.content.append(name.getBytes()).append(' ').append(size).append(" Tf").append_i(this.separator);
    }

    public void setTextRenderingMode(int rendering) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.textRenderMode = rendering;
        this.content.append(rendering).append(" Tr").append_i(this.separator);
    }

    public void setTextRise(float rise) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.content.append(rise).append(" Ts").append_i(this.separator);
    }

    private void showText2(String text) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text", new Object[0]));
        }
        byte[] b = this.state.fontDetails.convertToBytes(text);
        PdfContentByte.escapeString(b, this.content);
    }

    public void showText(String text) {
        this.checkState();
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.showText2(text);
        this.updateTx(text, 0.0f);
        this.content.append("Tj").append_i(this.separator);
    }

    public static PdfTextArray getKernArray(String text, BaseFont font) {
        PdfTextArray pa = new PdfTextArray();
        StringBuffer acc = new StringBuffer();
        int len = text.length() - 1;
        char[] c = text.toCharArray();
        if (len >= 0) {
            acc.append(c, 0, 1);
        }
        for (int k = 0; k < len; ++k) {
            char c2 = c[k + 1];
            int kern = font.getKerning(c[k], c2);
            if (kern == 0) {
                acc.append(c2);
                continue;
            }
            pa.add(acc.toString());
            acc.setLength(0);
            acc.append(c, k + 1, 1);
            pa.add(-kern);
        }
        pa.add(acc.toString());
        return pa;
    }

    public void showTextKerned(String text) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text", new Object[0]));
        }
        BaseFont bf = this.state.fontDetails.getBaseFont();
        if (bf.hasKernPairs()) {
            this.showText(PdfContentByte.getKernArray(text, bf));
        } else {
            this.showText(text);
        }
    }

    public void newlineShowText(String text) {
        this.checkState();
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.yTLM -= this.state.leading;
        this.showText2(text);
        this.content.append("'").append_i(this.separator);
        this.state.tx = this.state.xTLM;
        this.updateTx(text, 0.0f);
    }

    public void newlineShowText(float wordSpacing, float charSpacing, String text) {
        this.checkState();
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.yTLM -= this.state.leading;
        this.content.append(wordSpacing).append(' ').append(charSpacing);
        this.showText2(text);
        this.content.append("\"").append_i(this.separator);
        this.state.charSpace = charSpacing;
        this.state.wordSpace = wordSpacing;
        this.state.tx = this.state.xTLM;
        this.updateTx(text, 0.0f);
    }

    public void setTextMatrix(float a, float b, float c, float d, float x, float y) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.xTLM = x;
        this.state.yTLM = y;
        this.state.aTLM = a;
        this.state.bTLM = b;
        this.state.cTLM = c;
        this.state.dTLM = d;
        this.state.tx = this.state.xTLM;
        this.content.append(a).append(' ').append(b).append_i(32).append(c).append_i(32).append(d).append_i(32).append(x).append_i(32).append(y).append(" Tm").append_i(this.separator);
    }

    public void setTextMatrix(cfca.com.itextpdf.awt.geom.AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.setTextMatrix((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
    }

    public void setTextMatrix(float x, float y) {
        this.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public void moveText(float x, float y) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.xTLM += x;
        this.state.yTLM += y;
        if (this.isTagged() && this.state.xTLM != this.state.tx) {
            this.setTextMatrix(this.state.aTLM, this.state.bTLM, this.state.cTLM, this.state.dTLM, this.state.xTLM, this.state.yTLM);
        } else {
            this.content.append(x).append(' ').append(y).append(" Td").append_i(this.separator);
        }
    }

    public void moveTextWithLeading(float x, float y) {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        this.state.xTLM += x;
        this.state.yTLM += y;
        this.state.leading = -y;
        if (this.isTagged() && this.state.xTLM != this.state.tx) {
            this.setTextMatrix(this.state.aTLM, this.state.bTLM, this.state.cTLM, this.state.dTLM, this.state.xTLM, this.state.yTLM);
        } else {
            this.content.append(x).append(' ').append(y).append(" TD").append_i(this.separator);
        }
    }

    public void newlineText() {
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        if (this.isTagged() && this.state.xTLM != this.state.tx) {
            this.setTextMatrix(this.state.aTLM, this.state.bTLM, this.state.cTLM, this.state.dTLM, this.state.xTLM, this.state.yTLM);
        }
        this.state.yTLM -= this.state.leading;
        this.content.append("T*").append_i(this.separator);
    }

    int size() {
        return this.size(true);
    }

    int size(boolean includeMarkedContentSize) {
        if (includeMarkedContentSize) {
            return this.content.size();
        }
        return this.content.size() - this.markedContentSize;
    }

    static byte[] escapeString(byte[] b) {
        ByteBuffer content = new ByteBuffer();
        PdfContentByte.escapeString(b, content);
        return content.toByteArray();
    }

    static void escapeString(byte[] b, ByteBuffer content) {
        content.append_i(40);
        block8: for (int k = 0; k < b.length; ++k) {
            byte c = b[k];
            switch (c) {
                case 13: {
                    content.append("\\r");
                    continue block8;
                }
                case 10: {
                    content.append("\\n");
                    continue block8;
                }
                case 9: {
                    content.append("\\t");
                    continue block8;
                }
                case 8: {
                    content.append("\\b");
                    continue block8;
                }
                case 12: {
                    content.append("\\f");
                    continue block8;
                }
                case 40: 
                case 41: 
                case 92: {
                    content.append_i(92).append_i(c);
                    continue block8;
                }
                default: {
                    content.append_i(c);
                }
            }
        }
        content.append(")");
    }

    public void addOutline(PdfOutline outline, String name) {
        this.checkWriter();
        this.pdf.addOutline(outline, name);
    }

    public PdfOutline getRootOutline() {
        this.checkWriter();
        return this.pdf.getRootOutline();
    }

    public float getEffectiveStringWidth(String text, boolean kerned) {
        BaseFont bf = this.state.fontDetails.getBaseFont();
        float w = kerned ? bf.getWidthPointKerned(text, this.state.size) : bf.getWidthPoint(text, this.state.size);
        if (this.state.charSpace != 0.0f && text.length() > 1) {
            w += this.state.charSpace * (float)(text.length() - 1);
        }
        if (this.state.wordSpace != 0.0f && !bf.isVertical()) {
            for (int i = 0; i < text.length() - 1; ++i) {
                if (text.charAt(i) != ' ') continue;
                w += this.state.wordSpace;
            }
        }
        if ((double)this.state.scale != 100.0) {
            w = w * this.state.scale / 100.0f;
        }
        return w;
    }

    private float getEffectiveStringWidth(String text, boolean kerned, float kerning) {
        BaseFont bf = this.state.fontDetails.getBaseFont();
        float w = kerned ? bf.getWidthPointKerned(text, this.state.size) : bf.getWidthPoint(text, this.state.size);
        if (this.state.charSpace != 0.0f && text.length() > 0) {
            w += this.state.charSpace * (float)text.length();
        }
        if (this.state.wordSpace != 0.0f && !bf.isVertical()) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != ' ') continue;
                w += this.state.wordSpace;
            }
        }
        w -= kerning / 1000.0f * this.state.size;
        if ((double)this.state.scale != 100.0) {
            w = w * this.state.scale / 100.0f;
        }
        return w;
    }

    public void showTextAligned(int alignment, String text, float x, float y, float rotation) {
        this.showTextAligned(alignment, text, x, y, rotation, false);
    }

    private void showTextAligned(int alignment, String text, float x, float y, float rotation, boolean kerned) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text", new Object[0]));
        }
        if (rotation == 0.0f) {
            switch (alignment) {
                case 1: {
                    x -= this.getEffectiveStringWidth(text, kerned) / 2.0f;
                    break;
                }
                case 2: {
                    x -= this.getEffectiveStringWidth(text, kerned);
                }
            }
            this.setTextMatrix(x, y);
            if (kerned) {
                this.showTextKerned(text);
            } else {
                this.showText(text);
            }
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            switch (alignment) {
                case 1: {
                    float len = this.getEffectiveStringWidth(text, kerned) / 2.0f;
                    x -= len * cos;
                    y -= len * sin;
                    break;
                }
                case 2: {
                    float len = this.getEffectiveStringWidth(text, kerned);
                    x -= len * cos;
                    y -= len * sin;
                }
            }
            this.setTextMatrix(cos, sin, -sin, cos, x, y);
            if (kerned) {
                this.showTextKerned(text);
            } else {
                this.showText(text);
            }
            this.setTextMatrix(0.0f, 0.0f);
        }
    }

    public void showTextAlignedKerned(int alignment, String text, float x, float y, float rotation) {
        this.showTextAligned(alignment, text, x, y, rotation, true);
    }

    public void concatCTM(float a, float b, float c, float d, float e, float f) {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.state.CTM.concatenate(new cfca.com.itextpdf.awt.geom.AffineTransform(a, b, c, d, e, f));
        this.content.append(a).append(' ').append(b).append(' ').append(c).append(' ');
        this.content.append(d).append(' ').append(e).append(' ').append(f).append(" cm").append_i(this.separator);
    }

    public void concatCTM(cfca.com.itextpdf.awt.geom.AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.concatCTM((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
    }

    public static ArrayList<float[]> bezierArc(float x1, float y1, float x2, float y2, float startAng, float extent) {
        int Nfrag;
        float fragAngle;
        float tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y1) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (Math.abs(extent) <= 90.0f) {
            fragAngle = extent;
            Nfrag = 1;
        } else {
            Nfrag = (int)Math.ceil(Math.abs(extent) / 90.0f);
            fragAngle = extent / (float)Nfrag;
        }
        float x_cen = (x1 + x2) / 2.0f;
        float y_cen = (y1 + y2) / 2.0f;
        float rx = (x2 - x1) / 2.0f;
        float ry = (y2 - y1) / 2.0f;
        float halfAng = (float)((double)fragAngle * Math.PI / 360.0);
        float kappa = (float)Math.abs(1.3333333333333333 * (1.0 - Math.cos(halfAng)) / Math.sin(halfAng));
        ArrayList<float[]> pointList = new ArrayList<float[]>();
        for (int i = 0; i < Nfrag; ++i) {
            float theta0 = (float)((double)(startAng + (float)i * fragAngle) * Math.PI / 180.0);
            float theta1 = (float)((double)(startAng + (float)(i + 1) * fragAngle) * Math.PI / 180.0);
            float cos0 = (float)Math.cos(theta0);
            float cos1 = (float)Math.cos(theta1);
            float sin0 = (float)Math.sin(theta0);
            float sin1 = (float)Math.sin(theta1);
            if (fragAngle > 0.0f) {
                pointList.add(new float[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 - kappa * sin0), y_cen - ry * (sin0 + kappa * cos0), x_cen + rx * (cos1 + kappa * sin1), y_cen - ry * (sin1 - kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
                continue;
            }
            pointList.add(new float[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 + kappa * sin0), y_cen - ry * (sin0 - kappa * cos0), x_cen + rx * (cos1 - kappa * sin1), y_cen - ry * (sin1 + kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
        }
        return pointList;
    }

    public void arc(float x1, float y1, float x2, float y2, float startAng, float extent) {
        ArrayList<float[]> ar = PdfContentByte.bezierArc(x1, y1, x2, y2, startAng, extent);
        if (ar.isEmpty()) {
            return;
        }
        float[] pt = ar.get(0);
        this.moveTo(pt[0], pt[1]);
        for (int k = 0; k < ar.size(); ++k) {
            pt = ar.get(k);
            this.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
        }
    }

    public void ellipse(float x1, float y1, float x2, float y2) {
        this.arc(x1, y1, x2, y2, 0.0f, 360.0f);
    }

    public PdfPatternPainter createPattern(float width, float height, float xstep, float ystep) {
        this.checkWriter();
        if (xstep == 0.0f || ystep == 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("xstep.or.ystep.can.not.be.zero", new Object[0]));
        }
        PdfPatternPainter painter = new PdfPatternPainter(this.writer);
        painter.setWidth(width);
        painter.setHeight(height);
        painter.setXStep(xstep);
        painter.setYStep(ystep);
        this.writer.addSimplePattern(painter);
        return painter;
    }

    public PdfPatternPainter createPattern(float width, float height) {
        return this.createPattern(width, height, width, height);
    }

    public PdfPatternPainter createPattern(float width, float height, float xstep, float ystep, BaseColor color) {
        this.checkWriter();
        if (xstep == 0.0f || ystep == 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("xstep.or.ystep.can.not.be.zero", new Object[0]));
        }
        PdfPatternPainter painter = new PdfPatternPainter(this.writer, color);
        painter.setWidth(width);
        painter.setHeight(height);
        painter.setXStep(xstep);
        painter.setYStep(ystep);
        this.writer.addSimplePattern(painter);
        return painter;
    }

    public PdfPatternPainter createPattern(float width, float height, BaseColor color) {
        return this.createPattern(width, height, width, height, color);
    }

    public PdfTemplate createTemplate(float width, float height) {
        return this.createTemplate(width, height, null);
    }

    PdfTemplate createTemplate(float width, float height, PdfName forcedName) {
        this.checkWriter();
        PdfTemplate template = new PdfTemplate(this.writer);
        template.setWidth(width);
        template.setHeight(height);
        this.writer.addDirectTemplateSimple(template, forcedName);
        return template;
    }

    public PdfAppearance createAppearance(float width, float height) {
        return this.createAppearance(width, height, null);
    }

    PdfAppearance createAppearance(float width, float height, PdfName forcedName) {
        this.checkWriter();
        PdfAppearance template = new PdfAppearance(this.writer);
        template.setWidth(width);
        template.setHeight(height);
        this.writer.addDirectTemplateSimple(template, forcedName);
        return template;
    }

    public void addPSXObject(PdfPSXObject psobject) {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.checkWriter();
        PdfName name = this.writer.addDirectTemplateSimple(psobject, null);
        PageResources prs = this.getPageResources();
        name = prs.addXObject(name, psobject.getIndirectReference());
        this.content.append(name.getBytes()).append(" Do").append_i(this.separator);
    }

    public void addTemplate(PdfTemplate template, float a, float b, float c, float d, float e, float f) {
        this.addTemplate(template, a, b, c, d, e, f, false);
    }

    public void addTemplate(PdfTemplate template, float a, float b, float c, float d, float e, float f, boolean tagContent) {
        this.checkWriter();
        this.checkNoPattern(template);
        PdfWriter.checkPdfIsoConformance(this.writer, 20, template);
        PdfName name = this.writer.addDirectTemplateSimple(template, null);
        PageResources prs = this.getPageResources();
        name = prs.addXObject(name, template.getIndirectReference());
        if (this.isTagged()) {
            if (this.inText) {
                this.endText();
            }
            if (template.isContentTagged() || template.getPageReference() != null && tagContent) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("template.with.tagged.could.not.be.used.more.than.once", new Object[0]));
            }
            template.setPageReference(this.writer.getCurrentPage());
            if (tagContent) {
                template.setContentTagged(true);
                ArrayList<IAccessibleElement> allMcElements = this.getMcElements();
                if (allMcElements != null && allMcElements.size() > 0) {
                    template.getMcElements().add(allMcElements.get(allMcElements.size() - 1));
                }
            } else {
                this.openMCBlock(template);
            }
        }
        this.content.append("q ");
        this.content.append(a).append(' ');
        this.content.append(b).append(' ');
        this.content.append(c).append(' ');
        this.content.append(d).append(' ');
        this.content.append(e).append(' ');
        this.content.append(f).append(" cm ");
        this.content.append(name.getBytes()).append(" Do Q").append_i(this.separator);
        if (this.isTagged() && !tagContent) {
            this.closeMCBlock(template);
            template.setId(null);
        }
    }

    public void addTemplate(PdfTemplate template, cfca.com.itextpdf.awt.geom.AffineTransform transform) {
        this.addTemplate(template, transform, false);
    }

    public void addTemplate(PdfTemplate template, cfca.com.itextpdf.awt.geom.AffineTransform transform, boolean tagContent) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.addTemplate(template, (float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5], tagContent);
    }

    void addTemplateReference(PdfIndirectReference template, PdfName name, float a, float b, float c, float d, float e, float f) {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        this.checkWriter();
        PageResources prs = this.getPageResources();
        name = prs.addXObject(name, template);
        this.content.append("q ");
        this.content.append(a).append(' ');
        this.content.append(b).append(' ');
        this.content.append(c).append(' ');
        this.content.append(d).append(' ');
        this.content.append(e).append(' ');
        this.content.append(f).append(" cm ");
        this.content.append(name.getBytes()).append(" Do Q").append_i(this.separator);
    }

    public void addTemplate(PdfTemplate template, float x, float y) {
        this.addTemplate(template, 1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public void addTemplate(PdfTemplate template, float x, float y, boolean tagContent) {
        this.addTemplate(template, 1.0f, 0.0f, 0.0f, 1.0f, x, y, tagContent);
    }

    public void setCMYKColorFill(int cyan, int magenta, int yellow, int black) {
        this.saveColor(new CMYKColor(cyan, magenta, yellow, black), true);
        this.content.append((float)(cyan & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(magenta & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(yellow & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(black & 0xFF) / 255.0f);
        this.content.append(" k").append_i(this.separator);
    }

    public void setCMYKColorStroke(int cyan, int magenta, int yellow, int black) {
        this.saveColor(new CMYKColor(cyan, magenta, yellow, black), false);
        this.content.append((float)(cyan & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(magenta & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(yellow & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(black & 0xFF) / 255.0f);
        this.content.append(" K").append_i(this.separator);
    }

    public void setRGBColorFill(int red, int green, int blue) {
        this.saveColor(new BaseColor(red, green, blue), true);
        this.HelperRGB((float)(red & 0xFF) / 255.0f, (float)(green & 0xFF) / 255.0f, (float)(blue & 0xFF) / 255.0f);
        this.content.append(" rg").append_i(this.separator);
    }

    public void setRGBColorStroke(int red, int green, int blue) {
        this.saveColor(new BaseColor(red, green, blue), false);
        this.HelperRGB((float)(red & 0xFF) / 255.0f, (float)(green & 0xFF) / 255.0f, (float)(blue & 0xFF) / 255.0f);
        this.content.append(" RG").append_i(this.separator);
    }

    public void setColorStroke(BaseColor color) {
        int type = ExtendedColor.getType(color);
        switch (type) {
            case 1: {
                this.setGrayStroke(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cmyk = (CMYKColor)color;
                this.setCMYKColorStrokeF(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
                break;
            }
            case 3: {
                SpotColor spot = (SpotColor)color;
                this.setColorStroke(spot.getPdfSpotColor(), spot.getTint());
                break;
            }
            case 4: {
                PatternColor pat = (PatternColor)color;
                this.setPatternStroke(pat.getPainter());
                break;
            }
            case 5: {
                ShadingColor shading = (ShadingColor)color;
                this.setShadingStroke(shading.getPdfShadingPattern());
                break;
            }
            default: {
                this.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    public void setColorFill(BaseColor color) {
        int type = ExtendedColor.getType(color);
        switch (type) {
            case 1: {
                this.setGrayFill(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cmyk = (CMYKColor)color;
                this.setCMYKColorFillF(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
                break;
            }
            case 3: {
                SpotColor spot = (SpotColor)color;
                this.setColorFill(spot.getPdfSpotColor(), spot.getTint());
                break;
            }
            case 4: {
                PatternColor pat = (PatternColor)color;
                this.setPatternFill(pat.getPainter());
                break;
            }
            case 5: {
                ShadingColor shading = (ShadingColor)color;
                this.setShadingFill(shading.getPdfShadingPattern());
                break;
            }
            default: {
                this.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    public void setColorFill(PdfSpotColor sp, float tint) {
        this.checkWriter();
        this.state.colorDetails = this.writer.addSimple(sp);
        PageResources prs = this.getPageResources();
        PdfName name = this.state.colorDetails.getColorName();
        name = prs.addColor(name, this.state.colorDetails.getIndirectReference());
        this.saveColor(new SpotColor(sp, tint), true);
        this.content.append(name.getBytes()).append(" cs ").append(tint).append(" scn").append_i(this.separator);
    }

    public void setColorStroke(PdfSpotColor sp, float tint) {
        this.checkWriter();
        this.state.colorDetails = this.writer.addSimple(sp);
        PageResources prs = this.getPageResources();
        PdfName name = this.state.colorDetails.getColorName();
        name = prs.addColor(name, this.state.colorDetails.getIndirectReference());
        this.saveColor(new SpotColor(sp, tint), false);
        this.content.append(name.getBytes()).append(" CS ").append(tint).append(" SCN").append_i(this.separator);
    }

    public void setPatternFill(PdfPatternPainter p) {
        if (p.isStencil()) {
            this.setPatternFill(p, p.getDefaultColor());
            return;
        }
        this.checkWriter();
        PageResources prs = this.getPageResources();
        PdfName name = this.writer.addSimplePattern(p);
        name = prs.addPattern(name, p.getIndirectReference());
        this.saveColor(new PatternColor(p), true);
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(name.getBytes()).append(" scn").append_i(this.separator);
    }

    void outputColorNumbers(BaseColor color, float tint) {
        PdfWriter.checkPdfIsoConformance(this.writer, 1, color);
        int type = ExtendedColor.getType(color);
        switch (type) {
            case 0: {
                this.content.append((float)color.getRed() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getGreen() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getBlue() / 255.0f);
                break;
            }
            case 1: {
                this.content.append(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cmyk = (CMYKColor)color;
                this.content.append(cmyk.getCyan()).append(' ').append(cmyk.getMagenta());
                this.content.append(' ').append(cmyk.getYellow()).append(' ').append(cmyk.getBlack());
                break;
            }
            case 3: {
                this.content.append(tint);
                break;
            }
            default: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.color.type", new Object[0]));
            }
        }
    }

    public void setPatternFill(PdfPatternPainter p, BaseColor color) {
        if (ExtendedColor.getType(color) == 3) {
            this.setPatternFill(p, color, ((SpotColor)color).getTint());
        } else {
            this.setPatternFill(p, color, 0.0f);
        }
    }

    public void setPatternFill(PdfPatternPainter p, BaseColor color, float tint) {
        this.checkWriter();
        if (!p.isStencil()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("an.uncolored.pattern.was.expected", new Object[0]));
        }
        PageResources prs = this.getPageResources();
        PdfName name = this.writer.addSimplePattern(p);
        name = prs.addPattern(name, p.getIndirectReference());
        ColorDetails csDetail = this.writer.addSimplePatternColorspace(color);
        PdfName cName = prs.addColor(csDetail.getColorName(), csDetail.getIndirectReference());
        this.saveColor(new UncoloredPattern(p, color, tint), true);
        this.content.append(cName.getBytes()).append(" cs").append_i(this.separator);
        this.outputColorNumbers(color, tint);
        this.content.append(' ').append(name.getBytes()).append(" scn").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter p, BaseColor color) {
        if (ExtendedColor.getType(color) == 3) {
            this.setPatternStroke(p, color, ((SpotColor)color).getTint());
        } else {
            this.setPatternStroke(p, color, 0.0f);
        }
    }

    public void setPatternStroke(PdfPatternPainter p, BaseColor color, float tint) {
        this.checkWriter();
        if (!p.isStencil()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("an.uncolored.pattern.was.expected", new Object[0]));
        }
        PageResources prs = this.getPageResources();
        PdfName name = this.writer.addSimplePattern(p);
        name = prs.addPattern(name, p.getIndirectReference());
        ColorDetails csDetail = this.writer.addSimplePatternColorspace(color);
        PdfName cName = prs.addColor(csDetail.getColorName(), csDetail.getIndirectReference());
        this.saveColor(new UncoloredPattern(p, color, tint), false);
        this.content.append(cName.getBytes()).append(" CS").append_i(this.separator);
        this.outputColorNumbers(color, tint);
        this.content.append(' ').append(name.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter p) {
        if (p.isStencil()) {
            this.setPatternStroke(p, p.getDefaultColor());
            return;
        }
        this.checkWriter();
        PageResources prs = this.getPageResources();
        PdfName name = this.writer.addSimplePattern(p);
        name = prs.addPattern(name, p.getIndirectReference());
        this.saveColor(new PatternColor(p), false);
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(name.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void paintShading(PdfShading shading) {
        this.writer.addSimpleShading(shading);
        PageResources prs = this.getPageResources();
        PdfName name = prs.addShading(shading.getShadingName(), shading.getShadingReference());
        this.content.append(name.getBytes()).append(" sh").append_i(this.separator);
        ColorDetails details = shading.getColorDetails();
        if (details != null) {
            prs.addColor(details.getColorName(), details.getIndirectReference());
        }
    }

    public void paintShading(PdfShadingPattern shading) {
        this.paintShading(shading.getShading());
    }

    public void setShadingFill(PdfShadingPattern shading) {
        this.writer.addSimpleShadingPattern(shading);
        PageResources prs = this.getPageResources();
        PdfName name = prs.addPattern(shading.getPatternName(), shading.getPatternReference());
        this.saveColor(new ShadingColor(shading), true);
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(name.getBytes()).append(" scn").append_i(this.separator);
        ColorDetails details = shading.getColorDetails();
        if (details != null) {
            prs.addColor(details.getColorName(), details.getIndirectReference());
        }
    }

    public void setShadingStroke(PdfShadingPattern shading) {
        this.writer.addSimpleShadingPattern(shading);
        PageResources prs = this.getPageResources();
        PdfName name = prs.addPattern(shading.getPatternName(), shading.getPatternReference());
        this.saveColor(new ShadingColor(shading), false);
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(name.getBytes()).append(" SCN").append_i(this.separator);
        ColorDetails details = shading.getColorDetails();
        if (details != null) {
            prs.addColor(details.getColorName(), details.getIndirectReference());
        }
    }

    protected void checkWriter() {
        if (this.writer == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("the.writer.in.pdfcontentbyte.is.null", new Object[0]));
        }
    }

    public void showText(PdfTextArray text) {
        this.checkState();
        if (!this.inText && this.isTagged()) {
            this.beginText(true);
        }
        if (this.state.fontDetails == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text", new Object[0]));
        }
        this.content.append("[");
        ArrayList<Object> arrayList = text.getArrayList();
        boolean lastWasNumber = false;
        for (Object obj : arrayList) {
            if (obj instanceof String) {
                this.showText2((String)obj);
                this.updateTx((String)obj, 0.0f);
                lastWasNumber = false;
                continue;
            }
            if (lastWasNumber) {
                this.content.append(' ');
            } else {
                lastWasNumber = true;
            }
            this.content.append(((Float)obj).floatValue());
            this.updateTx("", ((Float)obj).floatValue());
        }
        this.content.append("]TJ").append_i(this.separator);
    }

    public PdfWriter getPdfWriter() {
        return this.writer;
    }

    public PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public void localGoto(String name, float llx, float lly, float urx, float ury) {
        this.pdf.localGoto(name, llx, lly, urx, ury);
    }

    public boolean localDestination(String name, PdfDestination destination) {
        return this.pdf.localDestination(name, destination);
    }

    public PdfContentByte getDuplicate() {
        PdfContentByte cb = new PdfContentByte(this.writer);
        cb.duplicatedFrom = this;
        return cb;
    }

    public PdfContentByte getDuplicate(boolean inheritGraphicState) {
        PdfContentByte cb = this.getDuplicate();
        if (inheritGraphicState) {
            cb.state = this.state;
            cb.stateList = this.stateList;
        }
        return cb;
    }

    public void remoteGoto(String filename, String name, float llx, float lly, float urx, float ury) {
        this.pdf.remoteGoto(filename, name, llx, lly, urx, ury);
    }

    public void remoteGoto(String filename, int page, float llx, float lly, float urx, float ury) {
        this.pdf.remoteGoto(filename, page, llx, lly, urx, ury);
    }

    public void roundRectangle(float x, float y, float w, float h, float r) {
        if (w < 0.0f) {
            x += w;
            w = -w;
        }
        if (h < 0.0f) {
            y += h;
            h = -h;
        }
        if (r < 0.0f) {
            r = -r;
        }
        float b = 0.4477f;
        this.moveTo(x + r, y);
        this.lineTo(x + w - r, y);
        this.curveTo(x + w - r * b, y, x + w, y + r * b, x + w, y + r);
        this.lineTo(x + w, y + h - r);
        this.curveTo(x + w, y + h - r * b, x + w - r * b, y + h, x + w - r, y + h);
        this.lineTo(x + r, y + h);
        this.curveTo(x + r * b, y + h, x, y + h - r * b, x, y + h - r);
        this.lineTo(x, y + r);
        this.curveTo(x, y + r * b, x + r * b, y, x + r, y);
    }

    public void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        this.pdf.setAction(action, llx, lly, urx, ury);
    }

    public void setLiteral(String s) {
        this.content.append(s);
    }

    public void setLiteral(char c) {
        this.content.append(c);
    }

    public void setLiteral(float n) {
        this.content.append(n);
    }

    void checkNoPattern(PdfTemplate t) {
        if (t.getType() == 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.use.of.a.pattern.a.template.was.expected", new Object[0]));
        }
    }

    public void drawRadioField(float llx, float lly, float urx, float ury, boolean on) {
        if (llx > urx) {
            float x = llx;
            llx = urx;
            urx = x;
        }
        if (lly > ury) {
            float y = lly;
            lly = ury;
            ury = y;
        }
        this.saveState();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new BaseColor(192, 192, 192));
        this.arc(llx + 1.0f, lly + 1.0f, urx - 1.0f, ury - 1.0f, 0.0f, 360.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new BaseColor(160, 160, 160));
        this.arc(llx + 0.5f, lly + 0.5f, urx - 0.5f, ury - 0.5f, 45.0f, 180.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new BaseColor(0, 0, 0));
        this.arc(llx + 1.5f, lly + 1.5f, urx - 1.5f, ury - 1.5f, 45.0f, 180.0f);
        this.stroke();
        if (on) {
            this.setLineWidth(1.0f);
            this.setLineCap(1);
            this.setColorFill(new BaseColor(0, 0, 0));
            this.arc(llx + 4.0f, lly + 4.0f, urx - 4.0f, ury - 4.0f, 0.0f, 360.0f);
            this.fill();
        }
        this.restoreState();
    }

    public void drawTextField(float llx, float lly, float urx, float ury) {
        if (llx > urx) {
            float x = llx;
            llx = urx;
            urx = x;
        }
        if (lly > ury) {
            float y = lly;
            lly = ury;
            ury = y;
        }
        this.saveState();
        this.setColorStroke(new BaseColor(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(llx, lly, urx - llx, ury - lly);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new BaseColor(255, 255, 255));
        this.rectangle(llx + 0.5f, lly + 0.5f, urx - llx - 1.0f, ury - lly - 1.0f);
        this.fill();
        this.setColorStroke(new BaseColor(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(llx + 1.0f, lly + 1.5f);
        this.lineTo(urx - 1.5f, lly + 1.5f);
        this.lineTo(urx - 1.5f, ury - 1.0f);
        this.stroke();
        this.setColorStroke(new BaseColor(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(llx + 1.0f, lly + 1.0f);
        this.lineTo(llx + 1.0f, ury - 1.0f);
        this.lineTo(urx - 1.0f, ury - 1.0f);
        this.stroke();
        this.setColorStroke(new BaseColor(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(llx + 2.0f, lly + 2.0f);
        this.lineTo(llx + 2.0f, ury - 2.0f);
        this.lineTo(urx - 2.0f, ury - 2.0f);
        this.stroke();
        this.restoreState();
    }

    public void drawButton(float llx, float lly, float urx, float ury, String text, BaseFont bf, float size) {
        if (llx > urx) {
            float x = llx;
            llx = urx;
            urx = x;
        }
        if (lly > ury) {
            float y = lly;
            lly = ury;
            ury = y;
        }
        this.saveState();
        this.setColorStroke(new BaseColor(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(llx, lly, urx - llx, ury - lly);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new BaseColor(192, 192, 192));
        this.rectangle(llx + 0.5f, lly + 0.5f, urx - llx - 1.0f, ury - lly - 1.0f);
        this.fill();
        this.setColorStroke(new BaseColor(255, 255, 255));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(llx + 1.0f, lly + 1.0f);
        this.lineTo(llx + 1.0f, ury - 1.0f);
        this.lineTo(urx - 1.0f, ury - 1.0f);
        this.stroke();
        this.setColorStroke(new BaseColor(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(llx + 1.0f, lly + 1.0f);
        this.lineTo(urx - 1.0f, lly + 1.0f);
        this.lineTo(urx - 1.0f, ury - 1.0f);
        this.stroke();
        this.resetRGBColorFill();
        this.beginText();
        this.setFontAndSize(bf, size);
        this.showTextAligned(1, text, llx + (urx - llx) / 2.0f, lly + (ury - lly - size) / 2.0f, 0.0f);
        this.endText();
        this.restoreState();
    }

    PageResources getPageResources() {
        return this.pdf.getPageResources();
    }

    public void setGState(PdfGState gstate) {
        PdfObject[] obj = this.writer.addSimpleExtGState(gstate);
        PageResources prs = this.getPageResources();
        PdfName name = prs.addExtGState((PdfName)obj[0], (PdfIndirectReference)obj[1]);
        this.state.extGState = gstate;
        this.content.append(name.getBytes()).append(" gs").append_i(this.separator);
    }

    public void beginLayer(PdfOCG layer) {
        if (layer instanceof PdfLayer && ((PdfLayer)layer).getTitle() != null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.title.is.not.a.layer", new Object[0]));
        }
        if (this.layerDepth == null) {
            this.layerDepth = new ArrayList();
        }
        if (layer instanceof PdfLayerMembership) {
            this.layerDepth.add(1);
            this.beginLayer2(layer);
            return;
        }
        int n = 0;
        for (PdfLayer la = (PdfLayer)layer; la != null; la = la.getParent()) {
            if (la.getTitle() != null) continue;
            this.beginLayer2(la);
            ++n;
        }
        this.layerDepth.add(n);
    }

    private void beginLayer2(PdfOCG layer) {
        PdfName name = (PdfName)this.writer.addSimpleProperty(layer, layer.getRef())[0];
        PageResources prs = this.getPageResources();
        name = prs.addProperty(name, layer.getRef());
        this.content.append("/OC ").append(name.getBytes()).append(" BDC").append_i(this.separator);
    }

    public void endLayer() {
        int n = 1;
        if (this.layerDepth != null && !this.layerDepth.isEmpty()) {
            n = this.layerDepth.get(this.layerDepth.size() - 1);
            this.layerDepth.remove(this.layerDepth.size() - 1);
        } else {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.layer.operators", new Object[0]));
        }
        while (n-- > 0) {
            this.content.append("EMC").append_i(this.separator);
        }
    }

    public void transform(cfca.com.itextpdf.awt.geom.AffineTransform af) {
        if (this.inText && this.isTagged()) {
            this.endText();
        }
        double[] matrix = new double[6];
        af.getMatrix(matrix);
        this.state.CTM.concatenate(af);
        this.content.append(matrix[0]).append(' ').append(matrix[1]).append(' ').append(matrix[2]).append(' ');
        this.content.append(matrix[3]).append(' ').append(matrix[4]).append(' ').append(matrix[5]).append(" cm").append_i(this.separator);
    }

    void addAnnotation(PdfAnnotation annot) {
        this.writer.addAnnotation(annot);
    }

    void addAnnotation(PdfAnnotation annot, boolean applyCTM) {
        if (applyCTM && this.state.CTM.getType() != 0) {
            annot.applyCTM(this.state.CTM);
        }
        this.addAnnotation(annot);
    }

    public void setDefaultColorspace(PdfName name, PdfObject obj) {
        PageResources prs = this.getPageResources();
        prs.addDefaultColor(name, obj);
    }

    public void beginMarkedContentSequence(PdfStructureElement struc) {
        PdfObject obj = struc.get(PdfName.K);
        int[] structParentMarkPoint = this.pdf.getStructParentIndexAndNextMarkPoint(this.getCurrentPage());
        int structParent = structParentMarkPoint[0];
        int mark = structParentMarkPoint[1];
        if (obj != null) {
            PdfArray ar = null;
            if (obj.isNumber()) {
                ar = new PdfArray();
                ar.add(obj);
                struc.put(PdfName.K, ar);
            } else if (obj.isArray()) {
                ar = (PdfArray)obj;
            } else {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("unknown.object.at.k.1", obj.getClass().toString()));
            }
            if (ar.getAsNumber(0) != null) {
                PdfDictionary dic = new PdfDictionary(PdfName.MCR);
                dic.put(PdfName.PG, this.getCurrentPage());
                dic.put(PdfName.MCID, new PdfNumber(mark));
                ar.add(dic);
            }
            struc.setPageMark(this.pdf.getStructParentIndex(this.getCurrentPage()), -1);
        } else {
            struc.setPageMark(structParent, mark);
            struc.put(PdfName.PG, this.getCurrentPage());
        }
        this.setMcDepth(this.getMcDepth() + 1);
        int contentSize = this.content.size();
        this.content.append(struc.get(PdfName.S).getBytes()).append(" <</MCID ").append(mark).append(">> BDC").append_i(this.separator);
        this.markedContentSize += this.content.size() - contentSize;
    }

    protected PdfIndirectReference getCurrentPage() {
        return this.writer.getCurrentPage();
    }

    public void endMarkedContentSequence() {
        if (this.getMcDepth() == 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.marked.content.operators", new Object[0]));
        }
        int contentSize = this.content.size();
        this.setMcDepth(this.getMcDepth() - 1);
        this.content.append("EMC").append_i(this.separator);
        this.markedContentSize += this.content.size() - contentSize;
    }

    public void beginMarkedContentSequence(PdfName tag, PdfDictionary property, boolean inline) {
        int contentSize = this.content.size();
        if (property == null) {
            this.content.append(tag.getBytes()).append(" BMC").append_i(this.separator);
            this.setMcDepth(this.getMcDepth() + 1);
        } else {
            this.content.append(tag.getBytes()).append(' ');
            if (inline) {
                try {
                    property.toPdf(this.writer, this.content);
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            } else {
                PdfObject[] objs = this.writer.propertyExists(property) ? this.writer.addSimpleProperty(property, null) : this.writer.addSimpleProperty(property, this.writer.getPdfIndirectReference());
                PdfName name = (PdfName)objs[0];
                PageResources prs = this.getPageResources();
                name = prs.addProperty(name, (PdfIndirectReference)objs[1]);
                this.content.append(name.getBytes());
            }
            this.content.append(" BDC").append_i(this.separator);
            this.setMcDepth(this.getMcDepth() + 1);
        }
        this.markedContentSize += this.content.size() - contentSize;
    }

    public void beginMarkedContentSequence(PdfName tag) {
        this.beginMarkedContentSequence(tag, null, false);
    }

    public void sanityCheck() {
        if (this.getMcDepth() != 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.marked.content.operators", new Object[0]));
        }
        if (this.inText) {
            if (this.isTagged()) {
                this.endText();
            } else {
                throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators", new Object[0]));
            }
        }
        if (this.layerDepth != null && !this.layerDepth.isEmpty()) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.layer.operators", new Object[0]));
        }
        if (!this.stateList.isEmpty()) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.save.restore.state.operators", new Object[0]));
        }
    }

    public void openMCBlock(IAccessibleElement element) {
        if (this.isTagged()) {
            if (this.pdf.openMCDocument) {
                this.pdf.openMCDocument = false;
                this.writer.getDirectContentUnder().openMCBlock(this.pdf);
            }
            if (element != null && !this.getMcElements().contains(element)) {
                PdfStructureElement structureElement = this.openMCBlockInt(element);
                this.getMcElements().add(element);
                if (structureElement != null) {
                    this.pdf.structElements.put(element.getId(), structureElement);
                }
            }
        }
    }

    private PdfDictionary getParentStructureElement() {
        PdfDictionary parent = null;
        if (this.getMcElements().size() > 0) {
            parent = this.pdf.structElements.get(this.getMcElements().get(this.getMcElements().size() - 1).getId());
        }
        if (parent == null) {
            parent = this.writer.getStructureTreeRoot();
        }
        return parent;
    }

    private PdfStructureElement openMCBlockInt(IAccessibleElement element) {
        PdfStructureElement structureElement = null;
        if (this.isTagged()) {
            IAccessibleElement parent = null;
            if (this.getMcElements().size() > 0) {
                parent = this.getMcElements().get(this.getMcElements().size() - 1);
            }
            this.writer.checkElementRole(element, parent);
            if (element.getRole() != null) {
                if (!PdfName.ARTIFACT.equals(element.getRole()) && (structureElement = this.pdf.structElements.get(element.getId())) == null) {
                    structureElement = new PdfStructureElement(this.getParentStructureElement(), element.getRole());
                }
                if (PdfName.ARTIFACT.equals(element.getRole())) {
                    HashMap<PdfName, PdfObject> properties = element.getAccessibleAttributes();
                    PdfDictionary propertiesDict = null;
                    if (properties != null && !properties.isEmpty()) {
                        propertiesDict = new PdfDictionary();
                        for (Map.Entry<PdfName, PdfObject> entry : properties.entrySet()) {
                            propertiesDict.put(entry.getKey(), entry.getValue());
                        }
                    }
                    boolean inTextLocal = this.inText;
                    if (this.inText) {
                        this.endText();
                    }
                    this.beginMarkedContentSequence(element.getRole(), propertiesDict, true);
                    if (inTextLocal) {
                        this.beginText(true);
                    }
                } else if (this.writer.needToBeMarkedInContent(element)) {
                    boolean inTextLocal = this.inText;
                    if (this.inText) {
                        this.endText();
                    }
                    this.beginMarkedContentSequence(structureElement);
                    if (inTextLocal) {
                        this.beginText(true);
                    }
                }
            }
        }
        return structureElement;
    }

    public void closeMCBlock(IAccessibleElement element) {
        if (this.isTagged() && element != null && this.getMcElements().contains(element)) {
            this.closeMCBlockInt(element);
            this.getMcElements().remove(element);
        }
    }

    private void closeMCBlockInt(IAccessibleElement element) {
        if (this.isTagged() && element.getRole() != null) {
            PdfStructureElement structureElement = this.pdf.structElements.get(element.getId());
            if (structureElement != null) {
                structureElement.writeAttributes(element);
            }
            if (this.writer.needToBeMarkedInContent(element)) {
                boolean inTextLocal = this.inText;
                if (this.inText) {
                    this.endText();
                }
                this.endMarkedContentSequence();
                if (inTextLocal) {
                    this.beginText(true);
                }
            }
        }
    }

    protected ArrayList<IAccessibleElement> saveMCBlocks() {
        ArrayList<IAccessibleElement> mc = new ArrayList<IAccessibleElement>();
        if (this.isTagged()) {
            mc = this.getMcElements();
            for (int i = 0; i < mc.size(); ++i) {
                this.closeMCBlockInt(mc.get(i));
            }
            this.setMcElements(new ArrayList<IAccessibleElement>());
        }
        return mc;
    }

    protected void restoreMCBlocks(ArrayList<IAccessibleElement> mcElements) {
        if (this.isTagged() && mcElements != null) {
            this.setMcElements(mcElements);
            for (int i = 0; i < this.getMcElements().size(); ++i) {
                this.openMCBlockInt(this.getMcElements().get(i));
            }
        }
    }

    protected int getMcDepth() {
        if (this.duplicatedFrom != null) {
            return this.duplicatedFrom.getMcDepth();
        }
        return this.mcDepth;
    }

    protected void setMcDepth(int value) {
        if (this.duplicatedFrom != null) {
            this.duplicatedFrom.setMcDepth(value);
        } else {
            this.mcDepth = value;
        }
    }

    protected ArrayList<IAccessibleElement> getMcElements() {
        if (this.duplicatedFrom != null) {
            return this.duplicatedFrom.getMcElements();
        }
        return this.mcElements;
    }

    protected void setMcElements(ArrayList<IAccessibleElement> value) {
        if (this.duplicatedFrom != null) {
            this.duplicatedFrom.setMcElements(value);
        } else {
            this.mcElements = value;
        }
    }

    protected void updateTx(String text, float Tj) {
        this.state.tx += this.getEffectiveStringWidth(text, false, Tj);
    }

    private void saveColor(BaseColor color, boolean fill) {
        if (this.isTagged()) {
            if (this.inText) {
                if (fill) {
                    this.state.textColorFill = color;
                } else {
                    this.state.textColorStroke = color;
                }
            } else if (fill) {
                this.state.colorFill = color;
            } else {
                this.state.colorStroke = color;
            }
        } else if (fill) {
            this.state.colorFill = color;
        } else {
            this.state.colorStroke = color;
        }
    }

    private void restoreColor(BaseColor color, boolean fill) throws IOException {
        if (this.isTagged()) {
            if (color instanceof UncoloredPattern) {
                UncoloredPattern c = (UncoloredPattern)color;
                if (fill) {
                    this.setPatternFill(c.getPainter(), c.color, c.tint);
                } else {
                    this.setPatternStroke(c.getPainter(), c.color, c.tint);
                }
            } else if (fill) {
                this.setColorFill(color);
            } else {
                this.setColorStroke(color);
            }
        }
    }

    private void restoreColor() throws IOException {
        if (this.isTagged()) {
            if (this.inText) {
                if (!this.state.textColorFill.equals(this.state.colorFill)) {
                    this.restoreColor(this.state.textColorFill, true);
                }
                if (!this.state.textColorStroke.equals(this.state.colorStroke)) {
                    this.restoreColor(this.state.textColorStroke, false);
                }
            } else {
                if (!this.state.textColorFill.equals(this.state.colorFill)) {
                    this.restoreColor(this.state.colorFill, true);
                }
                if (!this.state.textColorStroke.equals(this.state.colorStroke)) {
                    this.restoreColor(this.state.colorStroke, false);
                }
            }
        }
    }

    protected boolean getInText() {
        return this.inText;
    }

    protected void checkState() {
        boolean stroke = false;
        boolean fill = false;
        if (this.state.textRenderMode == 0) {
            fill = true;
        } else if (this.state.textRenderMode == 1) {
            stroke = true;
        } else if (this.state.textRenderMode == 2) {
            fill = true;
            stroke = true;
        }
        if (fill) {
            PdfWriter.checkPdfIsoConformance(this.writer, 1, this.isTagged() ? this.state.textColorFill : this.state.colorFill);
        }
        if (stroke) {
            PdfWriter.checkPdfIsoConformance(this.writer, 1, this.isTagged() ? this.state.textColorStroke : this.state.colorStroke);
        }
        PdfWriter.checkPdfIsoConformance(this.writer, 6, this.state.extGState);
    }

    public Graphics2D createGraphicsShapes(float width, float height) {
        return new PdfGraphics2D(this, width, height, true);
    }

    public Graphics2D createPrinterGraphicsShapes(float width, float height, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, true, printerJob);
    }

    public Graphics2D createGraphics(float width, float height) {
        return new PdfGraphics2D(this, width, height);
    }

    public Graphics2D createPrinterGraphics(float width, float height, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, printerJob);
    }

    public Graphics2D createGraphics(float width, float height, boolean convertImagesToJPEG, float quality) {
        return new PdfGraphics2D(this, width, height, null, false, convertImagesToJPEG, quality);
    }

    public Graphics2D createPrinterGraphics(float width, float height, boolean convertImagesToJPEG, float quality, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, null, false, convertImagesToJPEG, quality, printerJob);
    }

    public Graphics2D createGraphicsShapes(float width, float height, boolean convertImagesToJPEG, float quality) {
        return new PdfGraphics2D(this, width, height, null, true, convertImagesToJPEG, quality);
    }

    public Graphics2D createPrinterGraphicsShapes(float width, float height, boolean convertImagesToJPEG, float quality, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, null, true, convertImagesToJPEG, quality, printerJob);
    }

    public Graphics2D createGraphics(float width, float height, FontMapper fontMapper) {
        return new PdfGraphics2D(this, width, height, fontMapper);
    }

    public Graphics2D createPrinterGraphics(float width, float height, FontMapper fontMapper, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, fontMapper, printerJob);
    }

    public Graphics2D createGraphics(float width, float height, FontMapper fontMapper, boolean convertImagesToJPEG, float quality) {
        return new PdfGraphics2D(this, width, height, fontMapper, false, convertImagesToJPEG, quality);
    }

    public Graphics2D createPrinterGraphics(float width, float height, FontMapper fontMapper, boolean convertImagesToJPEG, float quality, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, width, height, fontMapper, false, convertImagesToJPEG, quality, printerJob);
    }

    public void addImage(Image image, AffineTransform transform) throws DocumentException {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.addImage(image, new cfca.com.itextpdf.awt.geom.AffineTransform(matrix));
    }

    public void addTemplate(PdfTemplate template, AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.addTemplate(template, new cfca.com.itextpdf.awt.geom.AffineTransform(matrix));
    }

    public void concatCTM(AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.concatCTM(new cfca.com.itextpdf.awt.geom.AffineTransform(matrix));
    }

    public void setTextMatrix(AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        this.setTextMatrix(new cfca.com.itextpdf.awt.geom.AffineTransform(matrix));
    }

    public void transform(AffineTransform af) {
        double[] matrix = new double[6];
        af.getMatrix(matrix);
        this.transform(new cfca.com.itextpdf.awt.geom.AffineTransform(matrix));
    }

    static {
        abrev.put(PdfName.BITSPERCOMPONENT, "/BPC ");
        abrev.put(PdfName.COLORSPACE, "/CS ");
        abrev.put(PdfName.DECODE, "/D ");
        abrev.put(PdfName.DECODEPARMS, "/DP ");
        abrev.put(PdfName.FILTER, "/F ");
        abrev.put(PdfName.HEIGHT, "/H ");
        abrev.put(PdfName.IMAGEMASK, "/IM ");
        abrev.put(PdfName.INTENT, "/Intent ");
        abrev.put(PdfName.INTERPOLATE, "/I ");
        abrev.put(PdfName.WIDTH, "/W ");
    }

    static class UncoloredPattern
    extends PatternColor {
        protected BaseColor color;
        protected float tint;

        protected UncoloredPattern(PdfPatternPainter p, BaseColor color, float tint) {
            super(p);
            this.color = color;
            this.tint = tint;
        }

        public boolean equals(Object obj) {
            return obj instanceof UncoloredPattern && ((UncoloredPattern)obj).painter.equals(this.painter) && ((UncoloredPattern)obj).color.equals(this.color) && ((UncoloredPattern)obj).tint == this.tint;
        }
    }

    public static class GraphicState {
        FontDetails fontDetails;
        ColorDetails colorDetails;
        float size;
        protected float xTLM = 0.0f;
        protected float yTLM = 0.0f;
        protected float aTLM = 1.0f;
        protected float bTLM = 0.0f;
        protected float cTLM = 0.0f;
        protected float dTLM = 1.0f;
        protected float tx = 0.0f;
        protected float leading = 0.0f;
        protected float scale = 100.0f;
        protected float charSpace = 0.0f;
        protected float wordSpace = 0.0f;
        protected BaseColor textColorFill = new GrayColor(0);
        protected BaseColor colorFill = new GrayColor(0);
        protected BaseColor textColorStroke = new GrayColor(0);
        protected BaseColor colorStroke = new GrayColor(0);
        protected int textRenderMode = 0;
        protected cfca.com.itextpdf.awt.geom.AffineTransform CTM = new cfca.com.itextpdf.awt.geom.AffineTransform();
        protected PdfObject extGState = null;

        GraphicState() {
        }

        GraphicState(GraphicState cp) {
            this.copyParameters(cp);
        }

        void copyParameters(GraphicState cp) {
            this.fontDetails = cp.fontDetails;
            this.colorDetails = cp.colorDetails;
            this.size = cp.size;
            this.xTLM = cp.xTLM;
            this.yTLM = cp.yTLM;
            this.aTLM = cp.aTLM;
            this.bTLM = cp.bTLM;
            this.cTLM = cp.cTLM;
            this.dTLM = cp.dTLM;
            this.tx = cp.tx;
            this.leading = cp.leading;
            this.scale = cp.scale;
            this.charSpace = cp.charSpace;
            this.wordSpace = cp.wordSpace;
            this.textColorFill = cp.textColorFill;
            this.colorFill = cp.colorFill;
            this.textColorStroke = cp.textColorStroke;
            this.colorStroke = cp.colorStroke;
            this.CTM = new cfca.com.itextpdf.awt.geom.AffineTransform(cp.CTM);
            this.textRenderMode = cp.textRenderMode;
            this.extGState = cp.extGState;
        }

        void restore(GraphicState restore) {
            this.copyParameters(restore);
        }
    }
}

