/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.xml.simpleparser.SimpleXMLDocHandler;
import cfca.com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private final Stack<String> fieldNames = new Stack();
    private final Stack<String> fieldValues = new Stack();
    HashMap<String, String> fields;
    protected HashMap<String, List<String>> listFields;
    String fileSpec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XfdfReader(String filename) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filename);
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fin);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public XfdfReader(byte[] xfdfIn) throws IOException {
        this(new ByteArrayInputStream(xfdfIn));
    }

    public XfdfReader(InputStream is) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, is);
    }

    public HashMap<String, String> getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return this.fields.get(name);
    }

    public String getFieldValue(String name) {
        String field = this.fields.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    public List<String> getListValues(String name) {
        return this.listFields.get(name);
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    @Override
    public void startElement(String tag, Map<String, String> h) {
        if (!this.foundRoot) {
            if (!tag.equals("xfdf")) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.xfdf.1", tag));
            }
            this.foundRoot = true;
        }
        if (!tag.equals("xfdf")) {
            if (tag.equals("f")) {
                this.fileSpec = h.get("href");
            } else if (tag.equals("fields")) {
                this.fields = new HashMap();
                this.listFields = new HashMap();
            } else if (tag.equals("field")) {
                String fName = h.get("name");
                this.fieldNames.push(fName);
            } else if (tag.equals("value")) {
                this.fieldValues.push("");
            }
        }
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("value")) {
            String fVal;
            String old;
            String fName = "";
            for (int k = 0; k < this.fieldNames.size(); ++k) {
                fName = fName + "." + (String)this.fieldNames.elementAt(k);
            }
            if (fName.startsWith(".")) {
                fName = fName.substring(1);
            }
            if ((old = this.fields.put(fName, fVal = this.fieldValues.pop())) != null) {
                List<String> l = this.listFields.get(fName);
                if (l == null) {
                    l = new ArrayList<String>();
                    l.add(old);
                }
                l.add(fVal);
                this.listFields.put(fName, l);
            }
        } else if (tag.equals("field") && !this.fieldNames.isEmpty()) {
            this.fieldNames.pop();
        }
    }

    @Override
    public void startDocument() {
        this.fileSpec = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(String str) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        String val = this.fieldValues.pop();
        val = val + str;
        this.fieldValues.push(val);
    }
}

