/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.io.StreamUtil;
import cfca.com.itextpdf.text.log.Level;
import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.PdfEncryption;
import cfca.com.itextpdf.text.pdf.security.CertificateUtil;
import cfca.com.itextpdf.text.pdf.security.OcspClient;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateID;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateStatus;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPException;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPReq;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.RevokedStatus;
import cfca.sadk.org.bouncycastle.cert.ocsp.SingleResp;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.operator.OperatorException;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class OcspClientBouncyCastle
implements OcspClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcspClientBouncyCastle.class);

    private static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, IOException, OperatorException, CertificateEncodingException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        OCSPReqBuilder gen = new OCSPReqBuilder();
        gen.addRequest(id);
        Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(new DEROctetString(PdfEncryption.createDocumentId()).getEncoded()));
        gen.setRequestExtensions(new Extensions(new Extension[]{ext}));
        return gen.build();
    }

    private OCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = CertificateUtil.getOCSPURL(checkCert);
        }
        if (url == null) {
            return null;
        }
        LOGGER.info("Getting OCSP from " + url);
        OCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL urlt = new URL(url);
        HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "application/ocsp-response");
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
        dataOut.write(array);
        dataOut.flush();
        dataOut.close();
        if (con.getResponseCode() / 100 != 2) {
            throw new IOException(MessageLocalization.getComposedMessage("invalid.http.response.1", con.getResponseCode()));
        }
        InputStream in = (InputStream)con.getContent();
        return new OCSPResp(StreamUtil.inputStreamToArray(in));
    }

    public BasicOCSPResp getBasicOCSPResp(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            OCSPResp ocspResponse = this.getOcspResponse(checkCert, rootCert, url);
            if (ocspResponse == null) {
                return null;
            }
            if (ocspResponse.getStatus() != 0) {
                return null;
            }
            return (BasicOCSPResp)ocspResponse.getResponseObject();
        }
        catch (Exception ex) {
            if (LOGGER.isLogging(Level.ERROR)) {
                LOGGER.error(ex.getMessage());
            }
            return null;
        }
    }

    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        block5: {
            try {
                SingleResp[] responses;
                BasicOCSPResp basicResponse = this.getBasicOCSPResp(checkCert, rootCert, url);
                if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                    SingleResp resp = responses[0];
                    CertificateStatus status = resp.getCertStatus();
                    if (status == CertificateStatus.GOOD) {
                        return basicResponse.getEncoded();
                    }
                    if (status instanceof RevokedStatus) {
                        throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.revoked", new Object[0]));
                    }
                    throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.unknown", new Object[0]));
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isLogging(Level.ERROR)) break block5;
                LOGGER.error(ex.getMessage());
            }
        }
        return null;
    }
}

