/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.ExceptionConverter;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.security.BouncyCastleDigest;
import cfca.com.itextpdf.text.pdf.security.CertificateInfo;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.EncryptionAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.MakeSignature;
import cfca.com.itextpdf.text.pdf.security.TSAClient;
import cfca.com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Enumerated;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERUTCTime;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.ess.ESSCertID;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificate;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificateV2;
import cfca.sadk.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateID;
import cfca.sadk.org.bouncycastle.cert.ocsp.SingleResp;
import cfca.sadk.org.bouncycastle.jce.X509Principal;
import cfca.sadk.org.bouncycastle.jce.provider.X509CertParser;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.cert.PdfX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPKCS7 {
    private static final Logger logger = LoggerFactory.getLogger(PdfPKCS7.class);
    private int signType;
    private byte[] pkcs7ContentsKey;
    private boolean docBase64Encoding;
    public String provider;
    public String signName;
    public String reason;
    public String location;
    public Calendar signDate;
    public int version = 1;
    public int signerversion = 1;
    public String digestAlgorithmOid;
    public MessageDigest messageDigest;
    public Set<String> digestalgos;
    public byte[] digestAttr;
    public PdfName filterSubtype;
    public String digestEncryptionAlgorithmOid;
    public ExternalDigest interfaceDigest;
    public byte[] externalDigest;
    public byte[] externalRSAdata;
    private Signature sig;
    public byte[] digest;
    public byte[] RSAdata;
    public byte[] sigAttr;
    public byte[] sigAttrDer;
    public MessageDigest encContDigest;
    public boolean verified;
    public boolean verifyResult;
    public Collection<Certificate> certs;
    private Collection<Certificate> signCerts;
    public X509Certificate signCert;
    private Collection<CRL> crls;
    private BasicOCSPResp basicResp;
    public boolean isTsp;
    public boolean isCades;
    public TimeStampToken timeStampToken;

    public int getSignType() {
        return this.signType;
    }

    public boolean getDocBase64Encoding() {
        return this.docBase64Encoding;
    }

    public PdfPKCS7(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider, ExternalDigest interfaceDigest, boolean hasRSAdata) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.provider = provider;
        this.interfaceDigest = interfaceDigest;
        this.digestAlgorithmOid = DigestAlgorithms.getAllowedDigests(hashAlgorithm);
        if (this.digestAlgorithmOid == null) {
            throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.hash.algorithm.1", hashAlgorithm));
        }
        this.signCert = (X509Certificate)certChain[0];
        this.certs = new ArrayList<Certificate>();
        for (Certificate element : certChain) {
            this.certs.add(element);
        }
        this.digestalgos = new HashSet<String>();
        this.digestalgos.add(this.digestAlgorithmOid);
        if (privKey != null) {
            this.digestEncryptionAlgorithmOid = privKey.getAlgorithm();
            if (this.digestEncryptionAlgorithmOid.equals("RSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.113549.1.1.1";
            } else if (this.digestEncryptionAlgorithmOid.equals("DSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.10040.4.1";
            } else {
                throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", this.digestEncryptionAlgorithmOid));
            }
        }
        if (hasRSAdata) {
            this.RSAdata = new byte[0];
            this.messageDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
        }
        if (privKey != null) {
            this.sig = this.initSignature(privKey);
        }
    }

    public PdfPKCS7(byte[] contentsKey, byte[] certsKey, String provider) {
        try {
            this.provider = provider;
            X509CertParser cr = new X509CertParser();
            cr.engineInit((InputStream)new ByteArrayInputStream(certsKey));
            this.certs = cr.engineReadAll();
            this.signCerts = this.certs;
            this.signCert = (X509Certificate)this.certs.iterator().next();
            this.crls = new ArrayList<CRL>();
            ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));
            this.digest = ((ASN1OctetString)in.readObject()).getOctets();
            this.sig = provider == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public byte[] getPKCS7ContentsKey() {
        return this.pkcs7ContentsKey;
    }

    public PdfPKCS7(byte[] contentsKey, PdfName filterSubtype, String provider) {
        this.pkcs7ContentsKey = contentsKey;
        this.filterSubtype = filterSubtype;
        this.isTsp = PdfName.ETSI_RFC3161.equals(filterSubtype);
        this.isCades = PdfName.ETSI_CADES_DETACHED.equals(filterSubtype);
        this.docBase64Encoding = PdfName.RSA_BASE64_SHA1.equals(filterSubtype);
        try {
            DEROctetString octetString;
            X509Certificate cert;
            ASN1Primitive pkcs;
            this.provider = provider;
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.decode.pkcs7signeddata.object", new Object[0]));
            }
            finally {
                din.close();
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.a.sequence", new Object[0]));
            }
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedData.getObjectAt(0);
            if (objId.getId().equals("1.2.840.113549.1.7.2")) {
                this.signType = 0;
            } else if (objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                this.signType = 1;
            } else {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.signed.data", new Object[0]));
            }
            ASN1Sequence content = (ASN1Sequence)((ASN1TaggedObject)signedData.getObjectAt(1)).getObject();
            this.version = ((ASN1Integer)content.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet<String>();
            Enumeration e = ((ASN1Set)content.getObjectAt(1)).getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)e.nextElement();
                ASN1ObjectIdentifier o = (ASN1ObjectIdentifier)s.getObjectAt(0);
                this.digestalgos.add(o.getId());
            }
            ASN1Sequence rsaData = (ASN1Sequence)content.getObjectAt(2);
            if (rsaData.size() > 1) {
                ASN1OctetString rsaDataContent = (ASN1OctetString)((ASN1TaggedObject)rsaData.getObjectAt(1)).getObject();
                this.RSAdata = rsaDataContent.getOctets();
            }
            int next = 3;
            while (content.getObjectAt(next) instanceof ASN1TaggedObject) {
                ++next;
            }
            if (this.signType == 1) {
                ASN1Sequence seqCert = (ASN1Sequence)((ASN1TaggedObject)content.getObjectAt(next - 1)).getObject();
                byte[] certBytes = seqCert.getEncoded();
                X509Cert cert2 = new X509Cert(certBytes);
                PdfX509Certificate pdfX509Certificate = new PdfX509Certificate(cert2);
                this.certs = new ArrayList<Certificate>();
                this.certs.add(pdfX509Certificate);
            } else if (this.signType == 0) {
                X509CertParser cr = new X509CertParser();
                cr.engineInit((InputStream)new ByteArrayInputStream(contentsKey));
                this.certs = cr.engineReadAll();
            }
            ASN1Set signerInfos = (ASN1Set)content.getObjectAt(next);
            if (signerInfos.size() != 1) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time", new Object[0]));
            }
            ASN1Sequence signerInfo = (ASN1Sequence)signerInfos.getObjectAt(0);
            this.signerversion = ((ASN1Integer)signerInfo.getObjectAt(0)).getValue().intValue();
            ASN1Sequence issuerAndSerialNumber = (ASN1Sequence)signerInfo.getObjectAt(1);
            X509Principal issuer = new X509Principal(issuerAndSerialNumber.getObjectAt(0).toASN1Primitive().getEncoded());
            BigInteger serialNumber = ((ASN1Integer)issuerAndSerialNumber.getObjectAt(1)).getValue();
            if (0 == this.signType) {
                for (Certificate element : this.certs) {
                    cert = (X509Certificate)element;
                    if (!cert.getIssuerDN().equals(issuer) || !serialNumber.equals(cert.getSerialNumber())) continue;
                    this.signCert = cert;
                    break;
                }
            } else if (1 == this.signType) {
                for (Certificate element : this.certs) {
                    cert = (PdfX509Certificate)element;
                    if (!cert.getIssuerDN().equals(issuer) || !serialNumber.equals(cert.getSerialNumber())) continue;
                    this.signCert = cert;
                    break;
                }
            }
            if (this.signCert == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.find.signing.certificate.with.serial.1", issuer.getName() + " / " + serialNumber.toString(16)));
            }
            this.signCertificateChain();
            this.digestAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
            next = 3;
            boolean foundCades = false;
            if (0 == this.signType && signerInfo.getObjectAt(next) instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagsig = (ASN1TaggedObject)signerInfo.getObjectAt(next);
                ASN1Set sseq = ASN1Set.getInstance((ASN1TaggedObject)tagsig, (boolean)false);
                this.sigAttr = sseq.getEncoded();
                this.sigAttrDer = sseq.getEncoded("DER");
                for (int k = 0; k < sseq.size(); ++k) {
                    byte[] hs2;
                    ESSCertID cerv2;
                    ESSCertID[] cerv2m;
                    ASN1Sequence seqout;
                    ASN1Set setout;
                    ASN1Sequence seq2 = (ASN1Sequence)sseq.getObjectAt(k);
                    String idSeq2 = ((ASN1ObjectIdentifier)seq2.getObjectAt(0)).getId();
                    if (idSeq2.equals("1.2.840.113549.1.9.4")) {
                        ASN1Set set = (ASN1Set)seq2.getObjectAt(1);
                        this.digestAttr = ((ASN1OctetString)set.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (idSeq2.equals("1.2.840.113583.1.1.8")) {
                        setout = (ASN1Set)seq2.getObjectAt(1);
                        seqout = (ASN1Sequence)setout.getObjectAt(0);
                        for (int j = 0; j < seqout.size(); ++j) {
                            ASN1Sequence seqin;
                            ASN1TaggedObject tg = (ASN1TaggedObject)seqout.getObjectAt(j);
                            if (tg.getTagNo() == 0) {
                                seqin = (ASN1Sequence)tg.getObject();
                                this.findCRL(seqin);
                            }
                            if (tg.getTagNo() != 1) continue;
                            seqin = (ASN1Sequence)tg.getObject();
                            this.findOcsp(seqin);
                        }
                        continue;
                    }
                    if (this.isCades && idSeq2.equals("1.2.840.113549.1.9.16.2.12")) {
                        byte[] hs22;
                        setout = (ASN1Set)seq2.getObjectAt(1);
                        seqout = (ASN1Sequence)setout.getObjectAt(0);
                        SigningCertificate sv2 = SigningCertificate.getInstance((Object)seqout);
                        cerv2m = sv2.getCerts();
                        cerv2 = cerv2m[0];
                        byte[] enc2 = this.signCert.getEncoded();
                        MessageDigest m2 = new BouncyCastleDigest().getMessageDigest("SHA-1");
                        byte[] signCertHash = m2.digest(enc2);
                        if (!Arrays.equals(signCertHash, hs22 = cerv2.getCertHash())) {
                            throw new IllegalArgumentException("Signing certificate doesn't match the ESS information.");
                        }
                        foundCades = true;
                        continue;
                    }
                    if (!this.isCades || !idSeq2.equals("1.2.840.113549.1.9.16.2.47")) continue;
                    setout = (ASN1Set)seq2.getObjectAt(1);
                    seqout = (ASN1Sequence)setout.getObjectAt(0);
                    SigningCertificateV2 sv2 = SigningCertificateV2.getInstance((Object)seqout);
                    cerv2m = sv2.getCerts();
                    cerv2 = cerv2m[0];
                    AlgorithmIdentifier ai2 = cerv2.getHashAlgorithm();
                    byte[] enc2 = this.signCert.getEncoded();
                    MessageDigest m2 = new BouncyCastleDigest().getMessageDigest(DigestAlgorithms.getDigest(ai2.getAlgorithm().getId()));
                    byte[] signCertHash = m2.digest(enc2);
                    if (!Arrays.equals(signCertHash, hs2 = cerv2.getCertHash())) {
                        throw new IllegalArgumentException("Signing certificate doesn't match the ESS information.");
                    }
                    foundCades = true;
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("authenticated.attribute.is.missing.the.digest", new Object[0]));
                }
            } else if (0 == this.signType && signerInfo.getObjectAt(next + 1) instanceof DEROctetString) {
                octetString = (DEROctetString)signerInfo.getObjectAt(next + 1);
                this.sigAttr = octetString.getOctets();
                this.sigAttrDer = this.sigAttr;
                this.digestEncryptionAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(next)).getObjectAt(0)).getId();
                PublicKey publicKey = this.signCert.getPublicKey();
                this.sig = this.initSignature(publicKey);
            } else if (1 == this.signType && signerInfo.getObjectAt(next + 1) instanceof DEROctetString) {
                octetString = (DEROctetString)signerInfo.getObjectAt(next + 1);
                this.sigAttr = octetString.getOctets();
                this.sigAttrDer = this.sigAttr;
                this.digestEncryptionAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(next)).getObjectAt(0)).getId();
            }
            if (0 == this.signType) {
                ASN1TaggedObject taggedObject;
                ASN1Set unat;
                AttributeTable attble;
                Attribute ts;
                if (signerInfo.getObjectAt(next) instanceof ASN1TaggedObject) {
                    ++next;
                }
                if (this.isCades && !foundCades) {
                    throw new IllegalArgumentException("CAdES ESS information missing.");
                }
                this.digestEncryptionAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(next++)).getObjectAt(0)).getId();
                this.digest = ((ASN1OctetString)signerInfo.getObjectAt(next++)).getOctets();
                if (next < signerInfo.size() && signerInfo.getObjectAt(next) instanceof ASN1TaggedObject && (ts = (attble = new AttributeTable(unat = ASN1Set.getInstance((ASN1TaggedObject)(taggedObject = (ASN1TaggedObject)signerInfo.getObjectAt(next)), (boolean)false))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null && ts.getAttrValues().size() > 0) {
                    ASN1Set attributeValues = ts.getAttrValues();
                    ASN1Sequence tokenSequence = ASN1Sequence.getInstance((Object)attributeValues.getObjectAt(0));
                    ContentInfo contentInfo = new ContentInfo(tokenSequence);
                    this.timeStampToken = new TimeStampToken(contentInfo);
                }
                if (this.isTsp) {
                    ContentInfo contentInfoTsp = new ContentInfo(signedData);
                    this.timeStampToken = new TimeStampToken(contentInfoTsp);
                    TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
                    String algOID = info.getMessageImprintAlgOID().getId();
                    this.messageDigest = DigestAlgorithms.getMessageDigestFromOid(algOID, null);
                } else {
                    PublicKey publicKey;
                    if (this.RSAdata != null || this.digestAttr != null) {
                        if (PdfName.ADBE_PKCS7_SHA1.equals(this.getFilterSubtype())) {
                            this.messageDigest = DigestAlgorithms.getMessageDigest("SHA1", provider);
                            this.sigAttr = null;
                            this.sigAttrDer = null;
                        } else {
                            this.messageDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
                        }
                        this.encContDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
                    }
                    if (null == (publicKey = this.signCert.getPublicKey())) {
                        X509Cert x509Cert = new X509Cert(this.signCert.getEncoded());
                        publicKey = x509Cert.getPublicKey();
                    }
                    this.sig = this.initSignature(publicKey);
                }
            } else if (1 == this.signType) {
                this.messageDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
                byte[] userId = "1234567812345678".getBytes("UTF8");
                SM2PublicKey sm2PublicKey = (SM2PublicKey)this.signCert.getPublicKey();
                BigInteger pubX = sm2PublicKey.getPubXByInt();
                BigInteger pubY = sm2PublicKey.getPubYByInt();
                byte[] z = SM2HashZValue.getZa((BigInteger)pubX, (BigInteger)pubY, (byte[])userId);
                this.messageDigest.update(z, 0, z.length);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public byte[] getDigestAttribute() {
        return this.digestAttr;
    }

    public byte[] getSignatureAttribute() {
        return this.sigAttr;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getSignDate() {
        Calendar dt = this.getTimeStampDate();
        if (dt == null) {
            return this.signDate;
        }
        return dt;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithmOid() {
        return this.digestAlgorithmOid;
    }

    public String getHashAlgorithm() {
        return DigestAlgorithms.getDigest(this.digestAlgorithmOid);
    }

    public String getDigestEncryptionAlgorithmOid() {
        return this.digestEncryptionAlgorithmOid;
    }

    public String getDigestAlgorithm() {
        return this.getHashAlgorithm() + "with" + this.getEncryptionAlgorithm();
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        if (digestEncryptionAlgorithm != null) {
            if (digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.113549.1.1.1";
            } else if (digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.10040.4.1";
            } else if (digestEncryptionAlgorithm.equals("ECDSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.10045.2.1";
            } else {
                throw new ExceptionConverter(new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", digestEncryptionAlgorithm)));
            }
        }
    }

    public byte[] getRawPKCS1() {
        return this.digest;
    }

    private Signature initSignature(PrivateKey key) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature signature = this.provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), this.provider);
        signature.initSign(key);
        return signature;
    }

    private Signature initSignature(PublicKey key) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String digestAlgorithm = this.getDigestAlgorithm();
        if (PdfName.ADBE_X509_RSA_SHA1.equals(this.getFilterSubtype())) {
            digestAlgorithm = "SHA1withRSA";
        }
        Signature signature = this.provider == null ? Signature.getInstance(digestAlgorithm) : Signature.getInstance(digestAlgorithm, this.provider);
        signature.initVerify(key);
        return signature;
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (0 == this.signType) {
            if (this.RSAdata != null || this.digestAttr != null || this.isTsp) {
                this.messageDigest.update(buf, off, len);
            } else {
                this.sig.update(buf, off, len);
            }
        } else if (1 == this.signType) {
            this.messageDigest.update(buf, off, len);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteBuffer bOut = new ByteBuffer();
            ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
            dout.writeObject((ASN1Encodable)new DEROctetString(this.digest));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null, null, MakeSignature.CryptoStandard.CMS);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime) {
        return this.getEncodedPKCS7(secondDigest, signingTime, null, null, null, MakeSignature.CryptoStandard.CMS);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime, TSAClient tsaClient, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                this.digest = this.sig.sign();
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                this.digest = this.sig.sign();
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            for (String element : this.digestalgos) {
                ASN1EncodableVector algos = new ASN1EncodableVector();
                algos.add((ASN1Encodable)new ASN1ObjectIdentifier(element));
                algos.add((ASN1Encodable)DERNull.INSTANCE);
                digestAlgorithms.add((ASN1Encodable)new DERSequence(algos));
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            if (this.RSAdata != null) {
                v.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(this.RSAdata)));
            }
            DERSequence contentinfo = new DERSequence(v);
            v = new ASN1EncodableVector();
            for (Certificate element : this.certs) {
                ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)element).getEncoded()));
                v.add((ASN1Encodable)tempstream.readObject());
            }
            DERSet dercertificates = new DERSet(v);
            ASN1EncodableVector signerinfo = new ASN1EncodableVector();
            signerinfo.add((ASN1Encodable)new ASN1Integer((long)this.signerversion));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)CertificateInfo.getIssuer(this.signCert.getTBSCertificate()));
            v.add((ASN1Encodable)new ASN1Integer(this.signCert.getSerialNumber()));
            signerinfo.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestAlgorithmOid));
            v.add((ASN1Encodable)new DERNull());
            signerinfo.add((ASN1Encodable)new DERSequence(v));
            if (secondDigest != null && signingTime != null) {
                signerinfo.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp, crlBytes, sigtype)));
            }
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestEncryptionAlgorithmOid));
            v.add((ASN1Encodable)new DERNull());
            signerinfo.add((ASN1Encodable)new DERSequence(v));
            signerinfo.add((ASN1Encodable)new DEROctetString(this.digest));
            if (tsaClient != null) {
                ASN1EncodableVector unauthAttributes;
                byte[] tsToken;
                logger.info("begin get time stamp...");
                byte[] tsImprint = tsaClient.getMessageDigest().digest(this.digest);
                if (TSAClientBouncyCastle.catchException) {
                    logger.info("get time stamp,if it fails,use local signing time!");
                    tsToken = null;
                    try {
                        tsToken = tsaClient.getTimeStampToken(tsImprint);
                    }
                    catch (Exception e) {
                        tsToken = null;
                        logger.info("try to get time stamp,but no data!");
                    }
                    if (tsToken != null) {
                        unauthAttributes = null;
                        try {
                            unauthAttributes = this.buildUnauthenticatedAttributes(tsToken);
                        }
                        catch (IOException e) {
                            unauthAttributes = null;
                            logger.info("try to get time stamp,but get invalid data!");
                        }
                        if (unauthAttributes != null) {
                            signerinfo.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERSet(unauthAttributes)));
                            logger.info("try to get time stamp,and get valid data!");
                        }
                    }
                } else {
                    tsToken = tsaClient.getTimeStampToken(tsImprint);
                    if (tsToken != null) {
                        try {
                            unauthAttributes = this.buildUnauthenticatedAttributes(tsToken);
                            if (unauthAttributes != null) {
                                signerinfo.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERSet(unauthAttributes)));
                                logger.info("try to get time stamp,and get valid data!");
                            } else {
                                logger.info("try to get time stamp,and get no data or invalid data!");
                                logger.info("use local signing time...");
                            }
                        }
                        catch (IOException e) {
                            logger.info("try to get time stamp,and get no data or invalid data!");
                        }
                    }
                }
                logger.info("end get time stamp...");
            } else {
                logger.info("use local signing time...");
            }
            ASN1EncodableVector body = new ASN1EncodableVector();
            body.add((ASN1Encodable)new ASN1Integer((long)this.version));
            body.add((ASN1Encodable)new DERSet(digestAlgorithms));
            body.add((ASN1Encodable)contentinfo);
            body.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)dercertificates));
            body.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(signerinfo)));
            ASN1EncodableVector whole = new ASN1EncodableVector();
            whole.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DERSequence(body)));
            ByteBuffer bOut = new ByteBuffer();
            ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
            dout.writeObject((ASN1Encodable)new DERSequence(whole));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public ASN1EncodableVector buildUnauthenticatedAttributes(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(timeStampToken));
        ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_TIME_STAMP_TOKEN));
        ASN1Sequence seq = (ASN1Sequence)tempstream.readObject();
        v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
        unauthAttributes.add((ASN1Encodable)new DERSequence(v));
        return unauthAttributes;
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] secondDigest, Calendar signingTime, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            return this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp, crlBytes, sigtype).getEncoded("DER");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public DERSet getAuthenticatedAttributeSet(byte[] secondDigest, Calendar signingTime, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.5"));
            if (signingTime != null) {
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERUTCTime(signingTime.getTime())));
            }
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString(secondDigest)));
            attribute.add((ASN1Encodable)new DERSequence(v));
            boolean haveCrl = false;
            if (crlBytes != null) {
                for (byte[] bCrl : crlBytes) {
                    if (bCrl == null) continue;
                    haveCrl = true;
                    break;
                }
            }
            if (ocsp != null || haveCrl) {
                v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113583.1.1.8"));
                ASN1EncodableVector revocationV = new ASN1EncodableVector();
                if (haveCrl) {
                    ASN1EncodableVector v2 = new ASN1EncodableVector();
                    for (byte[] bCrl : crlBytes) {
                        if (bCrl == null) continue;
                        ASN1InputStream t = new ASN1InputStream((InputStream)new ByteArrayInputStream(bCrl));
                        v2.add((ASN1Encodable)t.readObject());
                    }
                    revocationV.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)));
                }
                if (ocsp != null) {
                    DEROctetString doctet = new DEROctetString(ocsp);
                    ASN1EncodableVector vo1 = new ASN1EncodableVector();
                    ASN1EncodableVector v2 = new ASN1EncodableVector();
                    v2.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                    v2.add((ASN1Encodable)doctet);
                    ASN1Enumerated den = new ASN1Enumerated(0);
                    ASN1EncodableVector v3 = new ASN1EncodableVector();
                    v3.add((ASN1Encodable)den);
                    v3.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)));
                    vo1.add((ASN1Encodable)new DERSequence(v3));
                    revocationV.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(vo1)));
                }
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(revocationV)));
                attribute.add((ASN1Encodable)new DERSequence(v));
            }
            if (sigtype == MakeSignature.CryptoStandard.CADES) {
                v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.47"));
                ASN1EncodableVector aaV2 = new ASN1EncodableVector();
                AlgorithmIdentifier algoId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.digestAlgorithmOid), null);
                aaV2.add((ASN1Encodable)algoId);
                MessageDigest md = this.interfaceDigest.getMessageDigest(this.getHashAlgorithm());
                byte[] dig = md.digest(this.signCert.getEncoded());
                aaV2.add((ASN1Encodable)new DEROctetString(dig));
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERSequence((ASN1Encodable)new DERSequence(aaV2)))));
                attribute.add((ASN1Encodable)new DERSequence(v));
            }
            return new DERSet(attribute);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean verify() throws GeneralSecurityException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (0 == this.signType) {
            if (this.isTsp) {
                TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
                MessageImprint imprint = info.toASN1Structure().getMessageImprint();
                byte[] md = this.messageDigest.digest();
                byte[] imphashed = imprint.getHashedMessage();
                this.verifyResult = Arrays.equals(md, imphashed);
            } else if (this.sigAttr != null || this.sigAttrDer != null) {
                if (this.messageDigest != null) {
                    boolean absentEncContDigestCompare;
                    byte[] msgDigestBytes = this.messageDigest.digest();
                    boolean verifyRSAdata = true;
                    boolean encContDigestCompare = false;
                    if (this.RSAdata != null) {
                        verifyRSAdata = Arrays.equals(msgDigestBytes, this.RSAdata);
                        this.encContDigest.update(this.RSAdata);
                        encContDigestCompare = Arrays.equals(this.encContDigest.digest(), this.digestAttr);
                    }
                    boolean concludingDigestCompare = (absentEncContDigestCompare = Arrays.equals(msgDigestBytes, this.digestAttr)) || encContDigestCompare;
                    boolean sigVerify = this.verifySigAttributes(this.sigAttr) || this.verifySigAttributes(this.sigAttrDer);
                    this.verifyResult = concludingDigestCompare && sigVerify && verifyRSAdata;
                } else {
                    this.verifyResult = this.sig.verify(this.sigAttrDer);
                }
            } else {
                if (this.RSAdata != null) {
                    this.sig.update(this.messageDigest.digest());
                }
                this.verifyResult = this.sig.verify(this.digest);
            }
            this.verified = true;
            return this.verifyResult;
        }
        if (1 == this.signType) {
            byte[] md = this.messageDigest.digest();
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)this.sigAttrDer);
            ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
            ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
            byte[] r = BigIntegerUtil.asUnsigned32ByteArray((BigInteger)R.getPositiveValue());
            byte[] s = BigIntegerUtil.asUnsigned32ByteArray((BigInteger)S.getPositiveValue());
            byte[] signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            BCSoftLib bcLib = new BCSoftLib();
            PublicKey publicKey = this.signCert.getPublicKey();
            try {
                this.verifyResult = bcLib.verifyByHash(new Mechanism("sm3WithSM2Encryption"), publicKey, md, signature);
            }
            catch (PKIException e) {
                return false;
            }
            return this.verifyResult;
        }
        return false;
    }

    private boolean verifySigAttributes(byte[] attr) throws GeneralSecurityException {
        Signature signature = this.initSignature(this.signCert.getPublicKey());
        signature.update(attr);
        return signature.verify(this.digest);
    }

    public boolean verifyTimestampImprint() throws GeneralSecurityException {
        if (this.timeStampToken == null) {
            return false;
        }
        TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
        MessageImprint imprint = info.toASN1Structure().getMessageImprint();
        String algOID = info.getMessageImprintAlgOID().getId();
        byte[] md = new BouncyCastleDigest().getMessageDigest(DigestAlgorithms.getDigest(algOID)).digest(this.digest);
        byte[] imphashed = imprint.getHashedMessage();
        boolean res = Arrays.equals(md, imphashed);
        return res;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new X509Certificate[this.signCerts.size()]);
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    private void signCertificateChain() {
        X509Certificate issuer;
        int k;
        X509Certificate v;
        ArrayList<Certificate> cc = new ArrayList<Certificate>();
        cc.add(this.signCert);
        ArrayList<Certificate> oc = new ArrayList<Certificate>(this.certs);
        for (int k2 = 0; k2 < oc.size(); ++k2) {
            if (!this.signCert.equals(oc.get(k2))) continue;
            oc.remove(k2);
            --k2;
        }
        boolean found = true;
        block5: while (0 == this.signType && found) {
            v = (X509Certificate)cc.get(cc.size() - 1);
            found = false;
            for (k = 0; k < oc.size(); ++k) {
                issuer = (X509Certificate)oc.get(k);
                try {
                    if (this.provider == null) {
                        v.verify(issuer.getPublicKey());
                    } else {
                        v.verify(issuer.getPublicKey(), this.provider);
                    }
                    found = true;
                    cc.add(oc.get(k));
                    oc.remove(k);
                    continue block5;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        block7: while (1 == this.signType && found) {
            v = (PdfX509Certificate)cc.get(cc.size() - 1);
            found = false;
            for (k = 0; k < oc.size(); ++k) {
                issuer = (PdfX509Certificate)oc.get(k);
                try {
                    if (this.provider == null) {
                        ((PdfX509Certificate)v).verify(((PdfX509Certificate)issuer).getPublicKey());
                    } else {
                        ((PdfX509Certificate)v).verify(((PdfX509Certificate)issuer).getPublicKey(), this.provider);
                    }
                    found = true;
                    cc.add(oc.get(k));
                    oc.remove(k);
                    continue block7;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        this.signCerts = cc;
    }

    public Collection<CRL> getCRLs() {
        return this.crls;
    }

    private void findCRL(ASN1Sequence seq) {
        try {
            this.crls = new ArrayList<CRL>();
            for (int k = 0; k < seq.size(); ++k) {
                ByteArrayInputStream ar = new ByteArrayInputStream(seq.getObjectAt(k).toASN1Primitive().getEncoded("DER"));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)cf.generateCRL(ar);
                this.crls.add(crl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.basicResp;
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            X509Certificate[] cs = (X509Certificate[])this.getSignCertificateChain();
            SingleResp sr = this.basicResp.getResponses()[0];
            CertificateID cid = sr.getCertID();
            DigestCalculator digestalg = new JcaDigestCalculatorProviderBuilder().build().get(new AlgorithmIdentifier(cid.getHashAlgOID(), (ASN1Encodable)DERNull.INSTANCE));
            X509Certificate sigcer = this.getSigningCertificate();
            X509Certificate isscer = cs[1];
            CertificateID tis = new CertificateID(digestalg, (X509CertificateHolder)new JcaX509CertificateHolder(isscer), sigcer.getSerialNumber());
            return tis.equals((Object)cid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void findOcsp(ASN1Sequence seq) throws IOException {
        this.basicResp = null;
        boolean ret = false;
        while (!(seq.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)seq.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            ret = true;
            for (int k = 0; k < seq.size(); ++k) {
                if (seq.getObjectAt(k) instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)seq.getObjectAt(0);
                    ret = false;
                    break;
                }
                if (!(seq.getObjectAt(k) instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tag = (ASN1TaggedObject)seq.getObjectAt(k);
                if (tag.getObject() instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)tag.getObject();
                    ret = false;
                    break;
                }
                return;
            }
            if (!ret) continue;
            return;
        }
        ASN1OctetString os = (ASN1OctetString)seq.getObjectAt(1);
        ASN1InputStream inp = new ASN1InputStream(os.getOctets());
        BasicOCSPResponse resp = BasicOCSPResponse.getInstance((Object)inp.readObject());
        this.basicResp = new BasicOCSPResp(resp);
    }

    public boolean isTsp() {
        return this.isTsp;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampToken == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date date = this.timeStampToken.getTimeStampInfo().getGenTime();
        cal.setTime(date);
        return cal;
    }

    public PdfName getFilterSubtype() {
        return this.filterSubtype;
    }

    public String getEncryptionAlgorithm() {
        String encryptAlgo = EncryptionAlgorithms.getAlgorithm(this.digestEncryptionAlgorithmOid);
        if (encryptAlgo == null) {
            encryptAlgo = this.digestEncryptionAlgorithmOid;
        }
        return encryptAlgo;
    }

    public static interface SignType {
        public static final int RSA = 0;
        public static final int SM2 = 1;
    }
}

