/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.crosspage;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.seal.sadk.LocationInfo;
import cfca.seal.sadk.PrePdfReader;
import cfca.seal.sadk.PrePdfSeal;
import cfca.seal.sadk.PrePdfSealExtra;
import cfca.seal.sadk.SignatureLandscape;
import cfca.seal.sadk.crosspage.CroppedImageInfo;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CrossPageStrategy {
    private float accumulated;

    public LocationInfo prepareImages(PrePdfSealExtra prePdfSealExtra, PrePdfReader prePdfReader, int crossPageStyle, int fromPage, int toPage, float startX, float startY) throws IOException, DocumentException {
        PrePdfSealExtra.ImageAppearance imageAppearance = prePdfSealExtra.getImageAppearance();
        PdfReader pdfReader = prePdfReader.getPdfReader();
        int numOfPages = pdfReader.getNumberOfPages();
        if (fromPage <= 0 || toPage <= 0) {
            if (fromPage == -1 && toPage == -1) {
                fromPage = 1;
                toPage = numOfPages;
            } else if (fromPage == -1 && toPage > 0) {
                fromPage = 1;
            } else if (fromPage > 0 && toPage == -1) {
                toPage = numOfPages;
            } else {
                throw new DocumentException("params fromPage and toPage must be positive or -1!");
            }
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        int crossPageSealNum = 0;
        crossPageSealNum = 5 == crossPageStyle || 6 == crossPageStyle ? toPage - fromPage + 1 : (toPage - fromPage) * 2;
        if (crossPageSealNum == 0) {
            throw new DocumentException("Do not sign cross page seal on the same page!");
        }
        LocationInfo locInfo = new LocationInfo();
        Rectangle pageRectDocument = pdfReader.getCropBox(fromPage);
        int rotation = pdfReader.getPageRotation(fromPage);
        if (90 == rotation) {
            pageRectDocument.setRotation(90);
        } else if (270 == rotation) {
            pageRectDocument.setRotation(270);
        }
        if (0 != imageAppearance.getImageCount()) {
            byte[] imageBytes = imageAppearance.getImageAsBytes(0);
            float imageWidth = imageAppearance.getImage(0).getWidth();
            float imageHeight = imageAppearance.getImage(0).getHeight();
            float imageScale = imageAppearance.getImageScale();
            int nextPage = 1;
            this.accumulated = 0.0f;
            for (int i = 0; i < crossPageSealNum; ++i) {
                CroppedImageInfo croppedImageInfo = this.prepareCroppedImage(imageBytes, imageWidth, imageHeight, imageScale, crossPageStyle, crossPageSealNum, i, pageRectDocument, startX, startY);
                imageAppearance.addImage(croppedImageInfo.croppedImageBytes, i + 1, crossPageStyle);
                int currentPage = 0;
                currentPage = 5 == crossPageStyle || 6 == crossPageStyle ? fromPage + i : fromPage + (i + 1) / 2;
                SignatureLandscape signatureLandscape = new SignatureLandscape(new Integer(currentPage), croppedImageInfo.croppedImageCoordinate, 0.0f, 0.0f, null);
                locInfo.addSignature(signatureLandscape);
                if (5 == crossPageStyle || 6 == crossPageStyle) {
                    nextPage = currentPage + 1;
                    if (nextPage <= toPage) {
                        pageRectDocument = pdfReader.getCropBox(nextPage);
                        rotation = pdfReader.getPageRotation(nextPage);
                        if (90 == rotation) {
                            pageRectDocument.setRotation(90);
                            continue;
                        }
                        if (270 != rotation) continue;
                        pageRectDocument.setRotation(270);
                        continue;
                    }
                    break;
                }
                if ((i + 1) % 2 != 1) continue;
                nextPage = currentPage + 1;
                pageRectDocument = pdfReader.getCropBox(nextPage);
                rotation = pdfReader.getPageRotation(nextPage);
                if (90 == rotation) {
                    pageRectDocument.setRotation(90);
                    continue;
                }
                if (270 != rotation) continue;
                pageRectDocument.setRotation(270);
            }
        } else {
            throw new DocumentException("cross page seal requires an image!");
        }
        return locInfo;
    }

    private byte[] croppingImage(byte[] imageBytes, float imageWidth, float imageHeight, float topX, float topY, float croppedWidth, float croppedHeight) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        BufferedImage bufImage = ImageIO.read(bais);
        Image image = bufImage.getScaledInstance((int)imageWidth, (int)imageHeight, 1);
        CropImageFilter cropImageFilter = new CropImageFilter((int)topX, (int)topY, (int)(croppedWidth + 1.0f), (int)(croppedHeight + 1.0f));
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
        BufferedImage tag = new BufferedImage((int)(croppedWidth + 1.0f), (int)(croppedHeight + 1.0f), 2);
        Graphics g = tag.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        ByteBuffer baos = new ByteBuffer();
        ImageIO.write((RenderedImage)tag, "png", baos);
        byte[] croppedImageBytes = baos.toByteArray();
        return croppedImageBytes;
    }

    private Rectangle locatingCroppedImage(Rectangle pageRectDocument, int crossPageStyle, int crossPageSealIndex, float croppedWidth, float croppedHeight, float imageScale, float startX, float startY) throws DocumentException {
        float llx = 0.0f;
        float lly = 0.0f;
        float urx = 0.0f;
        float ury = 0.0f;
        float scaledCroppedImageWidth = croppedWidth * imageScale;
        float scaledCroppedImageHeight = croppedHeight * imageScale;
        Rectangle pageRectViewer = null;
        int rotation = pageRectDocument.getRotation();
        pageRectViewer = 90 == rotation || 270 == rotation ? new Rectangle(pageRectDocument.getTop(), pageRectDocument.getRight()) : pageRectDocument;
        if (1 == crossPageStyle || 3 == crossPageStyle) {
            if (startX <= 0.0f && startX != -1.0f) {
                throw new DocumentException("startX must be positive or -1 in up-down-half or up-down-stripe style cross page seal!");
            }
            if ((double)Math.abs(startX + 1.0f) < 1.0E-4) {
                if (crossPageSealIndex % 2 == 0) {
                    llx = (pageRectViewer.getWidth() - scaledCroppedImageWidth) / 2.0f;
                    lly = 0.0f;
                } else if (crossPageSealIndex % 2 == 1) {
                    llx = (pageRectViewer.getWidth() - scaledCroppedImageWidth) / 2.0f;
                    lly = pageRectViewer.getHeight() - scaledCroppedImageHeight;
                }
            } else if (crossPageSealIndex % 2 == 0) {
                llx = startX;
                lly = 0.0f;
            } else if (crossPageSealIndex % 2 == 1) {
                llx = startX;
                lly = pageRectViewer.getHeight() - scaledCroppedImageHeight;
            }
        } else if (2 == crossPageStyle || 4 == crossPageStyle) {
            if (startY <= 0.0f && startY != -1.0f) {
                throw new DocumentException("startY must be positive or -1 in left-right-half or left-right-stripe style cross page seal!");
            }
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                if (crossPageSealIndex % 2 == 0) {
                    llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                    lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
                } else if (crossPageSealIndex % 2 == 1) {
                    llx = 0.0f;
                    lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
                }
            } else if (crossPageSealIndex % 2 == 0) {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = startY;
            } else if (crossPageSealIndex % 2 == 1) {
                llx = 0.0f;
                lly = startY;
            }
        } else if (5 == crossPageStyle) {
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                llx = 0.0f;
                lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
            } else {
                llx = 0.0f;
                lly = startY;
            }
        } else if (6 == crossPageStyle) {
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
            } else {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = startY;
            }
        } else {
            throw new DocumentException("unsupported cross page style!");
        }
        return new Rectangle(llx, lly, urx, ury);
    }

    private CroppedImageInfo prepareCroppedImage(byte[] imageBytes, float imageWidth, float imageHeight, float imageScale, int crossPageStyle, int crossPageSealNum, int crossPageSealIndex, Rectangle pageRectDocument, float startX, float startY) throws IOException, DocumentException {
        CroppedImageInfo croppedImageInfo = new CroppedImageInfo();
        if (1 == crossPageStyle) {
            float croppedWidth = imageWidth;
            float croppedHeight = imageHeight / 2.0f;
            if (crossPageSealIndex == 0 || crossPageSealIndex == 1) {
                float topX = 0.0f;
                float topY = croppedHeight * (float)(crossPageSealIndex % 2);
                croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, topX, topY, croppedWidth, croppedHeight);
            }
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 3) {
            float croppedWidth = imageWidth;
            float croppedHeight = imageHeight / (float)crossPageSealNum;
            float topX = 0.0f;
            float topY = 0.0f;
            this.accumulated += croppedHeight;
            if (0 < crossPageSealIndex) {
                topY = this.accumulated;
                topY -= croppedHeight;
            }
            croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, topX, topY, croppedWidth, croppedHeight);
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 2) {
            float croppedWidth = imageWidth / 2.0f;
            float croppedHeight = imageHeight;
            if (crossPageSealIndex == 0 || crossPageSealIndex == 1) {
                float topX = croppedWidth * (float)(crossPageSealIndex % 2);
                float topY = 0.0f;
                croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, topX, topY, croppedWidth, croppedHeight);
            }
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 4 || crossPageStyle == 5 || crossPageStyle == 6) {
            float croppedWidth = imageWidth / (float)crossPageSealNum;
            float croppedHeight = imageHeight;
            float topX = 0.0f;
            float topY = 0.0f;
            this.accumulated += croppedWidth;
            if (0 < crossPageSealIndex) {
                topX = this.accumulated;
                topX -= croppedWidth;
            }
            croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, topX, topY, croppedWidth, croppedHeight);
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        throw new DocumentException("unsupported cross page style!");
    }

    public LocationInfo prepareImages(PrePdfSeal prePdfSeal, PrePdfReader prePdfReader, int crossPageStyle, int fromPage, int toPage, float startX, float startY) throws IOException, DocumentException {
        PdfReader pdfReader = prePdfReader.getPdfReader();
        int numOfPages = pdfReader.getNumberOfPages();
        if (fromPage <= 0 || toPage <= 0) {
            if (fromPage == -1 && toPage == -1) {
                fromPage = 1;
                toPage = numOfPages;
            } else if (fromPage == -1 && toPage > 0) {
                fromPage = 1;
            } else if (fromPage > 0 && toPage == -1) {
                toPage = numOfPages;
            } else {
                throw new DocumentException("params fromPage and toPage must be positive or -1!");
            }
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        int crossPageSealNum = 0;
        crossPageSealNum = 5 == crossPageStyle || 6 == crossPageStyle ? toPage - fromPage + 1 : (toPage - fromPage) * 2;
        if (crossPageSealNum == 0) {
            throw new DocumentException("Do not sign cross page seal on the same page!");
        }
        LocationInfo locInfo = new LocationInfo();
        Rectangle pageRectDocument = pdfReader.getCropBox(fromPage);
        int rotation = pdfReader.getPageRotation(fromPage);
        if (90 == rotation) {
            pageRectDocument.setRotation(90);
        } else if (270 == rotation) {
            pageRectDocument.setRotation(270);
        }
        if (0 != prePdfSeal.getImageCount()) {
            byte[] imageBytes = prePdfSeal.getImageAsBytes(0);
            float imageWidth = prePdfSeal.getImage(0).getWidth();
            float imageHeight = prePdfSeal.getImage(0).getHeight();
            float imageScale = prePdfSeal.getImageScale();
            int nextPage = 1;
            this.accumulated = 0.0f;
            for (int i = 0; i < crossPageSealNum; ++i) {
                CroppedImageInfo croppedImageInfo = this.prepareCroppedImage(imageBytes, imageWidth, imageHeight, imageScale, crossPageStyle, crossPageSealNum, i, pageRectDocument, startX, startY);
                prePdfSeal.addImage(croppedImageInfo.croppedImageBytes, i + 1, crossPageStyle);
                int currentPage = 0;
                currentPage = 5 == crossPageStyle || 6 == crossPageStyle ? fromPage + i : fromPage + (i + 1) / 2;
                SignatureLandscape signatureLandscape = new SignatureLandscape(new Integer(currentPage), croppedImageInfo.croppedImageCoordinate, 0.0f, 0.0f, null);
                locInfo.addSignature(signatureLandscape);
                if (5 == crossPageStyle || 6 == crossPageStyle) {
                    nextPage = currentPage + 1;
                    if (nextPage <= toPage) {
                        pageRectDocument = pdfReader.getCropBox(nextPage);
                        rotation = pdfReader.getPageRotation(nextPage);
                        if (90 == rotation) {
                            pageRectDocument.setRotation(90);
                            continue;
                        }
                        if (270 != rotation) continue;
                        pageRectDocument.setRotation(270);
                        continue;
                    }
                    break;
                }
                if ((i + 1) % 2 != 1) continue;
                nextPage = currentPage + 1;
                pageRectDocument = pdfReader.getCropBox(nextPage);
                rotation = pdfReader.getPageRotation(nextPage);
                if (90 == rotation) {
                    pageRectDocument.setRotation(90);
                    continue;
                }
                if (270 != rotation) continue;
                pageRectDocument.setRotation(270);
            }
        } else {
            throw new DocumentException("cross page seal requires an image!");
        }
        return locInfo;
    }
}

