/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.security.external;

import cfca.com.itextpdf.text.io.StreamUtil;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.security.CrlClient;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.com.itextpdf.text.pdf.security.ExternalSignatureContainer;
import cfca.com.itextpdf.text.pdf.security.MakeSignature;
import cfca.com.itextpdf.text.pdf.security.OcspClient;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.com.itextpdf.text.pdf.security.TSAClient;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.cert.PdfX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;

public class DoneExternalSessionSignatureContainer
implements ExternalSignatureContainer {
    private PdfDictionary sigDic;
    private Certificate[] chain;
    private Collection<CrlClient> crlList;
    private OcspClient ocspClient;
    private TSAClient tsaClient;
    private MakeSignature.CryptoStandard cryptoStandard;
    private ExternalSignature externalSignature;
    private ExternalDigest externalDigest;
    private int externalSignatureSize;
    private int deferredType;

    public DoneExternalSessionSignatureContainer(PdfDictionary sigDic) {
        this.sigDic = sigDic;
    }

    public DoneExternalSessionSignatureContainer(PdfName filter, PdfName subFilter) {
        this.sigDic = new PdfDictionary();
        this.sigDic.put(PdfName.FILTER, filter);
        this.sigDic.put(PdfName.SUBFILTER, subFilter);
    }

    public DoneExternalSessionSignatureContainer(PdfName filter, PdfName subFilter, ExternalDigest externalDigest, ExternalSignature externalSignature) {
        this.sigDic = new PdfDictionary();
        this.sigDic.put(PdfName.FILTER, filter);
        this.sigDic.put(PdfName.SUBFILTER, subFilter);
        this.externalDigest = externalDigest;
        this.externalSignature = externalSignature;
    }

    public byte[] sign(InputStream data) throws GeneralSecurityException {
        byte[] encodedSig;
        block28: {
            String encryptionAlgorithm = this.externalSignature.getEncryptionAlgorithm();
            String hashAlgorithm = this.externalSignature.getHashAlgorithm();
            PdfName filterName = this.sigDic.getAsName(PdfName.FILTER);
            PdfName subFilterName = this.sigDic.getAsName(PdfName.SUBFILTER);
            encodedSig = new byte[]{};
            try {
                Collection<byte[]> crlBytes = null;
                int i = 0;
                while (null != this.chain && crlBytes == null && i < this.chain.length) {
                    crlBytes = MakeSignature.processCrl(this.chain[i++], this.crlList);
                }
                if ("RSA".equals(encryptionAlgorithm) && PdfName.ADOBE_PPKLITE.equals(filterName) && (PdfName.ADBE_PKCS7_SHA1.equals(subFilterName) || PdfName.ETSI_CADES_DETACHED.equals(subFilterName) || PdfName.ADBE_PKCS7_DETACHED.equals(subFilterName))) {
                    if (64 == (0x40 & this.deferredType) && 2 == (2 & this.deferredType)) {
                        PdfPKCS7 sgn = new PdfPKCS7(null, this.chain, hashAlgorithm, null, this.externalDigest, false);
                        byte[] hash = DigestAlgorithms.digest(data, this.externalDigest.getMessageDigest(hashAlgorithm));
                        Calendar cal = Calendar.getInstance();
                        byte[] ocsp = null;
                        if (this.chain.length >= 2 && this.ocspClient != null) {
                            ocsp = this.ocspClient.getEncoded((X509Certificate)this.chain[0], (X509Certificate)this.chain[1], null);
                        }
                        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, ocsp, crlBytes, this.cryptoStandard);
                        byte[] extSignature = this.externalSignature.sign(sh);
                        sgn.setExternalDigest(extSignature, null, this.externalSignature.getEncryptionAlgorithm());
                        encodedSig = sgn.getEncodedPKCS7(hash, cal, this.tsaClient, ocsp, crlBytes, this.cryptoStandard);
                    } else if (32 == (0x20 & this.deferredType) && 2 == (2 & this.deferredType)) {
                        byte[] srcBytes = StreamUtil.inputStreamToArray(data);
                        byte[] extSignature = this.externalSignature.sign(srcBytes);
                        BCSoftLib bclib = new BCSoftLib();
                        PKCS7SignedData p7 = new PKCS7SignedData((Session)bclib);
                        X509Cert x509Cert = new X509Cert(this.chain[0].getEncoded());
                        Mechanism mechanism = null;
                        if ("SHA1".equals(hashAlgorithm)) {
                            mechanism = new Mechanism("sha1WithRSAEncryption");
                        } else if ("SHA256".equals(hashAlgorithm)) {
                            mechanism = new Mechanism("sha256WithRSAEncryption");
                        } else if ("SHA512".equals(hashAlgorithm)) {
                            mechanism = new Mechanism("sha512WithRSAEncryption");
                        }
                        encodedSig = p7.packageSignedData(false, null, null, extSignature, mechanism, new X509Cert[]{x509Cert});
                    } else if (32 == (0x20 & this.deferredType) && 4 == (4 & this.deferredType)) {
                        byte[] srcBytes = StreamUtil.inputStreamToArray(data);
                        encodedSig = this.externalSignature.sign(srcBytes);
                    }
                    break block28;
                }
                if ("RSA".equals(encryptionAlgorithm) && PdfName.CFCA_TrustSignPDF.equals(filterName) && PdfName.RSA_BASE64_SHA1.equals(subFilterName)) {
                    PdfPKCS7 sgn = new PdfPKCS7(null, this.chain, hashAlgorithm, null, this.externalDigest, false);
                    byte[] srcBytes = StreamUtil.inputStreamToArray(data);
                    byte[] hash = DigestAlgorithms.digest(new ByteArrayInputStream(srcBytes), this.externalDigest.getMessageDigest(hashAlgorithm));
                    hash = Base64.encode((byte[])hash);
                    byte[] extSignature = this.externalSignature.sign(hash);
                    sgn.setExternalDigest(extSignature, null, this.externalSignature.getEncryptionAlgorithm());
                    encodedSig = sgn.getEncodedPKCS7(hash, null, this.tsaClient, null, null, this.cryptoStandard);
                    break block28;
                }
                if ("SM2".equals(encryptionAlgorithm) && 32 == (0x20 & this.deferredType) && 8 == (8 & this.deferredType)) {
                    byte[] authenticateAttributeBytes = StreamUtil.inputStreamToArray(data);
                    try {
                        Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
                        byte[] signture = this.externalSignature.sign(authenticateAttributeBytes);
                        BCSoftLib bclib = new BCSoftLib();
                        PKCS7SignedData p7 = new PKCS7SignedData((Session)bclib);
                        PdfX509Certificate pdfX509Certificate = (PdfX509Certificate)this.chain[0];
                        if (64 == signture.length) {
                            encodedSig = p7.packageSignedData(false, null, null, signture, mechanism, new X509Cert[]{pdfX509Certificate.getX509Cert()});
                        } else if (signture.length > 64) {
                            byte[] rawSM2SignedBytes = new byte[64];
                            ASN1Sequence seq = ASN1Sequence.getInstance((Object)signture);
                            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
                            byte[] rBytes = r.getValue().toByteArray();
                            if (rBytes.length == 32) {
                                System.arraycopy(rBytes, 0, rawSM2SignedBytes, 0, 32);
                            } else {
                                System.arraycopy(rBytes, 1, rawSM2SignedBytes, 0, 32);
                            }
                            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
                            byte[] sBytes = s.getValue().toByteArray();
                            if (sBytes.length == 32) {
                                System.arraycopy(sBytes, 0, rawSM2SignedBytes, 32, 32);
                            } else {
                                System.arraycopy(sBytes, 1, rawSM2SignedBytes, 32, 32);
                            }
                            encodedSig = p7.packageSignedData(false, null, null, rawSM2SignedBytes, mechanism, new X509Cert[]{pdfX509Certificate.getX509Cert()});
                        }
                        break block28;
                    }
                    catch (PKIException e) {
                        throw new GeneralSecurityException(e.getMessage());
                    }
                }
                if ("SM2".equals(encryptionAlgorithm) && 32 == (0x20 & this.deferredType) && 16 == (0x10 & this.deferredType)) {
                    byte[] authenticateAttributeBytes = StreamUtil.inputStreamToArray(data);
                    encodedSig = this.externalSignature.sign(authenticateAttributeBytes);
                }
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
            catch (PKIException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        }
        return encodedSig;
    }

    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.putAll(this.sigDic);
    }

    public void setTSAClient(TSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public void setCryptoStandard(MakeSignature.CryptoStandard cryptoStandard) {
        this.cryptoStandard = cryptoStandard;
    }

    public void setCertificateChain(Certificate[] chain) {
        this.chain = chain;
    }

    public void setDeferredType(int deferredType) {
        this.deferredType = deferredType;
    }

    public int getExternalSignatureSize() {
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (null != this.chain && crlBytes == null && i < this.chain.length) {
            crlBytes = MakeSignature.processCrl(this.chain[i++], this.crlList);
        }
        if (this.externalSignatureSize == 0) {
            this.externalSignatureSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    this.externalSignatureSize += element.length + 10;
                }
            }
            if (this.ocspClient != null) {
                this.externalSignatureSize += 4192;
            }
            if (this.tsaClient != null) {
                this.externalSignatureSize += 4192;
            }
        }
        return this.externalSignatureSize;
    }
}

