/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4;

import java.util.Collections;
import java.util.Map;

public class QLOptions {
    public static QLOptions DEFAULT_OPTIONS = QLOptions.builder().build();
    private final boolean precise;
    private final boolean polluteUserContext;
    private final long timeoutMillis;
    private final Map<String, Object> attachments;
    private final boolean cache;
    private final boolean avoidNullPointer;
    private final int maxArrLength;
    private final boolean traceExpression;
    private final boolean shortCircuitDisable;

    private QLOptions(boolean precise, boolean polluteUserContext, long timeoutMillis, Map<String, Object> attachments, boolean cache, boolean avoidNullPointer, int maxArrLength, boolean traceExpression, boolean shortCircuitDisable) {
        this.precise = precise;
        this.polluteUserContext = polluteUserContext;
        this.timeoutMillis = timeoutMillis;
        this.attachments = attachments;
        this.cache = cache;
        this.avoidNullPointer = avoidNullPointer;
        this.maxArrLength = maxArrLength;
        this.traceExpression = traceExpression;
        this.shortCircuitDisable = shortCircuitDisable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPrecise() {
        return this.precise;
    }

    public boolean isPolluteUserContext() {
        return this.polluteUserContext;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public boolean isCache() {
        return this.cache;
    }

    public boolean isAvoidNullPointer() {
        return this.avoidNullPointer;
    }

    public int getMaxArrLength() {
        return this.maxArrLength;
    }

    public boolean checkArrLen(int newArrLen) {
        return this.maxArrLength == -1 || newArrLen <= this.maxArrLength;
    }

    public boolean isTraceExpression() {
        return this.traceExpression;
    }

    public boolean isShortCircuitDisable() {
        return this.shortCircuitDisable;
    }

    public static class Builder {
        private boolean precise = false;
        private boolean polluteUserContext = false;
        private long timeoutMillis = -1L;
        private Map<String, Object> attachments = Collections.emptyMap();
        private boolean cache = false;
        private boolean avoidNullPointer = false;
        private int maxArrLength = -1;
        private boolean traceExpression = false;
        private boolean shortCircuitDisable = false;

        public Builder precise(boolean precise) {
            this.precise = precise;
            return this;
        }

        public Builder polluteUserContext(boolean polluteUserContext) {
            this.polluteUserContext = polluteUserContext;
            return this;
        }

        public Builder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder attachments(Map<String, Object> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder cache(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder avoidNullPointer(boolean avoidNullPointer) {
            this.avoidNullPointer = avoidNullPointer;
            return this;
        }

        public Builder maxArrLength(int maxArrLength) {
            this.maxArrLength = maxArrLength;
            return this;
        }

        public Builder traceExpression(boolean traceExpression) {
            this.traceExpression = traceExpression;
            return this;
        }

        public Builder shortCircuitDisable(boolean shortCircuitDisable) {
            this.shortCircuitDisable = shortCircuitDisable;
            return this;
        }

        public QLOptions build() {
            return new QLOptions(this.precise, this.polluteUserContext, this.timeoutMillis, this.attachments, this.cache, this.avoidNullPointer, this.maxArrLength, this.traceExpression, this.shortCircuitDisable);
        }
    }
}

