/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.aparser.MacroDefine;
import java.util.HashMap;
import java.util.Map;

public class GeneratorScope {
    private final GeneratorScope parent;
    private final String name;
    private final Map<String, MacroDefine> macroDefineMap;

    public GeneratorScope(GeneratorScope parent, String name, Map<String, MacroDefine> macroDefineMap) {
        this.parent = parent;
        this.name = name;
        this.macroDefineMap = macroDefineMap;
    }

    public GeneratorScope(String name, GeneratorScope parent) {
        this.parent = parent;
        this.name = name;
        this.macroDefineMap = new HashMap<String, MacroDefine>();
    }

    public boolean defineMacroIfAbsent(String name, MacroDefine macroDefine) {
        return this.macroDefineMap.putIfAbsent(name, macroDefine) == null;
    }

    public void defineMacro(String name, MacroDefine macroDefine) {
        this.macroDefineMap.put(name, macroDefine);
    }

    public MacroDefine getMacroInstructions(String macroName) {
        MacroDefine qlInstructions = this.macroDefineMap.get(macroName);
        return qlInstructions != null ? qlInstructions : (this.parent != null ? this.parent.getMacroInstructions(macroName) : null);
    }

    public String getName() {
        return this.name;
    }
}

