/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.DefaultClassSupplier;
import com.alibaba.qlexpress4.InitOptions;
import com.alibaba.qlexpress4.a4runtime.ParserRuleContext;
import com.alibaba.qlexpress4.a4runtime.RuleContext;
import com.alibaba.qlexpress4.a4runtime.Token;
import com.alibaba.qlexpress4.a4runtime.tree.ParseTree;
import com.alibaba.qlexpress4.a4runtime.tree.TerminalNode;
import com.alibaba.qlexpress4.aparser.BuiltInTypesSet;
import com.alibaba.qlexpress4.aparser.GeneratorScope;
import com.alibaba.qlexpress4.aparser.ImportManager;
import com.alibaba.qlexpress4.aparser.InterpolationMode;
import com.alibaba.qlexpress4.aparser.MacroDefine;
import com.alibaba.qlexpress4.aparser.OperatorFactory;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.QLParserBaseVisitor;
import com.alibaba.qlexpress4.aparser.compiletimefunction.CodeGenerator;
import com.alibaba.qlexpress4.aparser.compiletimefunction.CompileTimeFunction;
import com.alibaba.qlexpress4.exception.DefaultErrReporter;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.PureErrReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLException;
import com.alibaba.qlexpress4.exception.QLSyntaxException;
import com.alibaba.qlexpress4.runtime.MetaClass;
import com.alibaba.qlexpress4.runtime.QLambdaDefinition;
import com.alibaba.qlexpress4.runtime.QLambdaDefinitionEmpty;
import com.alibaba.qlexpress4.runtime.QLambdaDefinitionInner;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.instruction.BreakContinueInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CallConstInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CallFunctionInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CallInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CastInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CheckTimeOutInstruction;
import com.alibaba.qlexpress4.runtime.instruction.CloseScopeInstruction;
import com.alibaba.qlexpress4.runtime.instruction.ConstInstruction;
import com.alibaba.qlexpress4.runtime.instruction.DefineFunctionInstruction;
import com.alibaba.qlexpress4.runtime.instruction.DefineLocalInstruction;
import com.alibaba.qlexpress4.runtime.instruction.ForEachInstruction;
import com.alibaba.qlexpress4.runtime.instruction.ForInstruction;
import com.alibaba.qlexpress4.runtime.instruction.GetFieldInstruction;
import com.alibaba.qlexpress4.runtime.instruction.GetMethodInstruction;
import com.alibaba.qlexpress4.runtime.instruction.IndexInstruction;
import com.alibaba.qlexpress4.runtime.instruction.JumpIfInstruction;
import com.alibaba.qlexpress4.runtime.instruction.JumpIfPopInstruction;
import com.alibaba.qlexpress4.runtime.instruction.JumpInstruction;
import com.alibaba.qlexpress4.runtime.instruction.LoadInstruction;
import com.alibaba.qlexpress4.runtime.instruction.LoadLambdaInstruction;
import com.alibaba.qlexpress4.runtime.instruction.MethodInvokeInstruction;
import com.alibaba.qlexpress4.runtime.instruction.MultiNewArrayInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewArrayInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewFilledInstanceInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewInstanceInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewListInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewMapInstruction;
import com.alibaba.qlexpress4.runtime.instruction.NewScopeInstruction;
import com.alibaba.qlexpress4.runtime.instruction.OperatorInstruction;
import com.alibaba.qlexpress4.runtime.instruction.PopInstruction;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.instruction.ReturnInstruction;
import com.alibaba.qlexpress4.runtime.instruction.SliceInstruction;
import com.alibaba.qlexpress4.runtime.instruction.SpreadGetFieldInstruction;
import com.alibaba.qlexpress4.runtime.instruction.SpreadMethodInvokeInstruction;
import com.alibaba.qlexpress4.runtime.instruction.StringJoinInstruction;
import com.alibaba.qlexpress4.runtime.instruction.ThrowInstruction;
import com.alibaba.qlexpress4.runtime.instruction.TraceEvaludatedInstruction;
import com.alibaba.qlexpress4.runtime.instruction.TracePeekInstruction;
import com.alibaba.qlexpress4.runtime.instruction.TryCatchInstruction;
import com.alibaba.qlexpress4.runtime.instruction.UnaryInstruction;
import com.alibaba.qlexpress4.runtime.instruction.WhileInstruction;
import com.alibaba.qlexpress4.runtime.operator.BinaryOperator;
import com.alibaba.qlexpress4.runtime.operator.OperatorManager;
import com.alibaba.qlexpress4.runtime.operator.unary.UnaryOperator;
import com.alibaba.qlexpress4.utils.QLStringUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QvmInstructionVisitor
extends QLParserBaseVisitor<Void> {
    private static final String SCOPE_SEPARATOR = "$";
    private static final String BLOCK_LAMBDA_NAME_PREFIX = "BLOCK_";
    private static final String IF_PREFIX = "IF_";
    private static final String THEN_SUFFIX = "_THEN";
    private static final String ELSE_SUFFIX = "_ELSE";
    private static final String MACRO_PREFIX = "MACRO_";
    private static final String LAMBDA_PREFIX = "LAMBDA_";
    private static final String TRY_PREFIX = "TRY_";
    private static final String CATCH_SUFFIX = "_CATCH";
    private static final String FINAL_SUFFIX = "_FINAL";
    private static final String FOR_PREFIX = "FOR_";
    private static final String INIT_SUFFIX = "_INIT";
    private static final String CONDITION_SUFFIX = "_CONDITION";
    private static final String UPDATE_SUFFIX = "_UPDATE";
    private static final String BODY_SUFFIX = "_BODY";
    private static final String WHILE_PREFIX = "WHILE_";
    private static final String LBRACE = "{";
    private static final String RBRACE = "}";
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MAX_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MAX_DOUBLE = new BigDecimal(String.valueOf(Double.MAX_VALUE));
    private static final int TIMEOUT_CHECK_GAP = 5;
    private final String script;
    private final ImportManager importManager;
    private final GeneratorScope generatorScope;
    private final OperatorFactory operatorFactory;
    private final Map<String, CompileTimeFunction> compileTimeFunctions;
    private final InitOptions initOptions;
    private final Context context;
    private final List<QLInstruction> instructionList = new ArrayList<QLInstruction>();
    private int stackSize;
    private int maxStackSize;
    private int ifCounter = 0;
    private int blockCounter = 0;
    private int macroCounter = 0;
    private int lambdaCounter = 0;
    private int tryCounter = 0;
    private int forCounter = 0;
    private int whileCounter = 0;
    private int timeoutCheckPoint = -1;

    public QvmInstructionVisitor(String script, ImportManager importManager, GeneratorScope globalScope, OperatorFactory operatorFactory, Map<String, CompileTimeFunction> compileTimeFunctions, InitOptions initOptions) {
        this.script = script;
        this.importManager = importManager;
        this.generatorScope = new GeneratorScope("main", globalScope);
        this.operatorFactory = operatorFactory;
        this.context = Context.BLOCK;
        this.compileTimeFunctions = compileTimeFunctions;
        this.initOptions = initOptions;
    }

    public QvmInstructionVisitor(String script, ImportManager importManager, GeneratorScope generatorScope, OperatorFactory operatorFactory, Context context, Map<String, CompileTimeFunction> compileTimeFunctions, InitOptions initOptions) {
        this.script = script;
        this.importManager = importManager;
        this.generatorScope = generatorScope;
        this.operatorFactory = operatorFactory;
        this.context = context;
        this.compileTimeFunctions = compileTimeFunctions;
        this.initOptions = initOptions;
    }

    public QvmInstructionVisitor(String script) {
        this.script = script;
        this.importManager = new ImportManager(DefaultClassSupplier.getInstance(), new ArrayList<ImportManager.QLImport>(), new HashMap());
        this.generatorScope = new GeneratorScope("test-main", null);
        this.operatorFactory = new OperatorManager();
        this.context = Context.BLOCK;
        this.compileTimeFunctions = new HashMap<String, CompileTimeFunction>();
        this.initOptions = InitOptions.DEFAULT_OPTIONS;
    }

    @Override
    public Void visitImportCls(QLParser.ImportClsContext ctx) {
        String importClsPath = ctx.varId().stream().map(ParserRuleContext::getStart).map(Token::getText).collect(Collectors.joining("."));
        this.importManager.addImport(ImportManager.importCls(importClsPath));
        return null;
    }

    @Override
    public Void visitImportPack(QLParser.ImportPackContext ctx) {
        List<QLParser.VarIdContext> importPackPathTokens = ctx.varId();
        boolean isInnerCls = !Character.isLowerCase(importPackPathTokens.get(importPackPathTokens.size() - 1).getText().charAt(0));
        String importPath = importPackPathTokens.stream().map(ParserRuleContext::getStart).map(Token::getText).collect(Collectors.joining("."));
        this.importManager.addImport(isInnerCls ? ImportManager.importInnerCls(importPath) : ImportManager.importPack(importPath));
        return null;
    }

    @Override
    public Void visitBlockStatements(QLParser.BlockStatementsContext blockStatementsContext) {
        boolean isPreExpress = false;
        List nonEmptyChildren = blockStatementsContext.blockStatement().stream().filter(bs -> !(bs instanceof QLParser.EmptyStatementContext)).collect(Collectors.toList());
        for (QLParser.BlockStatementContext child : nonEmptyChildren) {
            if (!(child instanceof QLParser.MacroStatementContext)) continue;
            child.accept(this);
        }
        for (QLParser.BlockStatementContext child : nonEmptyChildren) {
            if (!(child instanceof QLParser.FunctionStatementContext)) continue;
            child.accept(this);
        }
        for (QLParser.BlockStatementContext child : nonEmptyChildren) {
            if (child instanceof QLParser.FunctionStatementContext || child instanceof QLParser.MacroStatementContext) continue;
            if (isPreExpress) {
                this.addInstruction(new PopInstruction(PureErrReporter.INSTANCE));
            }
            isPreExpress = this.handleStmt(child);
        }
        if (this.context == Context.BLOCK && isPreExpress) {
            this.addInstruction(new ReturnInstruction(PureErrReporter.INSTANCE, QResult.ResultType.CONTINUE, null));
        }
        return null;
    }

    private void visitBodyExpression(QLParser.ExpressionContext expressionContext) {
        QLParser.BlockExprContext blockExprContext = this.blockExpr(expressionContext);
        if (blockExprContext != null) {
            QLParser.BlockStatementsContext blockStatementsContext = blockExprContext.blockStatements();
            if (blockStatementsContext == null) {
                return;
            }
            blockStatementsContext.accept(this);
            return;
        }
        expressionContext.accept(this);
        this.addInstruction(new ReturnInstruction(this.newReporterWithToken(expressionContext.getStart()), QResult.ResultType.RETURN, null));
    }

    private QLParser.BlockExprContext blockExpr(QLParser.ExpressionContext expressionContext) {
        Token startToken = expressionContext.getStart();
        Token stopToken = expressionContext.getStop();
        if (!LBRACE.equals(startToken.getText()) || !RBRACE.equals(stopToken.getText())) {
            return null;
        }
        QLParser.TernaryExprContext ternaryExprContext = expressionContext.ternaryExpr();
        if (ternaryExprContext == null) {
            return null;
        }
        if (ternaryExprContext.QUESTION() != null) {
            return null;
        }
        QLParser.BaseExprContext baseExprContext = ternaryExprContext.baseExpr(0);
        if (!baseExprContext.leftAsso().isEmpty()) {
            return null;
        }
        QLParser.PrimaryContext primaryContext = baseExprContext.primary();
        if (primaryContext.primaryNoFixNonPathable() != null) {
            return null;
        }
        QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext = primaryContext.primaryNoFixPathable();
        return primaryNoFixPathableContext instanceof QLParser.BlockExprContext ? (QLParser.BlockExprContext)primaryNoFixPathableContext : null;
    }

    @Override
    public Void visitExpression(QLParser.ExpressionContext ctx) {
        QLParser.TernaryExprContext ternaryExprContext = ctx.ternaryExpr();
        if (ternaryExprContext != null) {
            ternaryExprContext.accept(this);
            return null;
        }
        ctx.leftHandSide().accept(this);
        ctx.expression().accept(this);
        QLParser.AssignOperatorContext assignOperatorContext = ctx.assignOperator();
        BinaryOperator assignOperator = this.operatorFactory.getBinaryOperator(assignOperatorContext.getText());
        this.addInstruction(new OperatorInstruction(this.newReporterWithToken(assignOperatorContext.getStart()), assignOperator, assignOperatorContext.getStart().getStartIndex()));
        return null;
    }

    @Override
    public Void visitTraditionalForStatement(QLParser.TraditionalForStatementContext ctx) {
        int forCount = this.forCount();
        ErrorReporter forErrReporter = this.newReporterWithToken(ctx.FOR().getSymbol());
        QLParser.ForInitContext forInitContext = ctx.forInit();
        QLambdaDefinitionInner forInitLambda = forInitContext == null ? null : this.generateForInitLambda(forCount, forInitContext);
        QLParser.ExpressionContext forConditionContext = ctx.forCondition;
        QLambdaDefinitionInner forConditionLambda = forConditionContext == null ? null : this.generateForExpressLambda(forCount, CONDITION_SUFFIX, forConditionContext);
        QLParser.ExpressionContext forUpdateContext = ctx.forUpdate;
        QLambdaDefinitionInner forUpdateLambda = forUpdateContext == null ? null : this.generateForExpressLambda(forCount, UPDATE_SUFFIX, forUpdateContext);
        QLambdaDefinition forBodyLambda = this.loopBodyVisitorDefinition(ctx.blockStatements(), this.generatorScope.getName() + SCOPE_SEPARATOR + FOR_PREFIX + forCount + BODY_SUFFIX, Collections.emptyList(), forErrReporter);
        int forInitSize = forInitLambda == null ? 0 : forInitLambda.getMaxStackSize();
        int forConditionSize = forConditionLambda == null ? 0 : forConditionLambda.getMaxStackSize();
        int forUpdateSize = forUpdateLambda == null ? 0 : forUpdateLambda.getMaxStackSize();
        int forScopeMaxStackSize = Math.max(forInitSize, Math.max(forConditionSize, forUpdateSize));
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(forErrReporter, ctx.FOR().getSymbol().getStartIndex()));
        }
        this.addInstruction(new ForInstruction(forErrReporter, forInitLambda, forConditionLambda, forConditionContext != null ? this.newReporterWithToken(forConditionContext.getStart()) : null, forUpdateLambda, forScopeMaxStackSize, forBodyLambda));
        return null;
    }

    private QLambdaDefinitionInner generateForInitLambda(int forCount, QLParser.ForInitContext forInitContext) {
        if (forInitContext.localVariableDeclaration() != null) {
            String scopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + FOR_PREFIX + forCount + INIT_SUFFIX;
            QvmInstructionVisitor subVisitor = this.parseWithSubVisitor(forInitContext.localVariableDeclaration(), new GeneratorScope(scopeName, this.generatorScope), Context.MACRO);
            return new QLambdaDefinitionInner(scopeName, subVisitor.getInstructions(), Collections.emptyList(), subVisitor.getMaxStackSize());
        }
        if (forInitContext.expression() != null) {
            return this.generateForExpressLambda(forCount, INIT_SUFFIX, forInitContext.expression());
        }
        return null;
    }

    private QLambdaDefinitionInner generateForExpressLambda(int forCount, String scopeSuffix, QLParser.ExpressionContext expressionContext) {
        String scopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + FOR_PREFIX + forCount + scopeSuffix;
        QvmInstructionVisitor subVisitor = this.parseExprBodyWithSubVisitor(expressionContext, new GeneratorScope(scopeName, this.generatorScope), Context.BLOCK);
        return new QLambdaDefinitionInner(scopeName, subVisitor.getInstructions(), Collections.emptyList(), subVisitor.getMaxStackSize());
    }

    @Override
    public Void visitForEachStatement(QLParser.ForEachStatementContext ctx) {
        QLParser.ExpressionContext targetExprContext = ctx.expression();
        targetExprContext.accept(this);
        QLParser.DeclTypeContext declTypeContext = ctx.declType();
        Class<Object> itVarCls = declTypeContext == null ? Object.class : this.parseDeclType(declTypeContext);
        ErrorReporter forEachErrReporter = this.newReporterWithToken(ctx.FOR().getSymbol());
        QLambdaDefinition bodyDefinition = this.loopBodyVisitorDefinition(ctx.blockStatements(), this.generatorScope.getName() + SCOPE_SEPARATOR + FOR_PREFIX + this.forCount() + BODY_SUFFIX, Collections.singletonList(new QLambdaDefinitionInner.Param(ctx.varId().getText(), itVarCls)), forEachErrReporter);
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(forEachErrReporter, ctx.FOR().getSymbol().getStartIndex()));
        }
        this.addInstruction(new ForEachInstruction(forEachErrReporter, bodyDefinition, itVarCls, this.newReporterWithToken(targetExprContext.getStart())));
        return null;
    }

    @Override
    public Void visitWhileStatement(QLParser.WhileStatementContext ctx) {
        int whileCount = this.whileCount();
        String whileConditionScope = this.generatorScope.getName() + SCOPE_SEPARATOR + WHILE_PREFIX + whileCount + CONDITION_SUFFIX;
        QvmInstructionVisitor conditionSubVisitor = this.parseExprBodyWithSubVisitor(ctx.expression(), new GeneratorScope(whileConditionScope, this.generatorScope), Context.BLOCK);
        QLambdaDefinitionInner conditionLambda = new QLambdaDefinitionInner(whileConditionScope, conditionSubVisitor.getInstructions(), Collections.emptyList(), conditionSubVisitor.getMaxStackSize());
        ErrorReporter whileErrReporter = this.newReporterWithToken(ctx.WHILE().getSymbol());
        QLambdaDefinition whileBodyLambda = this.loopBodyVisitorDefinition(ctx.blockStatements(), this.generatorScope.getName() + SCOPE_SEPARATOR + WHILE_PREFIX + whileCount + BODY_SUFFIX, Collections.emptyList(), whileErrReporter);
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(whileErrReporter, ctx.WHILE().getSymbol().getStartIndex()));
        }
        this.addInstruction(new WhileInstruction(whileErrReporter, conditionLambda, whileBodyLambda, whileBodyLambda instanceof QLambdaDefinitionInner ? Math.max(conditionLambda.getMaxStackSize(), ((QLambdaDefinitionInner)whileBodyLambda).getMaxStackSize()) : conditionLambda.getMaxStackSize()));
        return null;
    }

    private QLambdaDefinition loopBodyVisitorDefinition(QLParser.BlockStatementsContext bodyCtx, String scopeName, List<QLambdaDefinitionInner.Param> paramsType, ErrorReporter errorReporter) {
        if (bodyCtx == null) {
            return QLambdaDefinitionEmpty.INSTANCE;
        }
        QvmInstructionVisitor bodyVisitor = this.parseWithSubVisitor(bodyCtx, new GeneratorScope(scopeName, this.generatorScope), Context.MACRO);
        List<QLInstruction> bodyInstructions = bodyVisitor.getInstructions();
        ArrayList<QLInstruction> resultInstructions = new ArrayList<QLInstruction>();
        resultInstructions.add(new CheckTimeOutInstruction(errorReporter));
        resultInstructions.addAll(bodyInstructions);
        return new QLambdaDefinitionInner(scopeName, resultInstructions, paramsType, bodyVisitor.getMaxStackSize());
    }

    @Override
    public Void visitThrowStatement(QLParser.ThrowStatementContext ctx) {
        ctx.expression().accept(this);
        this.addInstruction(new ThrowInstruction(this.newReporterWithToken(ctx.THROW().getSymbol())));
        return null;
    }

    @Override
    public Void visitReturnStatement(QLParser.ReturnStatementContext ctx) {
        ErrorReporter errorReporter = this.newReporterWithToken(ctx.getStart());
        QLParser.ExpressionContext expression = ctx.expression();
        if (expression == null) {
            this.addInstruction(new ConstInstruction(errorReporter, null, null));
        } else {
            expression.accept(this);
        }
        this.addInstruction(new ReturnInstruction(errorReporter, QResult.ResultType.RETURN, ctx.getStart().getStartIndex()));
        return null;
    }

    @Override
    public Void visitFunctionStatement(QLParser.FunctionStatementContext ctx) {
        QLParser.FormalOrInferredParameterListContext formalOrInferredParameterList = ctx.formalOrInferredParameterList();
        List<QLambdaDefinitionInner.Param> params = formalOrInferredParameterList == null ? Collections.emptyList() : this.parseFormalOrInferredParameterList(formalOrInferredParameterList);
        QLParser.VarIdContext functionNameCtx = ctx.varId();
        QLambdaDefinition functionDefinition = this.parseFunctionDefinition(functionNameCtx.getText(), ctx, params);
        ErrorReporter errorReporter = this.newReporterWithToken(functionNameCtx.getStart());
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(errorReporter, functionNameCtx.getStart().getStartIndex()));
        }
        this.addInstruction(new DefineFunctionInstruction(errorReporter, functionDefinition.getName(), functionDefinition));
        return null;
    }

    private QLambdaDefinition parseFunctionDefinition(String functionName, QLParser.FunctionStatementContext ctx, List<QLambdaDefinitionInner.Param> params) {
        QLParser.BlockStatementsContext blockStatementsContext = ctx.blockStatements();
        if (blockStatementsContext == null) {
            return new QLambdaDefinitionInner(functionName, Collections.emptyList(), params, 0);
        }
        QvmInstructionVisitor functionSubVisitor = this.parseWithSubVisitor(blockStatementsContext, new GeneratorScope(functionName, this.generatorScope), Context.BLOCK);
        return new QLambdaDefinitionInner(functionName, functionSubVisitor.getInstructions(), params, functionSubVisitor.getMaxStackSize());
    }

    @Override
    public Void visitCastExpr(QLParser.CastExprContext ctx) {
        QLParser.DeclTypeContext castDeclTypeContext = ctx.declType();
        Class<?> castCls = this.parseDeclType(castDeclTypeContext);
        ErrorReporter errorReporter = this.newReporterWithToken(castDeclTypeContext.getStart());
        this.addInstruction(new ConstInstruction(errorReporter, castCls, null));
        ctx.primary().accept(this);
        this.addInstruction(new CastInstruction(errorReporter));
        return null;
    }

    @Override
    public Void visitTernaryExpr(QLParser.TernaryExprContext ctx) {
        ctx.condition.accept(this);
        if (ctx.QUESTION() != null) {
            QvmInstructionVisitor thenVisitor = this.parseWithSubVisitor(ctx.thenExpr, this.generatorScope, Context.MACRO);
            QvmInstructionVisitor elseVisitor = this.parseWithSubVisitor(ctx.elseExpr, this.generatorScope, Context.MACRO);
            this.ifElseInstructions(this.newReporterWithToken(ctx.QUESTION().getSymbol()), thenVisitor.getInstructions(), null, elseVisitor.getInstructions(), null, ctx.QUESTION().getSymbol().getStartIndex());
        }
        return null;
    }

    @Override
    public Void visitBlockExpr(QLParser.BlockExprContext ctx) {
        ErrorReporter blockErrReporter = this.newReporterWithToken(ctx.getStart());
        QLParser.BlockStatementsContext blockStatementsContext = ctx.blockStatements();
        if (blockStatementsContext == null) {
            this.addInstruction(new ConstInstruction(blockErrReporter, null, null));
            return null;
        }
        String blockScopeName = this.blockScopeName();
        QvmInstructionVisitor blockSubVisitor = this.parseWithSubVisitor(blockStatementsContext, new GeneratorScope(blockScopeName, this.generatorScope), Context.MACRO);
        this.addInstruction(new NewScopeInstruction(blockErrReporter, blockScopeName));
        blockSubVisitor.getInstructions().forEach(this::addInstruction);
        this.addInstruction(new CloseScopeInstruction(blockErrReporter, blockScopeName));
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TracePeekInstruction(blockErrReporter, ctx.getStart().getStartIndex()));
        }
        return null;
    }

    @Override
    public Void visitQlIf(QLParser.QlIfContext qlIfContext) {
        List<QLInstruction> elseInstructions;
        qlIfContext.condition.accept(this);
        int ifCount = this.ifCount();
        ErrorReporter ifErrorReporter = this.newReporterWithToken(qlIfContext.IF().getSymbol());
        String ifScopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + IF_PREFIX + ifCount;
        this.addInstruction(new NewScopeInstruction(ifErrorReporter, ifScopeName));
        String thenScopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + IF_PREFIX + ifCount + THEN_SUFFIX;
        QLParser.ThenBodyContext thenBodyContext = qlIfContext.thenBody();
        List<QLInstruction> thenInstructions = this.parseWithSubVisitor(thenBodyContext, new GeneratorScope(thenScopeName, this.generatorScope), Context.MACRO).getInstructions();
        if (this.ifBodyFillConst(thenBodyContext.expression(), thenBodyContext.blockStatement(), thenBodyContext.blockStatements())) {
            thenInstructions.add(new ConstInstruction(ifErrorReporter, null, null));
        }
        Integer thenTraceKey = thenBodyContext.LBRACE() == null ? null : Integer.valueOf(thenBodyContext.getStart().getStartIndex());
        String elseScopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + IF_PREFIX + ifCount + ELSE_SUFFIX;
        QLParser.ElseBodyContext elseBodyContext = qlIfContext.elseBody();
        List<QLInstruction> list = elseInstructions = elseBodyContext == null ? Collections.singletonList(new ConstInstruction(ifErrorReporter, null, null)) : this.parseWithSubVisitor(elseBodyContext, new GeneratorScope(elseScopeName, this.generatorScope), Context.MACRO).getInstructions();
        if (elseBodyContext != null && elseBodyContext.qlIf() == null && this.ifBodyFillConst(elseBodyContext.expression(), elseBodyContext.blockStatement(), elseBodyContext.blockStatements())) {
            elseInstructions.add(new ConstInstruction(ifErrorReporter, null, null));
        }
        Integer elseTraceKey = elseBodyContext == null ? null : (elseBodyContext.LBRACE() == null ? null : Integer.valueOf(elseBodyContext.getStart().getStartIndex()));
        this.ifElseInstructions(ifErrorReporter, thenInstructions, thenTraceKey, elseInstructions, elseTraceKey, qlIfContext.getStart().getStartIndex());
        this.addInstruction(new CloseScopeInstruction(ifErrorReporter, ifScopeName));
        return null;
    }

    private boolean ifBodyFillConst(QLParser.ExpressionContext expressionContext, QLParser.BlockStatementContext blockStatementContext, QLParser.BlockStatementsContext blockStatementsContext) {
        if (expressionContext != null) {
            return false;
        }
        if (blockStatementContext != null) {
            return this.stmtFillConst(blockStatementContext);
        }
        if (blockStatementsContext != null) {
            List statementList = blockStatementsContext.blockStatement().stream().filter(bs -> !(bs instanceof QLParser.EmptyStatementContext)).collect(Collectors.toList());
            return statementList.isEmpty() || this.stmtFillConst((QLParser.BlockStatementContext)statementList.get(statementList.size() - 1));
        }
        return true;
    }

    private boolean stmtFillConst(QLParser.BlockStatementContext blockStatementContext) {
        return !(blockStatementContext instanceof QLParser.ExpressionStatementContext) && !(blockStatementContext instanceof QLParser.ReturnStatementContext);
    }

    @Override
    public Void visitBreakContinueStatement(QLParser.BreakContinueStatementContext ctx) {
        QResult qResult;
        TerminalNode aBreak = ctx.BREAK();
        QResult qResult2 = qResult = aBreak == null ? QResult.LOOP_CONTINUE_RESULT : QResult.LOOP_BREAK_RESULT;
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(this.newReporterWithToken(ctx.getStart()), ctx.getStart().getStartIndex()));
        }
        this.addInstruction(new BreakContinueInstruction(this.newReporterWithToken(ctx.getStart()), qResult));
        return null;
    }

    @Override
    public Void visitListExpr(QLParser.ListExprContext ctx) {
        this.visitListExprInner(ctx.listItems(), this.newReporterWithToken(ctx.getStart()));
        return null;
    }

    private void visitListExprInner(QLParser.ListItemsContext listItemsContext, ErrorReporter listErrorReporter) {
        if (listItemsContext == null) {
            this.addInstruction(new NewListInstruction(listErrorReporter, 0));
            return;
        }
        List<QLParser.ExpressionContext> expressions = listItemsContext.expression();
        for (QLParser.ExpressionContext expression : expressions) {
            expression.accept(this);
        }
        this.addInstruction(new NewListInstruction(listErrorReporter, expressions.size()));
    }

    @Override
    public Void visitMapExpr(QLParser.MapExprContext ctx) {
        QLParser.MapEntriesContext mapEntriesContext = ctx.mapEntries();
        List<QLParser.MapEntryContext> mapEntryContexts = mapEntriesContext.mapEntry();
        ArrayList<String> keys = new ArrayList<String>(mapEntryContexts.size());
        Class<?> cls = null;
        for (QLParser.MapEntryContext mapEntryContext : mapEntryContexts) {
            QLParser.MapValueContext valueContext = mapEntryContext.mapValue();
            if (valueContext instanceof QLParser.EValueContext) {
                QLParser.EValueContext eValueContext = (QLParser.EValueContext)valueContext;
                keys.add(this.parseMapKey(mapEntryContext.mapKey()));
                eValueContext.expression().accept(this);
                continue;
            }
            if (!(valueContext instanceof QLParser.ClsValueContext)) continue;
            QLParser.ClsValueContext clsValueContext = (QLParser.ClsValueContext)valueContext;
            TerminalNode clsLiteral = clsValueContext.QuoteStringLiteral();
            String clsText = clsLiteral.getText();
            String clsName = clsText.substring(1, clsText.length() - 1);
            Class<?> mayBeCls = this.importManager.loadQualified(clsName);
            if (mayBeCls == null) {
                String clsKeyText = mapEntryContext.mapKey().getText();
                keys.add(clsKeyText.substring(1, clsKeyText.length() - 1));
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(clsLiteral.getSymbol()), QLStringUtils.parseStringEscape(clsText), null));
                cls = null;
                continue;
            }
            cls = mayBeCls;
        }
        if (cls == null) {
            this.addInstruction(new NewMapInstruction(this.newReporterWithToken(ctx.getStart()), keys));
        } else {
            this.addInstruction(new NewFilledInstanceInstruction(this.newReporterWithToken(ctx.getStart()), cls, keys));
        }
        return null;
    }

    private String parseMapKey(QLParser.MapKeyContext mapKeyContext) {
        if (mapKeyContext instanceof QLParser.IdKeyContext) {
            return mapKeyContext.getText();
        }
        if (mapKeyContext instanceof QLParser.StringKeyContext || mapKeyContext instanceof QLParser.QuoteStringKeyContext) {
            return QLStringUtils.parseStringEscape(mapKeyContext.getText());
        }
        throw new IllegalStateException();
    }

    @Override
    public Void visitNewObjExpr(QLParser.NewObjExprContext ctx) {
        Class<?> newCls = this.parseClsIds(ctx.varId());
        QLParser.ArgumentListContext argumentListContext = ctx.argumentList();
        if (argumentListContext != null) {
            argumentListContext.accept(this);
        }
        int argNum = argumentListContext == null ? 0 : argumentListContext.expression().size();
        this.addInstruction(new NewInstanceInstruction(this.newReporterWithToken(ctx.NEW().getSymbol()), newCls, argNum));
        return null;
    }

    @Override
    public Void visitNewEmptyArrExpr(QLParser.NewEmptyArrExprContext ctx) {
        ctx.dimExprs().accept(this);
        int dims = ctx.dimExprs().expression().size();
        Class<?> arrCls = this.parseDeclTypeNoArr(ctx.declTypeNoArr());
        this.addInstruction(new MultiNewArrayInstruction(this.newReporterWithToken(ctx.NEW().getSymbol()), arrCls, dims));
        return null;
    }

    @Override
    public Void visitNewInitArrExpr(QLParser.NewInitArrExprContext ctx) {
        Class<?> cls = this.parseDeclTypeNoArr(ctx.declTypeNoArr());
        QLParser.ArrayInitializerContext arrayInitializerContext = ctx.arrayInitializer();
        this.newArrWithInitializers(this.embedClsInDims(cls, ctx.dims().LBRACK().size() - 1), arrayInitializerContext);
        return null;
    }

    private Class<?> embedClsInDims(Class<?> cls, int dims) {
        for (int i = 0; i < dims; ++i) {
            cls = Array.newInstance(cls, 0).getClass();
        }
        return cls;
    }

    @Override
    public Void visitLambdaExpr(QLParser.LambdaExprContext ctx) {
        List<QLambdaDefinitionInner.Param> lambdaParams = this.parseLambdaParams(ctx.lambdaParameters());
        String lambdaScopeName = this.lambdaScopeName();
        QvmInstructionVisitor subVisitor = null;
        QLParser.ExpressionContext expression = ctx.expression();
        ErrorReporter arrowErrorReporter = this.newReporterWithToken(ctx.ARROW().getSymbol());
        if (expression != null) {
            subVisitor = this.parseExprBodyWithSubVisitor(expression, new GeneratorScope(lambdaScopeName, this.generatorScope), Context.BLOCK);
        } else {
            QLParser.BlockStatementsContext blockStatementsContext = ctx.blockStatements();
            if (blockStatementsContext != null) {
                subVisitor = this.parseWithSubVisitor(blockStatementsContext, new GeneratorScope(lambdaScopeName, this.generatorScope), Context.BLOCK);
            }
        }
        if (subVisitor == null) {
            this.addInstruction(new LoadLambdaInstruction(arrowErrorReporter, QLambdaDefinitionEmpty.INSTANCE));
        } else {
            QLambdaDefinitionInner lambdaDefinition = new QLambdaDefinitionInner(lambdaScopeName, subVisitor.getInstructions(), lambdaParams, subVisitor.getMaxStackSize());
            this.addInstruction(new LoadLambdaInstruction(arrowErrorReporter, lambdaDefinition));
        }
        return null;
    }

    private List<QLambdaDefinitionInner.Param> parseLambdaParams(QLParser.LambdaParametersContext lambdaParametersContext) {
        QLParser.VarIdContext varIdContext = lambdaParametersContext.varId();
        if (varIdContext != null) {
            return Collections.singletonList(new QLambdaDefinitionInner.Param(varIdContext.getText(), Object.class));
        }
        QLParser.FormalOrInferredParameterListContext formalOrInferredParameterList = lambdaParametersContext.formalOrInferredParameterList();
        if (formalOrInferredParameterList == null) {
            return Collections.emptyList();
        }
        return formalOrInferredParameterList.formalOrInferredParameter().stream().map(this::formalOrInferredParameter2Param).collect(Collectors.toList());
    }

    private List<QLambdaDefinitionInner.Param> parseFormalOrInferredParameterList(QLParser.FormalOrInferredParameterListContext formalOrInferredParameterList) {
        return formalOrInferredParameterList.formalOrInferredParameter().stream().map(this::formalOrInferredParameter2Param).collect(Collectors.toList());
    }

    private QLambdaDefinitionInner.Param formalOrInferredParameter2Param(QLParser.FormalOrInferredParameterContext formalOrInferredParameterContext) {
        String paramName = formalOrInferredParameterContext.varId().getText();
        QLParser.DeclTypeContext declTypeContext = formalOrInferredParameterContext.declType();
        Class<Object> paramCls = declTypeContext == null ? Object.class : this.parseDeclType(declTypeContext);
        return new QLambdaDefinitionInner.Param(paramName, paramCls);
    }

    @Override
    public Void visitTryCatchExpr(QLParser.TryCatchExprContext ctx) {
        QLParser.BlockStatementsContext blockStatementsContext = ctx.blockStatements();
        if (blockStatementsContext == null) {
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(ctx.TRY().getSymbol()), null, ctx.getStart().getStartIndex()));
            return null;
        }
        int tryCount = this.tryCount();
        String tryScopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + TRY_PREFIX + tryCount;
        QvmInstructionVisitor bodySubVisitor = this.parseWithSubVisitor(blockStatementsContext, new GeneratorScope(tryScopeName, this.generatorScope), Context.BLOCK);
        QLambdaDefinitionInner bodyLambdaDefinition = new QLambdaDefinitionInner(tryScopeName, bodySubVisitor.getInstructions(), Collections.emptyList(), bodySubVisitor.getMaxStackSize());
        List<Map.Entry<Class<?>, QLambdaDefinition>> exceptionTable = this.parseExceptionTable(tryCount, ctx);
        QLambdaDefinition finalBodyDefinition = this.parseFinalBodyDefinition(tryCount, ctx);
        this.addInstruction(new TryCatchInstruction(this.newReporterWithToken(ctx.TRY().getSymbol()), bodyLambdaDefinition, exceptionTable, finalBodyDefinition));
        return null;
    }

    private QLambdaDefinition parseFinalBodyDefinition(int tryCount, QLParser.TryCatchExprContext ctx) {
        QLParser.TryFinallyContext tryFinallyContext = ctx.tryFinally();
        if (tryFinallyContext == null) {
            return null;
        }
        QLParser.BlockStatementsContext blockStatementsContext = tryFinallyContext.blockStatements();
        if (blockStatementsContext == null) {
            return null;
        }
        String finalScopeName = this.generatorScope.getName() + SCOPE_SEPARATOR + TRY_PREFIX + tryCount + FINAL_SUFFIX;
        QvmInstructionVisitor finalBodySubVisitor = this.parseWithSubVisitor(blockStatementsContext, new GeneratorScope(finalScopeName, this.generatorScope), Context.BLOCK);
        return new QLambdaDefinitionInner(finalScopeName, finalBodySubVisitor.getInstructions(), Collections.emptyList(), finalBodySubVisitor.getMaxStackSize());
    }

    private List<Map.Entry<Class<?>, QLambdaDefinition>> parseExceptionTable(int tryCount, QLParser.TryCatchExprContext ctx) {
        QLParser.TryCatchesContext tryCatchesContext = ctx.tryCatches();
        if (tryCatchesContext == null) {
            return Collections.emptyList();
        }
        List<QLParser.TryCatchContext> tryCatchContexts = tryCatchesContext.tryCatch();
        int catchSize = tryCatchContexts.size();
        ArrayList exceptionTable = new ArrayList(catchSize);
        for (QLParser.TryCatchContext tryCatchContext : tryCatchContexts) {
            QLParser.CatchParamsContext catchParamsContext = tryCatchContext.catchParams();
            String eName = catchParamsContext.varId().getText();
            String catchBodyName = this.generatorScope.getName() + SCOPE_SEPARATOR + TRY_PREFIX + tryCount + CATCH_SUFFIX;
            QvmInstructionVisitor catchSubVisitor = tryCatchContext.blockStatements() == null ? null : this.parseWithSubVisitor(tryCatchContext.blockStatements(), new GeneratorScope(catchBodyName, this.generatorScope), Context.BLOCK);
            List<QLParser.DeclTypeContext> catchDeclTypes = catchParamsContext.declType();
            if (catchDeclTypes.isEmpty()) {
                QLambdaDefinitionInner.Param param = new QLambdaDefinitionInner.Param(eName, Object.class);
                QLambdaDefinition exceptionHandlerDefinition = catchSubVisitor == null ? QLambdaDefinitionEmpty.INSTANCE : new QLambdaDefinitionInner(catchBodyName, catchSubVisitor.getInstructions(), Collections.singletonList(param), catchSubVisitor.getMaxStackSize());
                exceptionTable.add(new AbstractMap.SimpleEntry<Class<Object>, QLambdaDefinition>(Object.class, exceptionHandlerDefinition));
            }
            for (QLParser.DeclTypeContext declTypeContext : catchDeclTypes) {
                Class<?> exceptionType = this.parseDeclType(declTypeContext);
                QLambdaDefinitionInner.Param param = new QLambdaDefinitionInner.Param(eName, exceptionType);
                QLambdaDefinition exceptionHandlerDefinition = catchSubVisitor == null ? QLambdaDefinitionEmpty.INSTANCE : new QLambdaDefinitionInner(catchBodyName, catchSubVisitor.getInstructions(), Collections.singletonList(param), catchSubVisitor.getMaxStackSize());
                exceptionTable.add(new AbstractMap.SimpleEntry(exceptionType, exceptionHandlerDefinition));
            }
        }
        return exceptionTable;
    }

    @Override
    public Void visitVarIdExpr(QLParser.VarIdExprContext ctx) {
        this.addInstruction(new LoadInstruction(this.newReporterWithToken(ctx.getStart()), ctx.varId().getText(), ctx.getStart().getStartIndex()));
        return null;
    }

    private int parsePathHeadPart(QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext, List<QLParser.PathPartContext> pathPartContexts) {
        if (primaryNoFixPathableContext instanceof QLParser.TypeExprContext) {
            Class<?> cls = BuiltInTypesSet.getCls(primaryNoFixPathableContext.getStart().getText());
            int dimPartNum = this.parseDimParts(0, pathPartContexts);
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(primaryNoFixPathableContext.getStart()), new MetaClass(dimPartNum > 0 ? this.wrapInArray(cls, dimPartNum) : cls), null));
            return dimPartNum;
        }
        if (primaryNoFixPathableContext instanceof QLParser.VarIdExprContext) {
            QLParser.VarIdExprContext idContext = (QLParser.VarIdExprContext)primaryNoFixPathableContext;
            return this.parseIdHeadPart(idContext.varId(), pathPartContexts);
        }
        primaryNoFixPathableContext.accept(this);
        return 0;
    }

    private int parseIdHeadPart(QLParser.VarIdContext idContext, List<QLParser.PathPartContext> pathPartContexts) {
        if (!pathPartContexts.isEmpty() && pathPartContexts.get(0) instanceof QLParser.CallExprContext) {
            QLParser.CallExprContext callExprContext = (QLParser.CallExprContext)pathPartContexts.get(0);
            QLParser.ArgumentListContext argumentListContext = callExprContext.argumentList();
            this.visitCallFunction(idContext, argumentListContext);
            return 1;
        }
        ArrayList<String> headPartIds = new ArrayList<String>();
        headPartIds.add(idContext.getText());
        for (QLParser.PathPartContext pathPartContext : pathPartContexts) {
            if (!(pathPartContext instanceof QLParser.FieldAccessContext)) break;
            headPartIds.add(this.parseFieldId(((QLParser.FieldAccessContext)pathPartContext).fieldId()));
        }
        ImportManager.LoadPartQualifiedResult loadPartQualifiedResult = this.importManager.loadPartQualified(headPartIds);
        if (loadPartQualifiedResult.getCls() != null) {
            int restIndex = loadPartQualifiedResult.getRestIndex() - 1;
            Token clsReportToken = restIndex == 0 ? idContext.getStart() : pathPartContexts.get(restIndex - 1).getStop();
            int dimPartNum = this.parseDimParts(restIndex, pathPartContexts);
            Class<?> cls = dimPartNum > 0 ? this.wrapInArray(loadPartQualifiedResult.getCls(), dimPartNum) : loadPartQualifiedResult.getCls();
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(clsReportToken), new MetaClass(cls), null));
            return restIndex + dimPartNum;
        }
        this.addInstruction(new LoadInstruction(this.newReporterWithToken(idContext.getStart()), idContext.getText(), idContext.getStart().getStartIndex()));
        return 0;
    }

    private int parseDimParts(int start, List<QLParser.PathPartContext> pathPartContexts) {
        QLParser.PathPartContext pathPartContext;
        int i;
        for (i = start; i < pathPartContexts.size() && this.isEmptyIndex(pathPartContext = pathPartContexts.get(i)); ++i) {
        }
        return i - start;
    }

    private boolean isEmptyIndex(QLParser.PathPartContext pathPartContext) {
        if (!(pathPartContext instanceof QLParser.IndexExprContext)) {
            return false;
        }
        QLParser.IndexExprContext indexExprContext = (QLParser.IndexExprContext)pathPartContext;
        return indexExprContext.indexValueExpr() == null;
    }

    @Override
    public Void visitMethodInvoke(QLParser.MethodInvokeContext ctx) {
        this.visitMethodInvokeInner(ctx.argumentList(), ctx.varId(), false);
        return null;
    }

    @Override
    public Void visitOptionalMethodInvoke(QLParser.OptionalMethodInvokeContext ctx) {
        this.visitMethodInvokeInner(ctx.argumentList(), ctx.varId(), true);
        return null;
    }

    @Override
    public Void visitSpreadMethodInvoke(QLParser.SpreadMethodInvokeContext ctx) {
        QLParser.ArgumentListContext argumentListContext = ctx.argumentList();
        if (argumentListContext != null) {
            argumentListContext.accept(this);
        }
        QLParser.VarIdContext methodName = ctx.varId();
        int argNum = argumentListContext == null ? 0 : argumentListContext.expression().size();
        this.addInstruction(new SpreadMethodInvokeInstruction(this.newReporterWithToken(methodName.getStart()), methodName.getText(), argNum));
        return null;
    }

    private void visitMethodInvokeInner(QLParser.ArgumentListContext argumentListContext, QLParser.VarIdContext methodName, boolean optional) {
        if (argumentListContext != null) {
            argumentListContext.accept(this);
        }
        int argNum = argumentListContext == null ? 0 : argumentListContext.expression().size();
        this.addInstruction(new MethodInvokeInstruction(this.newReporterWithToken(methodName.getStart()), methodName.getText(), argNum, optional));
    }

    @Override
    public Void visitFieldAccess(QLParser.FieldAccessContext ctx) {
        Token fieldNameToken = ctx.getStop();
        this.addInstruction(new GetFieldInstruction(this.newReporterWithToken(fieldNameToken), this.parseFieldId(ctx.fieldId()), false));
        return null;
    }

    @Override
    public Void visitOptionalFieldAccess(QLParser.OptionalFieldAccessContext ctx) {
        Token fieldNameToken = ctx.getStop();
        this.addInstruction(new GetFieldInstruction(this.newReporterWithToken(fieldNameToken), this.parseFieldId(ctx.fieldId()), true));
        return null;
    }

    @Override
    public Void visitSpreadFieldAccess(QLParser.SpreadFieldAccessContext ctx) {
        Token fieldNameToken = ctx.getStop();
        this.addInstruction(new SpreadGetFieldInstruction(this.newReporterWithToken(fieldNameToken), this.parseFieldId(ctx.fieldId())));
        return null;
    }

    private String parseFieldId(QLParser.FieldIdContext ctx) {
        TerminalNode quoteStringLiteral = ctx.QuoteStringLiteral();
        if (quoteStringLiteral != null) {
            return QLStringUtils.parseStringEscape(quoteStringLiteral.getText());
        }
        return ctx.getStart().getText();
    }

    @Override
    public Void visitMethodAccess(QLParser.MethodAccessContext ctx) {
        QLParser.VarIdContext methodName = ctx.varId();
        this.addInstruction(new GetMethodInstruction(this.newReporterWithToken(ctx.DCOLON().getSymbol()), methodName.getText()));
        return null;
    }

    @Override
    public Void visitCallExpr(QLParser.CallExprContext ctx) {
        QLParser.ArgumentListContext argumentListContext = ctx.argumentList();
        if (argumentListContext != null) {
            argumentListContext.accept(this);
        }
        int argNum = argumentListContext == null ? 0 : argumentListContext.expression().size();
        this.addInstruction(new CallInstruction(this.newReporterWithToken(ctx.getStart()), argNum));
        return null;
    }

    @Override
    public Void visitIndexExpr(QLParser.IndexExprContext ctx) {
        QLParser.IndexValueExprContext indexValueExprContext = ctx.indexValueExpr();
        if (indexValueExprContext == null) {
            throw this.reportParseErr(ctx.getStop(), QLErrorCodes.MISSING_INDEX.name(), QLErrorCodes.MISSING_INDEX.getErrorMsg());
        }
        ErrorReporter errorReporter = this.newReporterWithToken(ctx.getStart());
        if (indexValueExprContext instanceof QLParser.SingleIndexContext) {
            ((QLParser.SingleIndexContext)indexValueExprContext).expression().accept(this);
            this.addInstruction(new IndexInstruction(errorReporter));
        } else if (indexValueExprContext instanceof QLParser.SliceIndexContext) {
            QLParser.SliceIndexContext sliceIndexContext = (QLParser.SliceIndexContext)indexValueExprContext;
            if (sliceIndexContext.start == null && sliceIndexContext.end == null) {
                this.addInstruction(new SliceInstruction(errorReporter, SliceInstruction.Mode.COPY));
            } else if (sliceIndexContext.start == null) {
                sliceIndexContext.end.accept(this);
                this.addInstruction(new SliceInstruction(errorReporter, SliceInstruction.Mode.LEFT));
            } else if (sliceIndexContext.end == null) {
                sliceIndexContext.start.accept(this);
                this.addInstruction(new SliceInstruction(errorReporter, SliceInstruction.Mode.RIGHT));
            } else {
                sliceIndexContext.start.accept(this);
                sliceIndexContext.end.accept(this);
                this.addInstruction(new SliceInstruction(errorReporter, SliceInstruction.Mode.BOTH));
            }
        }
        return null;
    }

    @Override
    public Void visitCustomPath(QLParser.CustomPathContext ctx) {
        ErrorReporter errorReporter = this.newReporterWithToken(ctx.getStart());
        String path = ctx.varId().getText();
        this.addInstruction(new ConstInstruction(errorReporter, path, null));
        String operatorId = ctx.opId().getText();
        BinaryOperator binaryOperator = this.operatorFactory.getBinaryOperator(operatorId);
        this.addInstruction(new OperatorInstruction(errorReporter, binaryOperator, ctx.opId().getStart().getStartIndex()));
        return null;
    }

    @Override
    public Void visitLeftAsso(QLParser.LeftAssoContext ctx) {
        QLParser.BinaryopContext binaryopContext = ctx.binaryop();
        ErrorReporter opErrReporter = this.newReporterWithToken(binaryopContext.getStart());
        String operatorId = binaryopContext.getText();
        QLParser.BaseExprContext rightExpr = ctx.baseExpr();
        if ("&&".equals(operatorId)) {
            this.jumpRightIfExpect(false, opErrReporter, rightExpr, operatorId, binaryopContext.getStart().getStartIndex());
        } else if ("||".equals(operatorId)) {
            this.jumpRightIfExpect(true, opErrReporter, rightExpr, operatorId, binaryopContext.getStart().getStartIndex());
        } else {
            rightExpr.accept(this);
            BinaryOperator binaryOperator = this.operatorFactory.getBinaryOperator(operatorId);
            this.addInstruction(new OperatorInstruction(opErrReporter, binaryOperator, binaryopContext.getStart().getStartIndex()));
        }
        return null;
    }

    @Override
    public Void visitMacroStatement(QLParser.MacroStatementContext ctx) {
        String macroId = ctx.varId().getText();
        QLParser.BlockStatementsContext macroBlockStatementsContext = ctx.blockStatements();
        QLParser.BlockStatementContext lastStmt = this.getMacroLastStmt(ctx, macroBlockStatementsContext);
        this.generatorScope.defineMacro(macroId, new MacroDefine(this.getMacroInstructions(macroBlockStatementsContext), lastStmt instanceof QLParser.ExpressionStatementContext));
        if (this.initOptions.isTraceExpression()) {
            this.pureAddInstruction(new TraceEvaludatedInstruction(this.newReporterWithToken(ctx.varId().getStart()), ctx.varId().getStart().getStartIndex()));
        }
        return null;
    }

    private QLParser.BlockStatementContext getMacroLastStmt(QLParser.MacroStatementContext macroCtx, QLParser.BlockStatementsContext macroBlockStatementsCtx) {
        if (macroBlockStatementsCtx == null) {
            return macroCtx;
        }
        List blockStatementContexts = macroBlockStatementsCtx.blockStatement().stream().filter(bs -> !(bs instanceof QLParser.EmptyStatementContext)).collect(Collectors.toList());
        return blockStatementContexts.isEmpty() ? macroCtx : (QLParser.BlockStatementContext)blockStatementContexts.get(blockStatementContexts.size() - 1);
    }

    private List<QLInstruction> getMacroInstructions(QLParser.BlockStatementsContext macroBlockStatementsContext) {
        if (macroBlockStatementsContext == null) {
            return Collections.emptyList();
        }
        QvmInstructionVisitor subVisitor = this.parseWithSubVisitor(macroBlockStatementsContext, new GeneratorScope(this.macroScopeName(), this.generatorScope), Context.MACRO);
        return subVisitor.getInstructions();
    }

    @Override
    public Void visitLocalVariableDeclaration(QLParser.LocalVariableDeclarationContext ctx) {
        if (this.initOptions.isTraceExpression()) {
            this.addInstruction(new TraceEvaludatedInstruction(this.newReporterWithToken(ctx.getStart()), ctx.getStart().getStartIndex()));
        }
        Class<?> declCls = this.parseDeclType(ctx.declType());
        List<QLParser.VariableDeclaratorContext> variableDeclaratorContexts = ctx.variableDeclaratorList().variableDeclarator();
        for (QLParser.VariableDeclaratorContext variableDeclarator : variableDeclaratorContexts) {
            QLParser.VariableInitializerContext variableInitializer = variableDeclarator.variableInitializer();
            if (variableInitializer == null) {
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(variableDeclarator.getStop()), null, null));
            } else {
                this.parseInitializer(variableInitializer, declCls);
            }
            QLParser.VariableDeclaratorIdContext variableDeclaratorIdContext = variableDeclarator.variableDeclaratorId();
            this.addInstruction(new DefineLocalInstruction(this.newReporterWithToken(variableDeclaratorIdContext.getStart()), variableDeclaratorIdContext.getText(), declCls));
        }
        return null;
    }

    private void parseInitializer(QLParser.VariableInitializerContext variableInitializer, Class<?> declCls) {
        QLParser.ExpressionContext expression = variableInitializer.expression();
        if (expression != null) {
            expression.accept(this);
            return;
        }
        QLParser.ArrayInitializerContext arrayInitializerContext = variableInitializer.arrayInitializer();
        this.newArrWithInitializers(declCls, arrayInitializerContext);
    }

    private void newArrWithInitializers(Class<?> componentClz, QLParser.ArrayInitializerContext arrayInitializerContext) {
        QLParser.VariableInitializerListContext variableInitializerListContext = arrayInitializerContext.variableInitializerList();
        List<Object> initializerContexts = variableInitializerListContext == null ? Collections.emptyList() : variableInitializerListContext.variableInitializer();
        for (QLParser.VariableInitializerContext variableInitializerContext : initializerContexts) {
            variableInitializerContext.accept(this);
        }
        this.addInstruction(new NewArrayInstruction(this.newReporterWithToken(arrayInitializerContext.getStart()), componentClz, initializerContexts.size()));
    }

    @Override
    public Void visitLeftHandSide(QLParser.LeftHandSideContext ctx) {
        QLParser.VarIdContext idContext = ctx.varId();
        List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
        if (pathPartContexts.size() == 1 && pathPartContexts.get(0) instanceof QLParser.CallExprContext) {
            QLParser.CallExprContext callExprContext = (QLParser.CallExprContext)pathPartContexts.get(0);
            QLParser.ArgumentListContext argumentListContext = callExprContext.argumentList();
            this.visitCallFunction(idContext, argumentListContext);
        } else {
            int tailPartStart;
            for (int i = tailPartStart = this.parseIdHeadPart(idContext, pathPartContexts); i < pathPartContexts.size(); ++i) {
                pathPartContexts.get(i).accept(this);
            }
        }
        return null;
    }

    private void visitCallFunction(final QLParser.VarIdContext functionNameContext, QLParser.ArgumentListContext argumentListContext) {
        final String functionName = functionNameContext.getText();
        CompileTimeFunction compileTimeFunction = this.compileTimeFunctions.get(functionName);
        if (compileTimeFunction != null) {
            final ErrorReporter functionNameReporter = this.newReporterWithToken(functionNameContext.getStart());
            compileTimeFunction.createFunctionInstruction(functionName, argumentListContext == null ? Collections.emptyList() : argumentListContext.expression(), this.operatorFactory, new CodeGenerator(){

                @Override
                public void addInstruction(QLInstruction qlInstruction) {
                    QvmInstructionVisitor.this.addInstruction(qlInstruction);
                }

                @Override
                public void addInstructionsByTree(ParseTree tree) {
                    tree.accept(QvmInstructionVisitor.this);
                }

                @Override
                public QLSyntaxException reportParseErr(String errCode, String errReason) {
                    return QvmInstructionVisitor.this.reportParseErr(functionNameContext.getStart(), errCode, errReason);
                }

                @Override
                public QLambdaDefinition generateLambdaDefinition(QLParser.ExpressionContext expressionContext, List<QLambdaDefinitionInner.Param> params) {
                    QvmInstructionVisitor subVisitor = QvmInstructionVisitor.this.parseExprBodyWithSubVisitor(expressionContext, QvmInstructionVisitor.this.generatorScope, QvmInstructionVisitor.this.context);
                    return new QLambdaDefinitionInner(functionName, subVisitor.getInstructions(), params, subVisitor.getMaxStackSize());
                }

                @Override
                public ErrorReporter getErrorReporter() {
                    return functionNameReporter;
                }

                @Override
                public ErrorReporter newReporterWithToken(Token token) {
                    return QvmInstructionVisitor.this.newReporterWithToken(token);
                }
            });
            return;
        }
        if (argumentListContext != null) {
            argumentListContext.accept(this);
        }
        int argSize = argumentListContext == null ? 0 : argumentListContext.expression().size();
        this.addInstruction(new CallFunctionInstruction(this.newReporterWithToken(functionNameContext.getStart()), functionName, argSize, functionNameContext.getStart().getStartIndex()));
    }

    @Override
    public Void visitPrimary(QLParser.PrimaryContext ctx) {
        QLParser.PrefixExpressContext prefixExpressContext;
        int tailPartStart;
        if (ctx.primaryNoFixNonPathable() != null) {
            ctx.primaryNoFixNonPathable().accept(this);
            return null;
        }
        QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext = ctx.primaryNoFixPathable();
        List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
        for (int i = tailPartStart = this.parsePathHeadPart(primaryNoFixPathableContext, pathPartContexts); i < pathPartContexts.size(); ++i) {
            pathPartContexts.get(i).accept(this);
        }
        QLParser.SuffixExpressContext suffixExpressContext = ctx.suffixExpress();
        if (suffixExpressContext != null) {
            String suffixOperator = suffixExpressContext.getText();
            UnaryOperator suffixUnaryOperator = this.operatorFactory.getSuffixUnaryOperator(suffixOperator);
            this.addInstruction(new UnaryInstruction(this.newReporterWithToken(suffixExpressContext.getStart()), suffixUnaryOperator, suffixExpressContext.getStart().getStartIndex()));
        }
        if ((prefixExpressContext = ctx.prefixExpress()) != null) {
            String prefixOperator = prefixExpressContext.getText();
            UnaryOperator prefixUnaryOperator = this.operatorFactory.getPrefixUnaryOperator(prefixOperator);
            this.addInstruction(new UnaryInstruction(this.newReporterWithToken(prefixExpressContext.getStart()), prefixUnaryOperator, prefixExpressContext.getStart().getStartIndex()));
        }
        return null;
    }

    @Override
    public Void visitTypeExpr(QLParser.TypeExprContext ctx) {
        Class<?> cls = BuiltInTypesSet.getCls(ctx.primitiveType().getText());
        this.addInstruction(new ConstInstruction(this.newReporterWithToken(ctx.getStart()), new MetaClass(cls), null));
        return null;
    }

    @Override
    public Void visitArrayInitializer(QLParser.ArrayInitializerContext ctx) {
        return (Void)super.visitArrayInitializer(ctx);
    }

    @Override
    public Void visitConstExpr(QLParser.ConstExprContext ctx) {
        ctx.literal().accept(this);
        return null;
    }

    @Override
    public Void visitContextSelectExpr(QLParser.ContextSelectExprContext ctx) {
        String variableName = ctx.SelectorVariable_VANME().getText().trim();
        this.addInstruction(new LoadInstruction(this.newReporterWithToken(ctx.getStart()), variableName, ctx.getStart().getStartIndex()));
        return null;
    }

    @Override
    public Void visitLiteral(QLParser.LiteralContext literal) {
        TerminalNode integerLiteral = literal.IntegerLiteral();
        if (integerLiteral != null) {
            try {
                Number intResult = this.parseInteger(this.remove(integerLiteral.getText(), '_'));
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(integerLiteral.getSymbol()), intResult, integerLiteral.getSymbol().getStartIndex()));
            }
            catch (NumberFormatException nfe) {
                throw this.reportParseErr(integerLiteral.getSymbol(), QLErrorCodes.INVALID_NUMBER.name(), QLErrorCodes.INVALID_NUMBER.getErrorMsg());
            }
            return null;
        }
        TerminalNode floatingPointLiteral = literal.FloatingPointLiteral();
        if (floatingPointLiteral != null) {
            try {
                Number floatingResult = this.parseFloating(this.remove(floatingPointLiteral.getText(), '_'));
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(floatingPointLiteral.getSymbol()), floatingResult, floatingPointLiteral.getSymbol().getStartIndex()));
            }
            catch (NumberFormatException nfe) {
                throw this.reportParseErr(floatingPointLiteral.getSymbol(), QLErrorCodes.INVALID_NUMBER.name(), QLErrorCodes.INVALID_NUMBER.getErrorMsg());
            }
            return null;
        }
        TerminalNode integerOrFloatingLiteral = literal.IntegerOrFloatingLiteral();
        if (integerOrFloatingLiteral != null) {
            try {
                String numberText = integerOrFloatingLiteral.getText();
                Number numberResult = numberText.contains(".") ? (Number)this.parseFloating(this.remove(numberText, '_')) : (Number)this.parseInteger(this.remove(numberText, '_'));
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(integerOrFloatingLiteral.getSymbol()), numberResult, integerOrFloatingLiteral.getSymbol().getStartIndex()));
            }
            catch (NumberFormatException nfe) {
                throw this.reportParseErr(integerOrFloatingLiteral.getSymbol(), QLErrorCodes.INVALID_NUMBER.name(), QLErrorCodes.INVALID_NUMBER.getErrorMsg());
            }
            return null;
        }
        QLParser.BoolenLiteralContext booleanLiteral = literal.boolenLiteral();
        if (booleanLiteral != null) {
            boolean boolValue = Boolean.parseBoolean(booleanLiteral.getText());
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(booleanLiteral.getStart()), boolValue, booleanLiteral.getStart().getStartIndex()));
            return null;
        }
        TerminalNode quoteStringLiteral = literal.QuoteStringLiteral();
        if (quoteStringLiteral != null) {
            String escapedStr = QLStringUtils.parseStringEscape(quoteStringLiteral.getText());
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(quoteStringLiteral.getSymbol()), escapedStr, quoteStringLiteral.getSymbol().getStartIndex()));
            return null;
        }
        QLParser.DoubleQuoteStringLiteralContext doubleQuoteStringLiteral = literal.doubleQuoteStringLiteral();
        if (doubleQuoteStringLiteral != null) {
            this.visitDoubleQuoteStringLiteral(doubleQuoteStringLiteral);
            return null;
        }
        TerminalNode nullLiteral = literal.NULL();
        if (nullLiteral != null) {
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(nullLiteral.getSymbol()), null, nullLiteral.getSymbol().getStartIndex()));
            return null;
        }
        return null;
    }

    @Override
    public Void visitDoubleQuoteStringLiteral(QLParser.DoubleQuoteStringLiteralContext ctx) {
        if (this.initOptions.getInterpolationMode() == InterpolationMode.DISABLE) {
            TerminalNode characters = ctx.StaticStringCharacters();
            if (characters == null) {
                this.addInstruction(new ConstInstruction(this.newReporterWithToken(ctx.getStart()), "", null));
                return null;
            }
            String originText = characters.getText();
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(ctx.getStart()), QLStringUtils.parseStringEscapeStartEnd(originText, 0, originText.length()), null));
            return null;
        }
        int childCount = ctx.getChildCount();
        for (int i = 1; i < childCount - 1; ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof QLParser.StringExpressionContext) {
                QLParser.StringExpressionContext stringExpression = (QLParser.StringExpressionContext)child;
                QLParser.ExpressionContext expression = stringExpression.expression();
                if (expression != null) {
                    this.visitExpression(expression);
                    continue;
                }
                TerminalNode varTerminalNode = stringExpression.SelectorVariable_VANME();
                String varName = varTerminalNode.getText().trim();
                this.addInstruction(new LoadInstruction(this.newReporterWithToken(varTerminalNode.getSymbol()), varName, null));
                continue;
            }
            if (!(child instanceof TerminalNode)) continue;
            TerminalNode terminalNode = (TerminalNode)child;
            String originStr = terminalNode.getText();
            this.addInstruction(new ConstInstruction(this.newReporterWithToken(terminalNode.getSymbol()), QLStringUtils.parseStringEscapeStartEnd(originStr, 0, originStr.length()), ctx.getStart().getStartIndex()));
        }
        this.addInstruction(new StringJoinInstruction(this.newReporterWithToken(ctx.getStart()), childCount - 2));
        return null;
    }

    private Number parseFloating(String floatingText) {
        char floatingTypeFlag = floatingText.charAt(floatingText.length() - 1);
        switch (floatingTypeFlag) {
            case 'F': 
            case 'f': {
                return Float.valueOf(new BigDecimal(floatingText.substring(0, floatingText.length() - 1)).floatValue());
            }
            case 'D': 
            case 'd': {
                return new BigDecimal(floatingText.substring(0, floatingText.length() - 1)).doubleValue();
            }
        }
        BigDecimal baseDecimal = new BigDecimal(floatingText);
        return baseDecimal.compareTo(MAX_DOUBLE) <= 0 ? this.maybePresentWithDouble(baseDecimal) : baseDecimal;
    }

    private Number maybePresentWithDouble(BigDecimal origin) {
        double doubleValue = origin.doubleValue();
        BigDecimal reference = new BigDecimal(doubleValue);
        return reference.compareTo(origin) == 0 ? Double.valueOf(doubleValue) : origin;
    }

    private Number parseInteger(String intText) {
        char intTypeFlag = intText.charAt(intText.length() - 1);
        switch (intTypeFlag) {
            case 'L': 
            case 'l': {
                String baseIntText = intText.substring(0, intText.length() - 1);
                BigInteger baseInt = this.parseBaseInteger(baseIntText);
                return baseInt.longValue();
            }
        }
        BigInteger baseInt = this.parseBaseInteger(intText);
        if (baseInt.compareTo(MAX_INTEGER) <= 0) {
            return baseInt.intValue();
        }
        if (baseInt.compareTo(MAX_LONG) <= 0) {
            return baseInt.longValue();
        }
        return baseInt;
    }

    private BigInteger parseBaseInteger(String intText) {
        String radixPrefix;
        switch (radixPrefix = this.subString(intText, 2)) {
            case "0x": 
            case "0X": {
                return new BigInteger(intText.substring(2), 16);
            }
            case "0b": 
            case "0B": {
                return new BigInteger(intText.substring(2), 2);
            }
        }
        if (radixPrefix.startsWith("0")) {
            return new BigInteger(intText, 8);
        }
        return new BigInteger(intText);
    }

    private Class<?> parseDeclTypeNoArr(QLParser.DeclTypeNoArrContext declTypeNoArrContext) {
        QLParser.PrimitiveTypeContext primitiveTypeContext = declTypeNoArrContext.primitiveType();
        if (primitiveTypeContext != null) {
            return BuiltInTypesSet.getCls(primitiveTypeContext.getText());
        }
        QLParser.ClsTypeContext clsTypeContext = declTypeNoArrContext.clsType();
        return this.parseClsIds(clsTypeContext.varId());
    }

    private Class<?> parseDeclType(QLParser.DeclTypeContext declTypeContext) {
        Class<?> baseCls = this.parseDeclBaseCls(declTypeContext);
        QLParser.DimsContext dims = declTypeContext.dims();
        int layers = dims == null ? 0 : dims.LBRACK().size();
        return this.wrapInArray(baseCls, layers);
    }

    private Class<?> parseDeclBaseCls(QLParser.DeclTypeContext declTypeContext) {
        QLParser.PrimitiveTypeContext primitiveTypeContext = declTypeContext.primitiveType();
        if (primitiveTypeContext != null) {
            return BuiltInTypesSet.getCls(primitiveTypeContext.getText());
        }
        QLParser.ClsTypeContext clsTypeContext = declTypeContext.clsType();
        return this.parseClsIds(clsTypeContext.varId());
    }

    private String remove(String target, char c) {
        StringBuilder builder = new StringBuilder(target.length());
        for (int i = 0; i < target.length(); ++i) {
            char iChar = target.charAt(i);
            if (iChar == c) continue;
            builder.append(iChar);
        }
        return builder.toString();
    }

    private String subString(String target, int end) {
        if (end > target.length()) {
            return target;
        }
        return target.substring(0, end);
    }

    private Class<?> wrapInArray(Class<?> baseType, int layers) {
        for (int i = 0; i < layers; ++i) {
            baseType = Array.newInstance(baseType, 0).getClass();
        }
        return baseType;
    }

    private Class<?> parseClsIds(List<QLParser.VarIdContext> varIdContexts) {
        List<String> fieldIds = varIdContexts.stream().map(RuleContext::getText).collect(Collectors.toList());
        ImportManager.LoadPartQualifiedResult loadPartQualifiedResult = this.importManager.loadPartQualified(fieldIds);
        if (loadPartQualifiedResult.getCls() == null || loadPartQualifiedResult.getRestIndex() != fieldIds.size()) {
            Token lastIdToken = varIdContexts.get(varIdContexts.size() - 1).getStart();
            throw this.reportParseErr(lastIdToken, QLErrorCodes.CLASS_NOT_FOUND.name(), String.format(QLErrorCodes.CLASS_NOT_FOUND.getErrorMsg(), String.join((CharSequence)".", fieldIds)));
        }
        return loadPartQualifiedResult.getCls();
    }

    private QLSyntaxException reportParseErr(Token token, String errCode, String errReason) {
        return QLException.reportScannerErr(this.script, token.getStartIndex(), token.getLine(), token.getCharPositionInLine(), token.getText(), errCode, errReason);
    }

    public List<QLInstruction> getInstructions() {
        return this.instructionList;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    private void ifElseInstructions(ErrorReporter conditionReporter, List<QLInstruction> thenInstructions, Integer thenTraceKey, List<QLInstruction> elseInstructions, Integer elseTraceKey, int traceKey) {
        JumpIfPopInstruction jumpIf = new JumpIfPopInstruction(conditionReporter, false, -1);
        this.pureAddInstruction(jumpIf);
        int jumpStart = this.instructionList.size();
        thenInstructions.forEach(this::pureAddInstruction);
        if (this.initOptions.isTraceExpression()) {
            if (thenTraceKey != null) {
                this.pureAddInstruction(new TracePeekInstruction(conditionReporter, thenTraceKey));
            }
            this.pureAddInstruction(new TracePeekInstruction(conditionReporter, traceKey));
        }
        this.addTimeoutInstruction();
        JumpInstruction jump = new JumpInstruction(conditionReporter, -1);
        this.pureAddInstruction(jump);
        jumpIf.setPosition(this.instructionList.size() - jumpStart);
        jumpStart = this.instructionList.size();
        elseInstructions.forEach(this::pureAddInstruction);
        if (this.initOptions.isTraceExpression()) {
            if (elseTraceKey != null) {
                this.pureAddInstruction(new TracePeekInstruction(conditionReporter, elseTraceKey));
            }
            this.pureAddInstruction(new TracePeekInstruction(conditionReporter, traceKey));
        }
        this.addTimeoutInstruction();
        jump.setPosition(this.instructionList.size() - jumpStart);
    }

    private void jumpRightIfExpect(boolean expect, ErrorReporter opErrReporter, RuleContext right, String operatorId, int traceKey) {
        QvmInstructionVisitor rightVisitor = this.parseWithSubVisitor(right, this.generatorScope, Context.MACRO);
        List<QLInstruction> rightInstructions = rightVisitor.getInstructions();
        JumpIfInstruction jumpIf = new JumpIfInstruction(opErrReporter, expect, -1, traceKey);
        this.pureAddInstruction(jumpIf);
        int jumpStart = this.instructionList.size();
        rightInstructions.forEach(this::pureAddInstruction);
        BinaryOperator binaryOperator = this.operatorFactory.getBinaryOperator(operatorId);
        this.addInstruction(new OperatorInstruction(opErrReporter, binaryOperator, traceKey));
        this.addTimeoutInstruction();
        jumpIf.setPosition(this.instructionList.size() - jumpStart);
    }

    private QvmInstructionVisitor parseWithSubVisitor(RuleContext ruleContext, GeneratorScope generatorScope, Context context) {
        QvmInstructionVisitor subVisitor = new QvmInstructionVisitor(this.script, this.importManager, generatorScope, this.operatorFactory, context, this.compileTimeFunctions, this.initOptions);
        ruleContext.accept(subVisitor);
        return subVisitor;
    }

    private QvmInstructionVisitor parseExprBodyWithSubVisitor(QLParser.ExpressionContext expressionContext, GeneratorScope generatorScope, Context context) {
        QvmInstructionVisitor subVisitor = new QvmInstructionVisitor(this.script, this.importManager, generatorScope, this.operatorFactory, context, this.compileTimeFunctions, this.initOptions);
        subVisitor.visitBodyExpression(expressionContext);
        return subVisitor;
    }

    private boolean handleStmt(QLParser.BlockStatementContext statementContext) {
        String macroName;
        MacroDefine macroDefine;
        if (this.maybeMacroCall(statementContext) && (macroDefine = this.generatorScope.getMacroInstructions(macroName = statementContext.getStart().getText())) != null) {
            macroDefine.getMacroInstructions().forEach(this::pureAddInstruction);
            this.addTimeoutInstruction();
            return macroDefine.isLastStmtExpress();
        }
        statementContext.accept(this);
        return statementContext instanceof QLParser.ExpressionStatementContext;
    }

    private boolean maybeMacroCall(QLParser.BlockStatementContext statementContext) {
        QLParser.ExpressionContext expressionContext;
        if (statementContext instanceof QLParser.ExpressionStatementContext && (expressionContext = ((QLParser.ExpressionStatementContext)statementContext).expression()) != null && expressionContext.getStart() == expressionContext.getStop()) {
            return expressionContext.getStart().getType() == 91;
        }
        return false;
    }

    private void pureAddInstruction(QLInstruction qlInstruction) {
        int stackExpandSize = qlInstruction.stackOutput() - qlInstruction.stackInput();
        this.expandStackSize(stackExpandSize);
        this.instructionList.add(qlInstruction);
    }

    private void addInstruction(QLInstruction qlInstruction) {
        if (this.instructionList.size() - this.timeoutCheckPoint > 5) {
            this.addTimeoutInstruction();
        }
        this.pureAddInstruction(qlInstruction);
        if (qlInstruction instanceof MethodInvokeInstruction || qlInstruction instanceof CallFunctionInstruction || qlInstruction instanceof CallConstInstruction || qlInstruction instanceof CallInstruction) {
            this.addTimeoutInstruction();
        }
    }

    private void addTimeoutInstruction() {
        QLInstruction lastInstruction = this.instructionList.get(this.instructionList.size() - 1);
        if (lastInstruction instanceof CheckTimeOutInstruction) {
            return;
        }
        this.timeoutCheckPoint = this.instructionList.size();
        this.instructionList.add(new CheckTimeOutInstruction(lastInstruction.getErrorReporter()));
    }

    private void expandStackSize(int stackExpandSize) {
        this.stackSize += stackExpandSize;
        if (this.stackSize > this.maxStackSize) {
            this.maxStackSize = this.stackSize;
        }
    }

    private ErrorReporter newReporterWithToken(Token token) {
        return new DefaultErrReporter(this.script, token.getStartIndex(), token.getLine(), token.getCharPositionInLine(), token.getText());
    }

    private int whileCount() {
        return this.whileCounter++;
    }

    private int forCount() {
        return this.forCounter++;
    }

    private int ifCount() {
        return this.ifCounter++;
    }

    private int tryCount() {
        return this.tryCounter++;
    }

    private String blockScopeName() {
        return this.generatorScope.getName() + SCOPE_SEPARATOR + BLOCK_LAMBDA_NAME_PREFIX + this.blockCounter++;
    }

    private String macroScopeName() {
        return this.generatorScope.getName() + SCOPE_SEPARATOR + MACRO_PREFIX + this.macroCounter++;
    }

    private String lambdaScopeName() {
        return this.generatorScope.getName() + SCOPE_SEPARATOR + LAMBDA_PREFIX + this.lambdaCounter++;
    }

    public static enum Context {
        BLOCK,
        MACRO;

    }
}

