/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.aparser.ExistStack;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.QLParserBaseVisitor;

public abstract class ScopeStackVisitor
extends QLParserBaseVisitor<Void> {
    private ExistStack existStack;

    protected ScopeStackVisitor(ExistStack existStack) {
        this.existStack = existStack;
    }

    @Override
    public Void visitBlockExpr(QLParser.BlockExprContext ctx) {
        this.push();
        super.visitBlockExpr(ctx);
        this.pop();
        return null;
    }

    @Override
    public Void visitQlIf(QLParser.QlIfContext qlIfContext) {
        qlIfContext.condition.accept(this);
        this.push();
        qlIfContext.thenBody().accept(this);
        this.pop();
        QLParser.ElseBodyContext elseBodyContext = qlIfContext.elseBody();
        if (elseBodyContext != null) {
            this.push();
            elseBodyContext.accept(this);
            this.pop();
        }
        return null;
    }

    @Override
    public Void visitTryCatchExpr(QLParser.TryCatchExprContext ctx) {
        QLParser.TryFinallyContext tryFinallyContext;
        QLParser.TryCatchesContext tryCatchesContext;
        QLParser.BlockStatementsContext blockStatementsContext = ctx.blockStatements();
        if (blockStatementsContext != null) {
            this.push();
            blockStatementsContext.accept(this);
            this.pop();
        }
        if ((tryCatchesContext = ctx.tryCatches()) != null) {
            tryCatchesContext.accept(this);
        }
        if ((tryFinallyContext = ctx.tryFinally()) != null) {
            this.push();
            tryFinallyContext.accept(this);
            this.pop();
        }
        return null;
    }

    @Override
    public Void visitTryCatch(QLParser.TryCatchContext ctx) {
        this.push();
        super.visitTryCatch(ctx);
        this.pop();
        return null;
    }

    @Override
    public Void visitFunctionStatement(QLParser.FunctionStatementContext ctx) {
        QLParser.BlockStatementsContext functionBlockStatements;
        ctx.varId().accept(this);
        QLParser.FormalOrInferredParameterListContext paramList = ctx.formalOrInferredParameterList();
        if (paramList != null) {
            paramList.accept(this);
        }
        if ((functionBlockStatements = ctx.blockStatements()) != null) {
            this.push();
            functionBlockStatements.accept(this);
            this.pop();
        }
        return null;
    }

    public void push() {
        this.existStack = this.existStack.push();
    }

    public void pop() {
        this.existStack = this.existStack.pop();
    }

    public ExistStack getStack() {
        return this.existStack;
    }
}

