/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.UserDefineException;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.util.ThrowUtils;
import com.alibaba.qlexpress4.runtime.util.ValueUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class CallConstInstruction
extends QLInstruction {
    private final QLambda constLambda;
    private final int argNum;
    private final String lambdaName;

    public CallConstInstruction(ErrorReporter errorReporter, QLambda constLambda, int argNum, String lambdaName) {
        super(errorReporter);
        this.constLambda = constLambda;
        this.argNum = argNum;
        this.lambdaName = lambdaName;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Parameters args = qContext.pop(this.argNum);
        Object[] argArr = new Object[this.argNum];
        for (int i = 0; i < this.argNum; ++i) {
            argArr[i] = args.getValue(i);
        }
        try {
            QResult result = this.constLambda.call(argArr);
            qContext.push(ValueUtils.toImmutable(result.getResult()));
            return QResult.NEXT_INSTRUCTION;
        }
        catch (UserDefineException e) {
            throw ThrowUtils.reportUserDefinedException(this.errorReporter, e);
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.EXECUTE_BLOCK_ERROR.name(), QLErrorCodes.EXECUTE_BLOCK_ERROR.getErrorMsg(), new String[0]);
        }
    }

    @Override
    public int stackInput() {
        return this.argNum;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": CallConstLambda " + this.lambdaName, debug);
    }
}

