/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.UserDefineException;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.function.CustomFunction;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.trace.ExpressionTrace;
import com.alibaba.qlexpress4.runtime.util.ThrowUtils;
import com.alibaba.qlexpress4.runtime.util.ValueUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class CallFunctionInstruction
extends QLInstruction {
    private final String functionName;
    private final int argNum;
    private final Integer traceKey;

    public CallFunctionInstruction(ErrorReporter errorReporter, String functionName, int argNum, Integer traceKey) {
        super(errorReporter);
        this.functionName = functionName;
        this.argNum = argNum;
        this.traceKey = traceKey;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        CustomFunction function = qContext.getFunction(this.functionName);
        if (function == null) {
            this.callLambda(qContext, qlOptions);
            return QResult.NEXT_INSTRUCTION;
        }
        Parameters parameters = qContext.pop(this.argNum);
        try {
            Object functionResultObj = function.call(qContext, parameters);
            qContext.push(new DataValue(functionResultObj));
            ExpressionTrace expressionTrace = qContext.getTraces().getExpressionTraceByKey(this.traceKey);
            if (expressionTrace != null) {
                expressionTrace.valueEvaluated(functionResultObj);
            }
            return QResult.NEXT_INSTRUCTION;
        }
        catch (UserDefineException e) {
            throw ThrowUtils.reportUserDefinedException(this.errorReporter, e);
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.INVOKE_FUNCTION_INNER_ERROR.name(), String.format(QLErrorCodes.INVOKE_FUNCTION_INNER_ERROR.getErrorMsg(), this.functionName, t.getMessage()), new String[0]);
        }
    }

    private void callLambda(QContext qContext, QLOptions qlOptions) {
        Object lambdaSymbol = qContext.getSymbolValue(this.functionName);
        if (lambdaSymbol == null) {
            if (!qlOptions.isAvoidNullPointer()) {
                throw this.errorReporter.report(new NullPointerException(), QLErrorCodes.FUNCTION_NOT_FOUND.name(), String.format(QLErrorCodes.FUNCTION_NOT_FOUND.getErrorMsg(), this.functionName));
            }
            qContext.pop(this.argNum);
            qContext.push(DataValue.NULL_VALUE);
            return;
        }
        if (!(lambdaSymbol instanceof QLambda)) {
            throw this.errorReporter.report(QLErrorCodes.FUNCTION_TYPE_MISMATCH.name(), String.format(QLErrorCodes.FUNCTION_TYPE_MISMATCH.getErrorMsg(), this.functionName));
        }
        Parameters parameters = qContext.pop(this.argNum);
        Object[] parametersArr = new Object[parameters.size()];
        for (int i = 0; i < parametersArr.length; ++i) {
            parametersArr[i] = parameters.get(i).get();
        }
        try {
            Value resultValue = ((QLambda)lambdaSymbol).call(parametersArr).getResult();
            qContext.push(ValueUtils.toImmutable(resultValue));
        }
        catch (UserDefineException e) {
            throw ThrowUtils.reportUserDefinedException(this.errorReporter, e);
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.INVOKE_LAMBDA_ERROR.name(), QLErrorCodes.INVOKE_LAMBDA_ERROR.getErrorMsg(), new String[0]);
        }
    }

    @Override
    public int stackInput() {
        return this.argNum;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": CallFunction " + this.functionName + " " + this.argNum, debug);
    }
}

