/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.DelegateQContext;
import com.alibaba.qlexpress4.runtime.ExceptionTable;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinition;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.scope.QScope;
import com.alibaba.qlexpress4.runtime.scope.QvmBlockScope;
import com.alibaba.qlexpress4.runtime.util.ThrowUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.HashMap;
import java.util.function.Consumer;

public class ForInstruction
extends QLInstruction {
    private final QLambdaDefinition forInit;
    private final QLambdaDefinition condition;
    private final ErrorReporter conditionErrorReporter;
    private final QLambdaDefinition forUpdate;
    private final int forScopeMaxStackSize;
    private final QLambdaDefinition forBody;

    public ForInstruction(ErrorReporter errorReporter, QLambdaDefinition forInit, QLambdaDefinition condition, ErrorReporter conditionErrorReporter, QLambdaDefinition forUpdate, int forScopeMaxStackSize, QLambdaDefinition forBody) {
        super(errorReporter);
        this.forInit = forInit;
        this.condition = condition;
        this.conditionErrorReporter = conditionErrorReporter;
        this.forUpdate = forUpdate;
        this.forScopeMaxStackSize = forScopeMaxStackSize;
        this.forBody = forBody;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        QContext forScopeContext;
        QContext qContext2 = forScopeContext = this.needForScope() ? new DelegateQContext(qContext, new QvmBlockScope((QScope)qContext, new HashMap<String, Value>(1), this.forScopeMaxStackSize, ExceptionTable.EMPTY)) : qContext;
        if (this.forInit != null) {
            QLambda initLambda = this.forInit.toLambda(forScopeContext, qlOptions, false);
            try {
                initLambda.call(new Object[0]);
            }
            catch (Throwable t) {
                throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.FOR_INIT_ERROR.name(), QLErrorCodes.FOR_INIT_ERROR.getErrorMsg(), new String[0]);
            }
        }
        QLambda conditionLambda = this.condition != null ? this.condition.toLambda(forScopeContext, qlOptions, false) : null;
        QLambda updateLambda = this.forUpdate != null ? this.forUpdate.toLambda(forScopeContext, qlOptions, false) : null;
        QLambda bodyLambda = this.forBody.toLambda(forScopeContext, qlOptions, true);
        block8: while (conditionLambda == null || this.evalCondition(conditionLambda)) {
            try {
                QResult bodyResult = bodyLambda.call(new Object[0]);
                switch (bodyResult.getResultType()) {
                    case RETURN: {
                        return bodyResult;
                    }
                    case BREAK: {
                        break block8;
                    }
                }
            }
            catch (Throwable t) {
                throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.FOR_BODY_ERROR.name(), QLErrorCodes.FOR_BODY_ERROR.getErrorMsg(), new String[0]);
            }
            if (updateLambda == null) continue;
            this.runUpdate(updateLambda);
        }
        return QResult.NEXT_INSTRUCTION;
    }

    private boolean needForScope() {
        return this.forInit != null || this.condition != null || this.forUpdate != null;
    }

    private void runUpdate(QLambda updateLambda) {
        try {
            updateLambda.call(new Object[0]);
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.errorReporter, QLErrorCodes.FOR_UPDATE_ERROR.name(), QLErrorCodes.FOR_UPDATE_ERROR.getErrorMsg(), new String[0]);
        }
    }

    private boolean evalCondition(QLambda conditionLambda) {
        try {
            Object conditionResult = conditionLambda.call(new Object[0]).getResult().get();
            if (!(conditionResult instanceof Boolean)) {
                throw this.conditionErrorReporter.report(QLErrorCodes.FOR_CONDITION_BOOL_REQUIRED.name(), QLErrorCodes.FOR_CONDITION_BOOL_REQUIRED.getErrorMsg());
            }
            return (Boolean)conditionResult;
        }
        catch (Throwable t) {
            throw ThrowUtils.wrapThrowable(t, this.conditionErrorReporter, QLErrorCodes.FOR_CONDITION_ERROR.name(), QLErrorCodes.FOR_CONDITION_ERROR.getErrorMsg(), new String[0]);
        }
    }

    @Override
    public int stackInput() {
        return 0;
    }

    @Override
    public int stackOutput() {
        return 0;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": For", debug);
        PrintlnUtils.printlnByCurDepth(depth + 1, "Init", debug);
        if (this.forInit != null) {
            this.forInit.println(depth + 2, debug);
        }
        PrintlnUtils.printlnByCurDepth(depth + 1, "Condition", debug);
        if (this.condition != null) {
            this.condition.println(depth + 2, debug);
        }
        PrintlnUtils.printlnByCurDepth(depth + 1, "Update", debug);
        if (this.forUpdate != null) {
            this.forUpdate.println(depth + 2, debug);
        }
        PrintlnUtils.printlnByCurDepth(depth + 1, "Body", debug);
        this.forBody.println(depth + 2, debug);
    }
}

