/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.trace.ExpressionTrace;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class LoadInstruction
extends QLInstruction {
    private final String name;
    private final Integer traceKey;

    public LoadInstruction(ErrorReporter errorReporter, String name, Integer traceKey) {
        super(errorReporter);
        this.name = name;
        this.traceKey = traceKey;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Value symbolValue = qContext.getSymbol(this.name);
        qContext.push(symbolValue);
        ExpressionTrace expressionTrace = qContext.getTraces().getExpressionTraceByKey(this.traceKey);
        if (expressionTrace != null) {
            expressionTrace.valueEvaluated(symbolValue.get());
        }
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return 0;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": Load " + this.name, debug);
    }
}

