/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.LeftValue;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Consumer;

public class NewFilledInstanceInstruction
extends QLInstruction {
    private final Class<?> newCls;
    private final List<String> keys;

    public NewFilledInstanceInstruction(ErrorReporter errorReporter, Class<?> newCls, List<String> keys) {
        super(errorReporter);
        this.newCls = newCls;
        this.keys = keys;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Object instance = this.newInstance(qContext);
        Parameters initItems = qContext.pop(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            Object initValue = initItems.get(i).get();
            String fieldName = this.keys.get(i);
            Value fieldValue = qContext.getReflectLoader().loadField(instance, fieldName, false, this.errorReporter);
            if (fieldValue == null) continue;
            if (!(fieldValue instanceof LeftValue)) {
                throw this.errorReporter.reportFormat(QLErrorCodes.INVALID_ASSIGNMENT.name(), QLErrorCodes.INVALID_ASSIGNMENT.getErrorMsg(), "of field '" + fieldName + "'");
            }
            ((LeftValue)fieldValue).set(initValue, this.errorReporter);
        }
        qContext.push(new DataValue(instance));
        return QResult.NEXT_INSTRUCTION;
    }

    private Object newInstance(QContext qContext) {
        Constructor<?> constructor = qContext.getReflectLoader().loadConstructor(this.newCls, new Class[0]);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw this.errorReporter.report(e.getTargetException(), QLErrorCodes.INVOKE_CONSTRUCTOR_INNER_ERROR.name(), QLErrorCodes.INVOKE_CONSTRUCTOR_INNER_ERROR.getErrorMsg());
        }
        catch (Exception e) {
            throw this.errorReporter.report(QLErrorCodes.INVOKE_CONSTRUCTOR_UNKNOWN_ERROR.name(), QLErrorCodes.INVOKE_CONSTRUCTOR_UNKNOWN_ERROR.getErrorMsg());
        }
    }

    @Override
    public int stackInput() {
        return this.keys.size();
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": New instace of cls " + this.newCls.getSimpleName() + " with fields " + this.keys, debug);
    }
}

