/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.trace.ExpressionTrace;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class ReturnInstruction
extends QLInstruction {
    private final QResult.ResultType resultType;
    private final Integer traceKey;

    public ReturnInstruction(ErrorReporter errorReporter, QResult.ResultType resultType, Integer traceKey) {
        super(errorReporter);
        this.resultType = resultType;
        this.traceKey = traceKey;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        ExpressionTrace expressionTrace;
        Value returnValue = qContext.pop();
        if (this.traceKey != null && (expressionTrace = qContext.getTraces().getExpressionTraceByKey(this.traceKey)) != null) {
            expressionTrace.valueEvaluated(returnValue.get());
        }
        return new QResult(new DataValue(returnValue.get()), this.resultType);
    }

    @Override
    public int stackInput() {
        return 1;
    }

    @Override
    public int stackOutput() {
        return 0;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": Return", debug);
    }
}

