/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.util.ValueUtils;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SliceInstruction
extends QLInstruction {
    private final Mode mode;

    public SliceInstruction(ErrorReporter errorReporter, Mode mode) {
        super(errorReporter);
        this.mode = mode;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Object result;
        Object end;
        int startInt = 0;
        int endInt = 0;
        Object indexAble = null;
        if (this.mode == Mode.BOTH) {
            end = qContext.pop().get();
            Object start = qContext.pop().get();
            indexAble = qContext.pop().get();
            startInt = ValueUtils.assertType(start, Number.class, QLErrorCodes.INVALID_INDEX.name(), QLErrorCodes.INVALID_INDEX.getErrorMsg(), this.errorReporter).intValue();
            endInt = ValueUtils.assertType(end, Number.class, QLErrorCodes.INVALID_INDEX.name(), QLErrorCodes.INVALID_INDEX.getErrorMsg(), this.errorReporter).intValue();
        } else if (this.mode == Mode.LEFT) {
            end = qContext.pop().get();
            indexAble = qContext.pop().get();
            endInt = ValueUtils.assertType(end, Number.class, QLErrorCodes.INVALID_INDEX.name(), QLErrorCodes.INVALID_INDEX.getErrorMsg(), this.errorReporter).intValue();
        } else if (this.mode == Mode.RIGHT) {
            Object start = qContext.pop().get();
            indexAble = qContext.pop().get();
            startInt = ValueUtils.assertType(start, Number.class, QLErrorCodes.INVALID_INDEX.name(), QLErrorCodes.INVALID_INDEX.getErrorMsg(), this.errorReporter).intValue();
            endInt = this.indexAbleLen(indexAble);
        } else if (this.mode == Mode.COPY) {
            indexAble = qContext.pop().get();
            endInt = this.indexAbleLen(indexAble);
        }
        if (indexAble instanceof List) {
            result = this.listSlice((List)indexAble, startInt, endInt);
            qContext.push(new DataValue(result));
            return QResult.NEXT_INSTRUCTION;
        }
        if (indexAble != null && indexAble.getClass().isArray()) {
            result = this.arraySlice(indexAble, startInt, endInt);
            qContext.push(new DataValue(result));
            return QResult.NEXT_INSTRUCTION;
        }
        if (indexAble == null && qlOptions.isAvoidNullPointer()) {
            qContext.push(Value.NULL_VALUE);
            return QResult.NEXT_INSTRUCTION;
        }
        throw this.errorReporter.reportFormat(QLErrorCodes.NONINDEXABLE_OBJECT.name(), QLErrorCodes.NONINDEXABLE_OBJECT.getErrorMsg(), indexAble == null ? "null" : indexAble.getClass().getName());
    }

    private int indexAbleLen(Object indexAble) {
        if (indexAble instanceof List) {
            return ((List)indexAble).size();
        }
        if (indexAble != null && indexAble.getClass().isArray()) {
            return Array.getLength(indexAble);
        }
        throw this.errorReporter.reportFormat(QLErrorCodes.NONINDEXABLE_OBJECT.name(), QLErrorCodes.NONINDEXABLE_OBJECT.getErrorMsg(), indexAble == null ? "null" : indexAble.getClass().getName());
    }

    private List<?> listSlice(List<?> listObj, int originStart, int originEnd) {
        int end;
        int start = Math.max(ValueUtils.javaIndex(listObj.size(), originStart), 0);
        if (start >= (end = Math.min(ValueUtils.javaIndex(listObj.size(), originEnd), listObj.size()))) {
            return new ArrayList(0);
        }
        return listObj.subList(start, end);
    }

    private Object arraySlice(Object arrObj, int originStart, int originEnd) {
        int end;
        int arrLen = Array.getLength(arrObj);
        int start = Math.max(ValueUtils.javaIndex(arrLen, originStart), 0);
        if (start >= (end = Math.min(ValueUtils.javaIndex(arrLen, originEnd), arrLen))) {
            return Array.newInstance(arrObj.getClass().getComponentType(), 0);
        }
        Object newArr = Array.newInstance(arrObj.getClass().getComponentType(), end - start);
        for (int i = start; i < end; ++i) {
            Array.set(newArr, i - start, Array.get(arrObj, i));
        }
        return newArr;
    }

    @Override
    public int stackInput() {
        if (this.mode == Mode.BOTH) {
            return 2;
        }
        if (this.mode == Mode.COPY) {
            return 0;
        }
        return 1;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": Slice", debug);
    }

    public static enum Mode {
        LEFT,
        RIGHT,
        BOTH,
        COPY;

    }
}

