/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.operator.number;

import com.alibaba.qlexpress4.runtime.operator.number.BigDecimalMath;
import com.alibaba.qlexpress4.runtime.operator.number.NumberMath;

public final class LongMath
extends NumberMath {
    public static final LongMath INSTANCE = new LongMath();

    private LongMath() {
    }

    @Override
    public Number absImpl(Number number) {
        return Math.abs(number.longValue());
    }

    @Override
    public Number addImpl(Number left, Number right) {
        return left.longValue() + right.longValue();
    }

    @Override
    public Number subtractImpl(Number left, Number right) {
        return left.longValue() - right.longValue();
    }

    @Override
    public Number multiplyImpl(Number left, Number right) {
        return left.longValue() * right.longValue();
    }

    @Override
    public Number divideImpl(Number left, Number right) {
        return BigDecimalMath.INSTANCE.divideImpl(left, right);
    }

    @Override
    public int compareToImpl(Number left, Number right) {
        long leftVal = left.longValue();
        long rightVal = right.longValue();
        return Long.compare(leftVal, rightVal);
    }

    @Override
    public Number intDivImpl(Number left, Number right) {
        return left.longValue() / right.longValue();
    }

    @Override
    public Number remainderImpl(Number left, Number right) {
        return left.longValue() % right.longValue();
    }

    @Override
    public Number modImpl(Number left, Number right) {
        return LongMath.toBigInteger(left).mod(LongMath.toBigInteger(right)).longValue();
    }

    @Override
    public Number unaryMinusImpl(Number left) {
        return -left.longValue();
    }

    @Override
    public Number unaryPlusImpl(Number left) {
        return left.longValue();
    }

    @Override
    public Number bitwiseNegateImpl(Number left) {
        return left.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public Number orImpl(Number left, Number right) {
        return left.longValue() | right.longValue();
    }

    @Override
    public Number andImpl(Number left, Number right) {
        return left.longValue() & right.longValue();
    }

    @Override
    public Number xorImpl(Number left, Number right) {
        return left.longValue() ^ right.longValue();
    }

    @Override
    public Number leftShiftImpl(Number left, Number right) {
        return left.longValue() << (int)right.longValue();
    }

    @Override
    public Number rightShiftImpl(Number left, Number right) {
        return left.longValue() >> (int)right.longValue();
    }

    @Override
    public Number rightShiftUnsignedImpl(Number left, Number right) {
        return left.longValue() >>> (int)right.longValue();
    }

    public Number bitAndImpl(Number left, Number right) {
        return left.longValue() & right.longValue();
    }
}

