/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.logging.initializer;

import com.alipay.sofa.boot.logging.filter.DefaultLog4j2FilterGenerator;
import com.alipay.sofa.boot.logging.util.SystemPropertiesGetter;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.spi.Log4j2ReInitializer;
import com.alipay.sofa.common.utils.ResourceUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;

public class DefaultLog4j2ReInitializer
implements Log4j2ReInitializer {
    private static final String FILE_PROTOCOL = "file";
    private static final String SOFA_CONSOLE = "sofa-console";

    public void reInitialize(final SpaceId spaceId, LoggerContext loggerContext, final Properties properties, URL confFile) {
        if (this.isAlreadyReInitialized(loggerContext)) {
            return;
        }
        loggerContext.removeFilter(DefaultLog4j2FilterGenerator.FILTER);
        this.initLogContext(properties);
        this.markAsReInitialized(loggerContext);
        if (this.isConsoleAppenderOpen(spaceId.getSpaceName(), properties)) {
            final ConsoleAppender consoleAppender = this.consoleAppender(properties);
            loggerContext.addFilter((Filter)new AbstractFilter(){

                public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
                    if (!logger.getAppenders().containsKey(DefaultLog4j2ReInitializer.SOFA_CONSOLE)) {
                        this.resetLog(logger);
                    }
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
                    if (!logger.getAppenders().containsKey(DefaultLog4j2ReInitializer.SOFA_CONSOLE)) {
                        this.resetLog(logger);
                    }
                    return Filter.Result.NEUTRAL;
                }

                public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
                    if (!logger.getAppenders().containsKey(DefaultLog4j2ReInitializer.SOFA_CONSOLE)) {
                        this.resetLog(logger);
                    }
                    return Filter.Result.NEUTRAL;
                }

                private void resetLog(Logger logger) {
                    logger.getAppenders().clear();
                    logger.addAppender((Appender)consoleAppender);
                    logger.setLevel(DefaultLog4j2ReInitializer.this.getConsoleLevel(spaceId.getSpaceName(), properties));
                    logger.setAdditive(false);
                }
            });
        } else {
            try {
                loggerContext.setExternalContext(null);
                ConfigurationSource source = this.getConfigurationSource(confFile);
                Configuration config = ConfigurationFactory.getInstance().getConfiguration(loggerContext, source);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
                }
                loggerContext.start(config);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("log4j2 loggerSpaceFactory re-build error", ex);
            }
        }
    }

    private Level getConsoleLevel(String spaceId, Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        String level = propertiesGetter.getProperty("sofa.middleware.log.console.level");
        String defaultLevel = StringUtil.isBlank((String)level) ? "INFO" : level;
        level = propertiesGetter.getProperty(String.format("sofa.middleware.log.%s.console.level", spaceId), defaultLevel);
        return Level.toLevel((String)level, (Level)Level.INFO);
    }

    private ConsoleAppender consoleAppender(Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        String logPattern = propertiesGetter.getProperty("sofa.middleware.log.console.log4j2.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p %X{PID} --- [%15.15t] %-40.40logger{39} : %m%n");
        ConsoleAppender.Builder builder = ConsoleAppender.newBuilder();
        builder.withLayout((Layout)PatternLayout.newBuilder().withPattern(logPattern).build()).withName(SOFA_CONSOLE);
        ConsoleAppender consoleAppender = builder.build();
        consoleAppender.start();
        return consoleAppender;
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, ResourceUtil.getFile((URL)url));
        }
        return new ConfigurationSource(stream, url);
    }

    private boolean isAlreadyReInitialized(LoggerContext loggerContext) {
        return loggerContext.getConfiguration().getProperties().get(DefaultLog4j2ReInitializer.class.getCanonicalName()) != null;
    }

    private void markAsReInitialized(LoggerContext loggerContext) {
        loggerContext.getConfiguration().getProperties().put(DefaultLog4j2ReInitializer.class.getCanonicalName(), "");
    }

    private void initLogContext(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ThreadContext.put((String)((String)entry.getKey()), (String)properties.getProperty((String)entry.getKey()));
        }
    }

    private boolean isConsoleAppenderOpen(String spaceId, Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        String value = propertiesGetter.getProperty(String.format("sofa.middleware.log.%s.console", spaceId));
        if (StringUtil.isBlank((String)value)) {
            return "true".equalsIgnoreCase(propertiesGetter.getProperty("sofa.middleware.log.console"));
        }
        return "true".equalsIgnoreCase(value);
    }
}

