/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.security;

import com.alipay.sofa.security.SecurityUtils;
import com.alipay.sofa.security.crypto.AsymmetricCryptoUtil;
import com.alipay.sofa.security.crypto.SymmetricCryptoUtil;
import com.alipay.sofa.security.exception.IdentityInitException;
import com.alipay.sofa.security.exception.IdentityNotInitException;
import com.alipay.sofa.security.exception.SymmetricKeyCannotFoundException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;

public enum SecuritySingleton {
    INSTANCE{
        private volatile byte[] IDENTITY;
        private final Map<String, byte[]> SYMM_SKEYS = new ConcurrentHashMap<String, byte[]>();
        private final Map<String, byte[]> ENCRIPTED_SYMM_SKEYS = new ConcurrentHashMap<String, byte[]>();
        private volatile AtomicBoolean INITED = new AtomicBoolean(false);

        @Override
        public void init(String path) throws IdentityInitException {
            if (!this.INITED.compareAndSet(false, true)) {
                return;
            }
            if (!SecurityUtils.isSecurityMode()) {
                return;
            }
            try {
                FileInputStream is = new FileInputStream(path);
                byte magicNum = (byte)((InputStream)is).read();
                byte version1 = (byte)((InputStream)is).read();
                byte version2 = (byte)((InputStream)is).read();
                ((InputStream)is).read();
                if (magicNum != 0 || version1 != 0 || version2 != 0) {
                    throw new IOException("identity header is wrong!");
                }
                byte[] buffer = new byte[((InputStream)is).available()];
                ((InputStream)is).read(buffer);
                ((InputStream)is).close();
                this.IDENTITY = SymmetricCryptoUtil.symmetricCrypto(buffer, Base64.decodeBase64((String)"stp+tTxeBYcbgrOA0SL1HQ=="), "AES", 2);
            }
            catch (Throwable e) {
                throw new IdentityInitException(e.getMessage(), e);
            }
        }

        @Override
        public void init(byte[] bytes) throws IdentityInitException {
            if (!this.INITED.compareAndSet(false, true)) {
                return;
            }
            if (!SecurityUtils.isSecurityMode()) {
                return;
            }
            try {
                this.IDENTITY = SymmetricCryptoUtil.symmetricCrypto(bytes, Base64.decodeBase64((String)"stp+tTxeBYcbgrOA0SL1HQ=="), "AES", 2);
            }
            catch (Throwable e) {
                throw new IdentityInitException(e.getMessage(), e);
            }
        }

        @Override
        public byte[] encryptByIdentity(byte[] data) throws GeneralSecurityException {
            if (this.IDENTITY == null) {
                throw new IdentityNotInitException();
            }
            return AsymmetricCryptoUtil.asymmetricCryptoReverse(data, this.IDENTITY, "RSA", 1);
        }

        @Override
        public byte[] encryptByIdentity(byte[] data, int dataOffset, int dataLen) throws GeneralSecurityException {
            if (this.IDENTITY == null) {
                throw new IdentityNotInitException();
            }
            return AsymmetricCryptoUtil.asymmetricCryptoReverse(data, this.IDENTITY, dataOffset, dataLen, "RSA", 1);
        }

        @Override
        public byte[] encryptByPubKey(byte[] data, byte[] pubKey) throws GeneralSecurityException {
            return AsymmetricCryptoUtil.asymmetricCrypto(data, pubKey, "RSA", 1);
        }

        @Override
        public byte[] encryptByPubKey(byte[] data, byte[] pubKey, int dataOffset, int dataLen) throws GeneralSecurityException {
            return AsymmetricCryptoUtil.asymmetricCrypto(data, pubKey, dataOffset, dataLen, "RSA", 1);
        }

        @Override
        public byte[] encryptBySymmKey(byte[] data, String sKey) throws GeneralSecurityException {
            byte[] symmKey = this.SYMM_SKEYS.get(sKey);
            if (symmKey == null) {
                throw new SymmetricKeyCannotFoundException(sKey);
            }
            return SymmetricCryptoUtil.symmetricCrypto(data, symmKey, "AES", 1);
        }

        @Override
        public byte[] encryptBySymmKey(byte[] data, String sKey, int dataOffset, int dataLen) throws GeneralSecurityException {
            byte[] symmKey = this.SYMM_SKEYS.get(sKey);
            if (symmKey == null) {
                throw new SymmetricKeyCannotFoundException(sKey);
            }
            return SymmetricCryptoUtil.symmetricCrypto(data, symmKey, dataOffset, dataLen, "AES", 1);
        }

        @Override
        public byte[] decryptByIdentity(byte[] data) throws GeneralSecurityException {
            if (this.IDENTITY == null) {
                throw new IdentityNotInitException();
            }
            return AsymmetricCryptoUtil.asymmetricCrypto(data, this.IDENTITY, "RSA", 2);
        }

        @Override
        public byte[] decryptByIdentity(byte[] data, int dataOffset, int dataLen) throws GeneralSecurityException {
            if (this.IDENTITY == null) {
                throw new IdentityNotInitException();
            }
            return AsymmetricCryptoUtil.asymmetricCrypto(data, this.IDENTITY, dataOffset, dataLen, "RSA", 2);
        }

        @Override
        public byte[] decryptByPubKey(byte[] data, byte[] pubKey) throws GeneralSecurityException {
            return AsymmetricCryptoUtil.asymmetricCryptoReverse(data, pubKey, "RSA", 2);
        }

        @Override
        public byte[] decryptByPubKey(byte[] data, byte[] pubKey, int dataOffset, int dataLen) throws GeneralSecurityException {
            return AsymmetricCryptoUtil.asymmetricCryptoReverse(data, pubKey, dataOffset, dataLen, "RSA", 2);
        }

        @Override
        public byte[] decryptBySymmKey(byte[] data, String sKey) throws GeneralSecurityException {
            byte[] symmKey = this.SYMM_SKEYS.get(sKey);
            if (symmKey == null) {
                throw new SymmetricKeyCannotFoundException(sKey);
            }
            return SymmetricCryptoUtil.symmetricCrypto(data, symmKey, "AES", 2);
        }

        @Override
        public byte[] decryptBySymmKey(byte[] data, String sKey, int dataOffset, int dataLen) throws GeneralSecurityException {
            byte[] symmKey = this.SYMM_SKEYS.get(sKey);
            if (symmKey == null) {
                throw new SymmetricKeyCannotFoundException(sKey);
            }
            return SymmetricCryptoUtil.symmetricCrypto(data, symmKey, dataOffset, dataLen, "AES", 2);
        }

        @Override
        public void registerSymmKey(String skey, byte[] symmetricKey) {
            if (skey == null || skey.isEmpty()) {
                return;
            }
            this.SYMM_SKEYS.put(skey, symmetricKey);
        }

        @Override
        public void registerEncryptedSymmKey(String skey, byte[] symmetricKey) {
            if (skey == null || skey.isEmpty()) {
                return;
            }
            this.ENCRIPTED_SYMM_SKEYS.put(skey, symmetricKey);
        }

        @Override
        public byte[] getEncryptedSymmKey(String skey) {
            if (skey == null || skey.isEmpty()) {
                return null;
            }
            return this.ENCRIPTED_SYMM_SKEYS.get(skey);
        }

        @Override
        public boolean hasSymmKey(String skey) {
            if (skey == null || skey.isEmpty()) {
                return false;
            }
            return this.SYMM_SKEYS.containsKey(skey);
        }
    };


    public abstract void init(String var1) throws IdentityInitException;

    public abstract void init(byte[] var1) throws IdentityInitException;

    public abstract byte[] encryptByIdentity(byte[] var1) throws GeneralSecurityException;

    public abstract byte[] encryptByIdentity(byte[] var1, int var2, int var3) throws GeneralSecurityException;

    public abstract byte[] encryptByPubKey(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public abstract byte[] encryptByPubKey(byte[] var1, byte[] var2, int var3, int var4) throws GeneralSecurityException;

    public abstract byte[] encryptBySymmKey(byte[] var1, String var2) throws GeneralSecurityException;

    public abstract byte[] encryptBySymmKey(byte[] var1, String var2, int var3, int var4) throws GeneralSecurityException;

    public abstract byte[] decryptByIdentity(byte[] var1) throws GeneralSecurityException;

    public abstract byte[] decryptByIdentity(byte[] var1, int var2, int var3) throws GeneralSecurityException;

    public abstract byte[] decryptByPubKey(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public abstract byte[] decryptByPubKey(byte[] var1, byte[] var2, int var3, int var4) throws GeneralSecurityException;

    public abstract byte[] decryptBySymmKey(byte[] var1, String var2) throws GeneralSecurityException;

    public abstract byte[] decryptBySymmKey(byte[] var1, String var2, int var3, int var4) throws GeneralSecurityException;

    public abstract void registerSymmKey(String var1, byte[] var2);

    public abstract void registerEncryptedSymmKey(String var1, byte[] var2);

    public abstract byte[] getEncryptedSymmKey(String var1);

    public abstract boolean hasSymmKey(String var1);
}

