/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.security;

import com.alipay.sofa.security.crypto.SymmetricCryptoUtil;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class SecurityUtils {
    public static volatile int securityMode = 0;
    public static volatile int decryptSecurityMode = 0;
    public static volatile int encryptSecurityMode = 0;

    public static void initSecurityMode() {
        String mode = System.getProperty("securitymode");
        if ("STRICT".equalsIgnoreCase(mode)) {
            securityMode = 1;
            decryptSecurityMode = 1;
            encryptSecurityMode = 1;
        } else if ("FLEXIBLE".equalsIgnoreCase(mode)) {
            securityMode = 2;
            decryptSecurityMode = 2;
            encryptSecurityMode = 2;
        }
    }

    public static byte[] generateIdentityData(byte[] identity) {
        try {
            byte[] encryptedBytes = SymmetricCryptoUtil.symmetricCrypto(identity, Base64.decodeBase64((String)"stp+tTxeBYcbgrOA0SL1HQ=="), "AES", 1);
            byte[] bytes = new byte[encryptedBytes.length + 4];
            bytes[0] = 0;
            bytes[1] = 0;
            bytes[2] = 0;
            bytes[3] = 0;
            System.arraycopy(encryptedBytes, 0, bytes, 4, encryptedBytes.length);
            return bytes;
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] generateSymmetricKey() throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(128);
        SecretKey key = kg.generateKey();
        return key.getEncoded();
    }

    public static KeyPair generateAsymmetricKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    public static boolean isSecurityMode() {
        return securityMode > 0;
    }

    public static boolean isFlexibleMode() {
        return securityMode == 2;
    }

    public static boolean isDecryptFlexibleMode() {
        return decryptSecurityMode == 2;
    }

    public static boolean isEncryptFlexibleMode() {
        return encryptSecurityMode == 2;
    }

    public static boolean isStrictMode() {
        return securityMode == 1;
    }

    static {
        SecurityUtils.initSecurityMode();
    }
}

